import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermContainerRegistryTokenConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token#container_registry_name DataAzurermContainerRegistryToken#container_registry_name}.
     *
     * @stability stable
     */
    readonly containerRegistryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token#name DataAzurermContainerRegistryToken#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token#resource_group_name DataAzurermContainerRegistryToken#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token#timeouts DataAzurermContainerRegistryToken#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermContainerRegistryTokenTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermContainerRegistryTokenTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token#read DataAzurermContainerRegistryToken#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermContainerRegistryTokenTimeoutsToTerraform(struct?: DataAzurermContainerRegistryTokenTimeoutsOutputReference | DataAzurermContainerRegistryTokenTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermContainerRegistryTokenTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermContainerRegistryTokenTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermContainerRegistryTokenTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token azurerm_container_registry_token}.
 *
 * @stability stable
 */
export declare class DataAzurermContainerRegistryToken extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token azurerm_container_registry_token} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermContainerRegistryTokenConfig);
    private _containerRegistryName?;
    /**
     * @stability stable
     */
    get containerRegistryName(): string;
    /**
     * @stability stable
     */
    set containerRegistryName(value: string);
    /**
     * @stability stable
     */
    get containerRegistryNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get scopeMapId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermContainerRegistryTokenTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermContainerRegistryTokenTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermContainerRegistryTokenTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
