import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermCosmosdbAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account#name DataAzurermCosmosdbAccount#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account#resource_group_name DataAzurermCosmosdbAccount#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account#timeouts DataAzurermCosmosdbAccount#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermCosmosdbAccountTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermCosmosdbAccountCapabilities extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermCosmosdbAccountConsistencyPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get consistencyLevel(): string;
    /**
     * @stability stable
     */
    get maxIntervalInSeconds(): number;
    /**
     * @stability stable
     */
    get maxStalenessPrefix(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermCosmosdbAccountGeoLocation extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get failoverPriority(): number;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermCosmosdbAccountVirtualNetworkRule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermCosmosdbAccountTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account#read DataAzurermCosmosdbAccount#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermCosmosdbAccountTimeoutsToTerraform(struct?: DataAzurermCosmosdbAccountTimeoutsOutputReference | DataAzurermCosmosdbAccountTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermCosmosdbAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermCosmosdbAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermCosmosdbAccountTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account azurerm_cosmosdb_account}.
 *
 * @stability stable
 */
export declare class DataAzurermCosmosdbAccount extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_account azurerm_cosmosdb_account} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermCosmosdbAccountConfig);
    /**
     * @stability stable
     */
    capabilities(index: string): DataAzurermCosmosdbAccountCapabilities;
    /**
     * @stability stable
     */
    consistencyPolicy(index: string): DataAzurermCosmosdbAccountConsistencyPolicy;
    /**
     * @stability stable
     */
    get enableAutomaticFailover(): any;
    /**
     * @stability stable
     */
    get enableFreeTier(): any;
    /**
     * @stability stable
     */
    get enableMultipleWriteLocations(): any;
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    geoLocation(index: string): DataAzurermCosmosdbAccountGeoLocation;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ipRangeFilter(): string;
    /**
     * @stability stable
     */
    get isVirtualNetworkFilterEnabled(): any;
    /**
     * @stability stable
     */
    get keyVaultKeyId(): string;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get offerType(): string;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    /**
     * @stability stable
     */
    get primaryMasterKey(): string;
    /**
     * @stability stable
     */
    get primaryReadonlyKey(): string;
    /**
     * @stability stable
     */
    get primaryReadonlyMasterKey(): string;
    /**
     * @stability stable
     */
    get readEndpoints(): string[];
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
    /**
     * @stability stable
     */
    get secondaryMasterKey(): string;
    /**
     * @stability stable
     */
    get secondaryReadonlyKey(): string;
    /**
     * @stability stable
     */
    get secondaryReadonlyMasterKey(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    virtualNetworkRule(index: string): DataAzurermCosmosdbAccountVirtualNetworkRule;
    /**
     * @stability stable
     */
    get writeEndpoints(): string[];
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermCosmosdbAccountTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermCosmosdbAccountTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermCosmosdbAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
