import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDataShareDatasetDataLakeGen2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen2#name DataAzurermDataShareDatasetDataLakeGen2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen2#share_id DataAzurermDataShareDatasetDataLakeGen2#share_id}.
     *
     * @stability stable
     */
    readonly shareId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen2#timeouts DataAzurermDataShareDatasetDataLakeGen2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDataShareDatasetDataLakeGen2Timeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermDataShareDatasetDataLakeGen2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen2#read DataAzurermDataShareDatasetDataLakeGen2#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDataShareDatasetDataLakeGen2TimeoutsToTerraform(struct?: DataAzurermDataShareDatasetDataLakeGen2TimeoutsOutputReference | DataAzurermDataShareDatasetDataLakeGen2Timeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermDataShareDatasetDataLakeGen2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDataShareDatasetDataLakeGen2Timeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDataShareDatasetDataLakeGen2Timeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen2 azurerm_data_share_dataset_data_lake_gen2}.
 *
 * @stability stable
 */
export declare class DataAzurermDataShareDatasetDataLakeGen2 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen2 azurerm_data_share_dataset_data_lake_gen2} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareDatasetDataLakeGen2Config);
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get filePath(): string;
    /**
     * @stability stable
     */
    get fileSystemName(): string;
    /**
     * @stability stable
     */
    get folderPath(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _shareId?;
    /**
     * @stability stable
     */
    get shareId(): string;
    /**
     * @stability stable
     */
    set shareId(value: string);
    /**
     * @stability stable
     */
    get shareIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDataShareDatasetDataLakeGen2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDataShareDatasetDataLakeGen2Timeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDataShareDatasetDataLakeGen2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
