import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDataShareConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share#account_id DataAzurermDataShare#account_id}.
     *
     * @stability stable
     */
    readonly accountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share#name DataAzurermDataShare#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share#timeouts DataAzurermDataShare#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDataShareTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermDataShareSnapshotSchedule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get recurrence(): string;
    /**
     * @stability stable
     */
    get startTime(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermDataShareTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share#read DataAzurermDataShare#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDataShareTimeoutsToTerraform(struct?: DataAzurermDataShareTimeoutsOutputReference | DataAzurermDataShareTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermDataShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDataShareTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDataShareTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_share azurerm_data_share}.
 *
 * @stability stable
 */
export declare class DataAzurermDataShare extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_share azurerm_data_share} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareConfig);
    private _accountId?;
    /**
     * @stability stable
     */
    get accountId(): string;
    /**
     * @stability stable
     */
    set accountId(value: string);
    /**
     * @stability stable
     */
    get accountIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kind(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    snapshotSchedule(index: string): DataAzurermDataShareSnapshotSchedule;
    /**
     * @stability stable
     */
    get terms(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDataShareTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDataShareTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDataShareTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
