import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermFirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy#name DataAzurermFirewallPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy#resource_group_name DataAzurermFirewallPolicy#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy#timeouts DataAzurermFirewallPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermFirewallPolicyTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermFirewallPolicyDns extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get networkRuleFqdnEnabled(): any;
    /**
     * @stability stable
     */
    get proxyEnabled(): any;
    /**
     * @stability stable
     */
    get servers(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermFirewallPolicyThreatIntelligenceAllowlist extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get fqdns(): string[];
    /**
     * @stability stable
     */
    get ipAddresses(): string[];
}
/**
 * @stability stable
 */
export interface DataAzurermFirewallPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy#read DataAzurermFirewallPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermFirewallPolicyTimeoutsToTerraform(struct?: DataAzurermFirewallPolicyTimeoutsOutputReference | DataAzurermFirewallPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermFirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermFirewallPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermFirewallPolicyTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy azurerm_firewall_policy}.
 *
 * @stability stable
 */
export declare class DataAzurermFirewallPolicy extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy azurerm_firewall_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermFirewallPolicyConfig);
    /**
     * @stability stable
     */
    get basePolicyId(): string;
    /**
     * @stability stable
     */
    get childPolicies(): string[];
    /**
     * @stability stable
     */
    dns(index: string): DataAzurermFirewallPolicyDns;
    /**
     * @stability stable
     */
    get firewalls(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get ruleCollectionGroups(): string[];
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    threatIntelligenceAllowlist(index: string): DataAzurermFirewallPolicyThreatIntelligenceAllowlist;
    /**
     * @stability stable
     */
    get threatIntelligenceMode(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermFirewallPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermFirewallPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermFirewallPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
