import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermFirewallConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall#name DataAzurermFirewall#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall#resource_group_name DataAzurermFirewall#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall#timeouts DataAzurermFirewall#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermFirewallTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermFirewallIpConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    /**
     * @stability stable
     */
    get publicIpAddressId(): string;
    /**
     * @stability stable
     */
    get subnetId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermFirewallManagementIpConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    /**
     * @stability stable
     */
    get publicIpAddressId(): string;
    /**
     * @stability stable
     */
    get subnetId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermFirewallVirtualHub extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    /**
     * @stability stable
     */
    get publicIpAddresses(): string[];
    /**
     * @stability stable
     */
    get publicIpCount(): number;
    /**
     * @stability stable
     */
    get virtualHubId(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermFirewallTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall#read DataAzurermFirewall#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermFirewallTimeoutsToTerraform(struct?: DataAzurermFirewallTimeoutsOutputReference | DataAzurermFirewallTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermFirewallTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermFirewallTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermFirewallTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/firewall azurerm_firewall}.
 *
 * @stability stable
 */
export declare class DataAzurermFirewall extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/firewall azurerm_firewall} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermFirewallConfig);
    /**
     * @stability stable
     */
    get dnsServers(): string[];
    /**
     * @stability stable
     */
    get firewallPolicyId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    ipConfiguration(index: string): DataAzurermFirewallIpConfiguration;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    managementIpConfiguration(index: string): DataAzurermFirewallManagementIpConfiguration;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    get skuTier(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get threatIntelMode(): string;
    /**
     * @stability stable
     */
    virtualHub(index: string): DataAzurermFirewallVirtualHub;
    /**
     * @stability stable
     */
    get zones(): string[];
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermFirewallTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermFirewallTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermFirewallTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
