import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermFunctionAppConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app#name DataAzurermFunctionApp#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app#resource_group_name DataAzurermFunctionApp#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app#tags DataAzurermFunctionApp#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app#timeouts DataAzurermFunctionApp#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermFunctionAppTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermFunctionAppConnectionString extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermFunctionAppIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermFunctionAppSiteConfigCors extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allowedOrigins(): string[];
    /**
     * @stability stable
     */
    get supportCredentials(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermFunctionAppSiteConfigIpRestrictionHeaders extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get xAzureFdid(): string[];
    /**
     * @stability stable
     */
    get xFdHealthProbe(): string[];
    /**
     * @stability stable
     */
    get xForwardedFor(): string[];
    /**
     * @stability stable
     */
    get xForwardedHost(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermFunctionAppSiteConfigIpRestriction extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    get headers(): any;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    get serviceTag(): string;
    /**
     * @stability stable
     */
    get virtualNetworkSubnetId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermFunctionAppSiteConfigScmIpRestrictionHeaders extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get xAzureFdid(): string[];
    /**
     * @stability stable
     */
    get xFdHealthProbe(): string[];
    /**
     * @stability stable
     */
    get xForwardedFor(): string[];
    /**
     * @stability stable
     */
    get xForwardedHost(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermFunctionAppSiteConfigScmIpRestriction extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    get headers(): any;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    get serviceTag(): string;
    /**
     * @stability stable
     */
    get virtualNetworkSubnetId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermFunctionAppSiteConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get alwaysOn(): any;
    /**
     * @stability stable
     */
    get appScaleLimit(): number;
    /**
     * @stability stable
     */
    get autoSwapSlotName(): string;
    /**
     * @stability stable
     */
    get cors(): any;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersion(): string;
    /**
     * @stability stable
     */
    get elasticInstanceMinimum(): number;
    /**
     * @stability stable
     */
    get ftpsState(): string;
    /**
     * @stability stable
     */
    get healthCheckPath(): string;
    /**
     * @stability stable
     */
    get http2Enabled(): any;
    /**
     * @stability stable
     */
    get ipRestriction(): any;
    /**
     * @stability stable
     */
    get javaVersion(): string;
    /**
     * @stability stable
     */
    get linuxFxVersion(): string;
    /**
     * @stability stable
     */
    get minTlsVersion(): string;
    /**
     * @stability stable
     */
    get preWarmedInstanceCount(): number;
    /**
     * @stability stable
     */
    get runtimeScaleMonitoringEnabled(): any;
    /**
     * @stability stable
     */
    get scmIpRestriction(): any;
    /**
     * @stability stable
     */
    get scmType(): string;
    /**
     * @stability stable
     */
    get scmUseMainIpRestriction(): any;
    /**
     * @stability stable
     */
    get use32BitWorkerProcess(): any;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabled(): any;
    /**
     * @stability stable
     */
    get websocketsEnabled(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermFunctionAppSiteCredential extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermFunctionAppSourceControl extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get branch(): string;
    /**
     * @stability stable
     */
    get manualIntegration(): any;
    /**
     * @stability stable
     */
    get repoUrl(): string;
    /**
     * @stability stable
     */
    get rollbackEnabled(): any;
    /**
     * @stability stable
     */
    get useMercurial(): any;
}
/**
 * @stability stable
 */
export interface DataAzurermFunctionAppTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app#read DataAzurermFunctionApp#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermFunctionAppTimeoutsToTerraform(struct?: DataAzurermFunctionAppTimeoutsOutputReference | DataAzurermFunctionAppTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermFunctionAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermFunctionAppTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermFunctionAppTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/function_app azurerm_function_app}.
 *
 * @stability stable
 */
export declare class DataAzurermFunctionApp extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/function_app azurerm_function_app} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermFunctionAppConfig);
    /**
     * @stability stable
     */
    get appServicePlanId(): string;
    /**
     * @stability stable
     */
    appSettings(key: string): string;
    /**
     * @stability stable
     */
    get clientCertMode(): string;
    /**
     * @stability stable
     */
    connectionString(index: string): DataAzurermFunctionAppConnectionString;
    /**
     * @stability stable
     */
    get customDomainVerificationId(): string;
    /**
     * @stability stable
     */
    get defaultHostname(): string;
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermFunctionAppIdentity;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    get outboundIpAddresses(): string;
    /**
     * @stability stable
     */
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    siteConfig(index: string): DataAzurermFunctionAppSiteConfig;
    /**
     * @stability stable
     */
    siteCredential(index: string): DataAzurermFunctionAppSiteCredential;
    /**
     * @stability stable
     */
    sourceControl(index: string): DataAzurermFunctionAppSourceControl;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermFunctionAppTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermFunctionAppTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermFunctionAppTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
