import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermKeyVaultAccessPolicyAConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_access_policy#name DataAzurermKeyVaultAccessPolicyA#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_access_policy#timeouts DataAzurermKeyVaultAccessPolicyA#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermKeyVaultAccessPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermKeyVaultAccessPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_access_policy#read DataAzurermKeyVaultAccessPolicyA#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultAccessPolicyTimeoutsToTerraform(struct?: DataAzurermKeyVaultAccessPolicyTimeoutsOutputReference | DataAzurermKeyVaultAccessPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermKeyVaultAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermKeyVaultAccessPolicyTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_access_policy azurerm_key_vault_access_policy}.
 *
 * @stability stable
 */
export declare class DataAzurermKeyVaultAccessPolicyA extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_access_policy azurerm_key_vault_access_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultAccessPolicyAConfig);
    /**
     * @stability stable
     */
    get certificatePermissions(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get keyPermissions(): string[];
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secretPermissions(): string[];
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermKeyVaultAccessPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermKeyVaultAccessPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermKeyVaultAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
