import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermKeyVaultSecretConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret#key_vault_id DataAzurermKeyVaultSecret#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret#name DataAzurermKeyVaultSecret#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret#timeouts DataAzurermKeyVaultSecret#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermKeyVaultSecretTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermKeyVaultSecretTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret#read DataAzurermKeyVaultSecret#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultSecretTimeoutsToTerraform(struct?: DataAzurermKeyVaultSecretTimeoutsOutputReference | DataAzurermKeyVaultSecretTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultSecretTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermKeyVaultSecretTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermKeyVaultSecretTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret azurerm_key_vault_secret}.
 *
 * @stability stable
 */
export declare class DataAzurermKeyVaultSecret extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_secret azurerm_key_vault_secret} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultSecretConfig);
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultId?;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    set keyVaultId(value: string);
    /**
     * @stability stable
     */
    get keyVaultIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    get versionlessId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermKeyVaultSecretTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermKeyVaultSecretTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermKeyVaultSecretTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
