import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermKubernetesServiceVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions#include_preview DataAzurermKubernetesServiceVersions#include_preview}.
     *
     * @stability stable
     */
    readonly includePreview?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions#location DataAzurermKubernetesServiceVersions#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions#version_prefix DataAzurermKubernetesServiceVersions#version_prefix}.
     *
     * @stability stable
     */
    readonly versionPrefix?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions#timeouts DataAzurermKubernetesServiceVersions#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermKubernetesServiceVersionsTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermKubernetesServiceVersionsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions#read DataAzurermKubernetesServiceVersions#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermKubernetesServiceVersionsTimeoutsToTerraform(struct?: DataAzurermKubernetesServiceVersionsTimeoutsOutputReference | DataAzurermKubernetesServiceVersionsTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermKubernetesServiceVersionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermKubernetesServiceVersionsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermKubernetesServiceVersionsTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions azurerm_kubernetes_service_versions}.
 *
 * @stability stable
 */
export declare class DataAzurermKubernetesServiceVersions extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions azurerm_kubernetes_service_versions} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermKubernetesServiceVersionsConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _includePreview?;
    /**
     * @stability stable
     */
    get includePreview(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includePreview(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludePreview(): void;
    /**
     * @stability stable
     */
    get includePreviewInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get latestVersion(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _versionPrefix?;
    /**
     * @stability stable
     */
    get versionPrefix(): string;
    /**
     * @stability stable
     */
    set versionPrefix(value: string);
    /**
     * @stability stable
     */
    resetVersionPrefix(): void;
    /**
     * @stability stable
     */
    get versionPrefixInput(): string | undefined;
    /**
     * @stability stable
     */
    get versions(): string[];
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermKubernetesServiceVersionsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermKubernetesServiceVersionsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermKubernetesServiceVersionsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
