import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermMonitorActionGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#name DataAzurermMonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#resource_group_name DataAzurermMonitorActionGroup#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * event_hub_receiver block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#event_hub_receiver DataAzurermMonitorActionGroup#event_hub_receiver}
     *
     * @stability stable
     */
    readonly eventHubReceiver?: DataAzurermMonitorActionGroupEventHubReceiver[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#timeouts DataAzurermMonitorActionGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermMonitorActionGroupTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroupArmRoleReceiver extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get roleId(): string;
    /**
     * @stability stable
     */
    get useCommonAlertSchema(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroupAutomationRunbookReceiver extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get automationAccountId(): string;
    /**
     * @stability stable
     */
    get isGlobalRunbook(): any;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get runbookName(): string;
    /**
     * @stability stable
     */
    get serviceUri(): string;
    /**
     * @stability stable
     */
    get useCommonAlertSchema(): any;
    /**
     * @stability stable
     */
    get webhookResourceId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroupAzureAppPushReceiver extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get emailAddress(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroupAzureFunctionReceiver extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get functionAppResourceId(): string;
    /**
     * @stability stable
     */
    get functionName(): string;
    /**
     * @stability stable
     */
    get httpTriggerUrl(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get useCommonAlertSchema(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroupEmailReceiver extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get emailAddress(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get useCommonAlertSchema(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroupItsmReceiver extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get connectionId(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    get ticketConfiguration(): string;
    /**
     * @stability stable
     */
    get workspaceId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroupLogicAppReceiver extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get callbackUrl(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get resourceId(): string;
    /**
     * @stability stable
     */
    get useCommonAlertSchema(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroupSmsReceiver extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get countryCode(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get phoneNumber(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroupVoiceReceiver extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get countryCode(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get phoneNumber(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroupWebhookReceiverAadAuth extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get identifierUri(): string;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroupWebhookReceiver extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get aadAuth(): any;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get serviceUri(): string;
    /**
     * @stability stable
     */
    get useCommonAlertSchema(): any;
}
/**
 * @stability stable
 */
export interface DataAzurermMonitorActionGroupEventHubReceiver {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#event_hub_id DataAzurermMonitorActionGroup#event_hub_id}.
     *
     * @stability stable
     */
    readonly eventHubId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#name DataAzurermMonitorActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#tenant_id DataAzurermMonitorActionGroup#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#use_common_alert_schema DataAzurermMonitorActionGroup#use_common_alert_schema}.
     *
     * @stability stable
     */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function dataAzurermMonitorActionGroupEventHubReceiverToTerraform(struct?: DataAzurermMonitorActionGroupEventHubReceiver): any;
/**
 * @stability stable
 */
export interface DataAzurermMonitorActionGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#read DataAzurermMonitorActionGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermMonitorActionGroupTimeoutsToTerraform(struct?: DataAzurermMonitorActionGroupTimeoutsOutputReference | DataAzurermMonitorActionGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermMonitorActionGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermMonitorActionGroupTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group azurerm_monitor_action_group}.
 *
 * @stability stable
 */
export declare class DataAzurermMonitorActionGroup extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group azurerm_monitor_action_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorActionGroupConfig);
    /**
     * @stability stable
     */
    armRoleReceiver(index: string): DataAzurermMonitorActionGroupArmRoleReceiver;
    /**
     * @stability stable
     */
    automationRunbookReceiver(index: string): DataAzurermMonitorActionGroupAutomationRunbookReceiver;
    /**
     * @stability stable
     */
    azureAppPushReceiver(index: string): DataAzurermMonitorActionGroupAzureAppPushReceiver;
    /**
     * @stability stable
     */
    azureFunctionReceiver(index: string): DataAzurermMonitorActionGroupAzureFunctionReceiver;
    /**
     * @stability stable
     */
    emailReceiver(index: string): DataAzurermMonitorActionGroupEmailReceiver;
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    itsmReceiver(index: string): DataAzurermMonitorActionGroupItsmReceiver;
    /**
     * @stability stable
     */
    logicAppReceiver(index: string): DataAzurermMonitorActionGroupLogicAppReceiver;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get shortName(): string;
    /**
     * @stability stable
     */
    smsReceiver(index: string): DataAzurermMonitorActionGroupSmsReceiver;
    /**
     * @stability stable
     */
    voiceReceiver(index: string): DataAzurermMonitorActionGroupVoiceReceiver;
    /**
     * @stability stable
     */
    webhookReceiver(index: string): DataAzurermMonitorActionGroupWebhookReceiver;
    private _eventHubReceiver?;
    /**
     * @stability stable
     */
    get eventHubReceiver(): DataAzurermMonitorActionGroupEventHubReceiver[];
    /**
     * @stability stable
     */
    set eventHubReceiver(value: DataAzurermMonitorActionGroupEventHubReceiver[]);
    /**
     * @stability stable
     */
    resetEventHubReceiver(): void;
    /**
     * @stability stable
     */
    get eventHubReceiverInput(): DataAzurermMonitorActionGroupEventHubReceiver[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermMonitorActionGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermMonitorActionGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermMonitorActionGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
