import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermMonitorScheduledQueryRulesAlertConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#name DataAzurermMonitorScheduledQueryRulesAlert#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#resource_group_name DataAzurermMonitorScheduledQueryRulesAlert#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#timeouts DataAzurermMonitorScheduledQueryRulesAlert#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermMonitorScheduledQueryRulesAlertTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorScheduledQueryRulesAlertAction extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get actionGroup(): string[];
    /**
     * @stability stable
     */
    get customWebhookPayload(): string;
    /**
     * @stability stable
     */
    get emailSubject(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorScheduledQueryRulesAlertTriggerMetricTrigger extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get metricColumn(): string;
    /**
     * @stability stable
     */
    get metricTriggerType(): string;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get threshold(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorScheduledQueryRulesAlertTrigger extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get metricTrigger(): any;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get threshold(): number;
}
/**
 * @stability stable
 */
export interface DataAzurermMonitorScheduledQueryRulesAlertTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#read DataAzurermMonitorScheduledQueryRulesAlert#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermMonitorScheduledQueryRulesAlertTimeoutsToTerraform(struct?: DataAzurermMonitorScheduledQueryRulesAlertTimeoutsOutputReference | DataAzurermMonitorScheduledQueryRulesAlertTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermMonitorScheduledQueryRulesAlertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermMonitorScheduledQueryRulesAlertTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermMonitorScheduledQueryRulesAlertTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert azurerm_monitor_scheduled_query_rules_alert}.
 *
 * @stability stable
 */
export declare class DataAzurermMonitorScheduledQueryRulesAlert extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert azurerm_monitor_scheduled_query_rules_alert} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorScheduledQueryRulesAlertConfig);
    /**
     * @stability stable
     */
    action(index: string): DataAzurermMonitorScheduledQueryRulesAlertAction;
    /**
     * @stability stable
     */
    get authorizedResourceIds(): string[];
    /**
     * @stability stable
     */
    get dataSourceId(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get frequency(): number;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    get queryType(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get severity(): number;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get throttling(): number;
    /**
     * @stability stable
     */
    get timeWindow(): number;
    /**
     * @stability stable
     */
    trigger(index: string): DataAzurermMonitorScheduledQueryRulesAlertTrigger;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermMonitorScheduledQueryRulesAlertTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermMonitorScheduledQueryRulesAlertTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermMonitorScheduledQueryRulesAlertTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
