import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermMysqlFlexibleServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_flexible_server#name DataAzurermMysqlFlexibleServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_flexible_server#resource_group_name DataAzurermMysqlFlexibleServer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_flexible_server#timeouts DataAzurermMysqlFlexibleServer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermMysqlFlexibleServerTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermMysqlFlexibleServerHighAvailability extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    get standbyAvailabilityZone(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermMysqlFlexibleServerMaintenanceWindow extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dayOfWeek(): number;
    /**
     * @stability stable
     */
    get startHour(): number;
    /**
     * @stability stable
     */
    get startMinute(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermMysqlFlexibleServerStorage extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get autoGrowEnabled(): any;
    /**
     * @stability stable
     */
    get iops(): number;
    /**
     * @stability stable
     */
    get sizeGb(): number;
}
/**
 * @stability stable
 */
export interface DataAzurermMysqlFlexibleServerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_flexible_server#read DataAzurermMysqlFlexibleServer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermMysqlFlexibleServerTimeoutsToTerraform(struct?: DataAzurermMysqlFlexibleServerTimeoutsOutputReference | DataAzurermMysqlFlexibleServerTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermMysqlFlexibleServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermMysqlFlexibleServerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermMysqlFlexibleServerTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_flexible_server azurerm_mysql_flexible_server}.
 *
 * @stability stable
 */
export declare class DataAzurermMysqlFlexibleServer extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_flexible_server azurerm_mysql_flexible_server} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermMysqlFlexibleServerConfig);
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    get backupRetentionDays(): number;
    /**
     * @stability stable
     */
    get delegatedSubnetId(): string;
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get geoRedundantBackupEnabled(): any;
    /**
     * @stability stable
     */
    highAvailability(index: string): DataAzurermMysqlFlexibleServerHighAvailability;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    maintenanceWindow(index: string): DataAzurermMysqlFlexibleServerMaintenanceWindow;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateDnsZoneId(): string;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): any;
    /**
     * @stability stable
     */
    get replicaCapacity(): number;
    /**
     * @stability stable
     */
    get replicationRole(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get restorePointInTime(): string;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    storage(index: string): DataAzurermMysqlFlexibleServerStorage;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    get zone(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermMysqlFlexibleServerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermMysqlFlexibleServerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermMysqlFlexibleServerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
