import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermNetworkInterfaceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_interface#name DataAzurermNetworkInterface#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_interface#resource_group_name DataAzurermNetworkInterface#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_interface#timeouts DataAzurermNetworkInterface#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermNetworkInterfaceTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermNetworkInterfaceIpConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get applicationGatewayBackendAddressPoolsIds(): string[];
    /**
     * @stability stable
     */
    get applicationSecurityGroupIds(): string[];
    /**
     * @stability stable
     */
    get gatewayLoadBalancerFrontendIpConfigurationId(): string;
    /**
     * @stability stable
     */
    get loadBalancerBackendAddressPoolsIds(): string[];
    /**
     * @stability stable
     */
    get loadBalancerInboundNatRulesIds(): string[];
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get primary(): any;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    /**
     * @stability stable
     */
    get privateIpAddressAllocation(): string;
    /**
     * @stability stable
     */
    get privateIpAddressVersion(): string;
    /**
     * @stability stable
     */
    get publicIpAddressId(): string;
    /**
     * @stability stable
     */
    get subnetId(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermNetworkInterfaceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_interface#read DataAzurermNetworkInterface#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermNetworkInterfaceTimeoutsToTerraform(struct?: DataAzurermNetworkInterfaceTimeoutsOutputReference | DataAzurermNetworkInterfaceTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermNetworkInterfaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermNetworkInterfaceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermNetworkInterfaceTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/network_interface azurerm_network_interface}.
 *
 * @stability stable
 */
export declare class DataAzurermNetworkInterface extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/network_interface azurerm_network_interface} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkInterfaceConfig);
    /**
     * @stability stable
     */
    get appliedDnsServers(): string[];
    /**
     * @stability stable
     */
    get dnsServers(): string[];
    /**
     * @stability stable
     */
    get enableAcceleratedNetworking(): any;
    /**
     * @stability stable
     */
    get enableIpForwarding(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get internalDnsNameLabel(): string;
    /**
     * @stability stable
     */
    ipConfiguration(index: string): DataAzurermNetworkInterfaceIpConfiguration;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get macAddress(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get networkSecurityGroupId(): string;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    /**
     * @stability stable
     */
    get privateIpAddresses(): string[];
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get virtualMachineId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermNetworkInterfaceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermNetworkInterfaceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermNetworkInterfaceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
