import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermNotificationHubConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub#name DataAzurermNotificationHub#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub#namespace_name DataAzurermNotificationHub#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub#resource_group_name DataAzurermNotificationHub#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub#timeouts DataAzurermNotificationHub#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermNotificationHubTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermNotificationHubApnsCredential extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get applicationMode(): string;
    /**
     * @stability stable
     */
    get bundleId(): string;
    /**
     * @stability stable
     */
    get keyId(): string;
    /**
     * @stability stable
     */
    get teamId(): string;
    /**
     * @stability stable
     */
    get token(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermNotificationHubGcmCredential extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get apiKey(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermNotificationHubTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub#read DataAzurermNotificationHub#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermNotificationHubTimeoutsToTerraform(struct?: DataAzurermNotificationHubTimeoutsOutputReference | DataAzurermNotificationHubTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermNotificationHubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermNotificationHubTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermNotificationHubTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub azurerm_notification_hub}.
 *
 * @stability stable
 */
export declare class DataAzurermNotificationHub extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/notification_hub azurerm_notification_hub} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermNotificationHubConfig);
    /**
     * @stability stable
     */
    apnsCredential(index: string): DataAzurermNotificationHubApnsCredential;
    /**
     * @stability stable
     */
    gcmCredential(index: string): DataAzurermNotificationHubGcmCredential;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermNotificationHubTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermNotificationHubTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermNotificationHubTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
