import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermPolicyDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition#display_name DataAzurermPolicyDefinition#display_name}.
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition#management_group_id DataAzurermPolicyDefinition#management_group_id}.
     *
     * @stability stable
     */
    readonly managementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition#management_group_name DataAzurermPolicyDefinition#management_group_name}.
     *
     * @stability stable
     */
    readonly managementGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition#name DataAzurermPolicyDefinition#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition#timeouts DataAzurermPolicyDefinition#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermPolicyDefinitionTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermPolicyDefinitionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition#read DataAzurermPolicyDefinition#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermPolicyDefinitionTimeoutsToTerraform(struct?: DataAzurermPolicyDefinitionTimeoutsOutputReference | DataAzurermPolicyDefinitionTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermPolicyDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermPolicyDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermPolicyDefinitionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition azurerm_policy_definition}.
 *
 * @stability stable
 */
export declare class DataAzurermPolicyDefinition extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition azurerm_policy_definition} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzurermPolicyDefinitionConfig);
    /**
     * @stability stable
     */
    get description(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _managementGroupId?;
    /**
     * @stability stable
     */
    get managementGroupId(): string;
    /**
     * @stability stable
     */
    set managementGroupId(value: string);
    /**
     * @stability stable
     */
    resetManagementGroupId(): void;
    /**
     * @stability stable
     */
    get managementGroupIdInput(): string | undefined;
    private _managementGroupName?;
    /**
     * @stability stable
     */
    get managementGroupName(): string;
    /**
     * @stability stable
     */
    set managementGroupName(value: string);
    /**
     * @stability stable
     */
    resetManagementGroupName(): void;
    /**
     * @stability stable
     */
    get managementGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get metadata(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get parameters(): string;
    /**
     * @stability stable
     */
    get policyRule(): string;
    /**
     * @stability stable
     */
    get policyType(): string;
    /**
     * @stability stable
     */
    get type(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermPolicyDefinitionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermPolicyDefinitionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermPolicyDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
