import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermPrivateLinkServiceEndpointConnectionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections#resource_group_name DataAzurermPrivateLinkServiceEndpointConnections#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections#service_id DataAzurermPrivateLinkServiceEndpointConnections#service_id}.
     *
     * @stability stable
     */
    readonly serviceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections#timeouts DataAzurermPrivateLinkServiceEndpointConnections#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnections extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get actionRequired(): string;
    /**
     * @stability stable
     */
    get connectionId(): string;
    /**
     * @stability stable
     */
    get connectionName(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get privateEndpointId(): string;
    /**
     * @stability stable
     */
    get privateEndpointName(): string;
    /**
     * @stability stable
     */
    get status(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections#read DataAzurermPrivateLinkServiceEndpointConnections#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermPrivateLinkServiceEndpointConnectionsTimeoutsToTerraform(struct?: DataAzurermPrivateLinkServiceEndpointConnectionsTimeoutsOutputReference | DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermPrivateLinkServiceEndpointConnectionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections azurerm_private_link_service_endpoint_connections}.
 *
 * @stability stable
 */
export declare class DataAzurermPrivateLinkServiceEndpointConnections extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/private_link_service_endpoint_connections azurerm_private_link_service_endpoint_connections} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateLinkServiceEndpointConnectionsConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    privateEndpointConnections(index: string): DataAzurermPrivateLinkServiceEndpointConnectionsPrivateEndpointConnections;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _serviceId?;
    /**
     * @stability stable
     */
    get serviceId(): string;
    /**
     * @stability stable
     */
    set serviceId(value: string);
    /**
     * @stability stable
     */
    get serviceIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceName(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermPrivateLinkServiceEndpointConnectionsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermPrivateLinkServiceEndpointConnectionsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
