import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermProximityPlacementGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/proximity_placement_group#name DataAzurermProximityPlacementGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/proximity_placement_group#resource_group_name DataAzurermProximityPlacementGroup#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/proximity_placement_group#timeouts DataAzurermProximityPlacementGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermProximityPlacementGroupTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermProximityPlacementGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/proximity_placement_group#read DataAzurermProximityPlacementGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermProximityPlacementGroupTimeoutsToTerraform(struct?: DataAzurermProximityPlacementGroupTimeoutsOutputReference | DataAzurermProximityPlacementGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermProximityPlacementGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermProximityPlacementGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermProximityPlacementGroupTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/proximity_placement_group azurerm_proximity_placement_group}.
 *
 * @stability stable
 */
export declare class DataAzurermProximityPlacementGroup extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/proximity_placement_group azurerm_proximity_placement_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermProximityPlacementGroupConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermProximityPlacementGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermProximityPlacementGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermProximityPlacementGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
