import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermRedisCacheConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/redis_cache#name DataAzurermRedisCache#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/redis_cache#resource_group_name DataAzurermRedisCache#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/redis_cache#timeouts DataAzurermRedisCache#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermRedisCacheTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermRedisCachePatchSchedule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dayOfWeek(): string;
    /**
     * @stability stable
     */
    get maintenanceWindow(): string;
    /**
     * @stability stable
     */
    get startHourUtc(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermRedisCacheRedisConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get aofBackupEnabled(): any;
    /**
     * @stability stable
     */
    get aofStorageConnectionString0(): string;
    /**
     * @stability stable
     */
    get aofStorageConnectionString1(): string;
    /**
     * @stability stable
     */
    get enableAuthentication(): any;
    /**
     * @stability stable
     */
    get maxclients(): number;
    /**
     * @stability stable
     */
    get maxfragmentationmemoryReserved(): number;
    /**
     * @stability stable
     */
    get maxmemoryDelta(): number;
    /**
     * @stability stable
     */
    get maxmemoryPolicy(): string;
    /**
     * @stability stable
     */
    get maxmemoryReserved(): number;
    /**
     * @stability stable
     */
    get notifyKeyspaceEvents(): string;
    /**
     * @stability stable
     */
    get rdbBackupEnabled(): any;
    /**
     * @stability stable
     */
    get rdbBackupFrequency(): number;
    /**
     * @stability stable
     */
    get rdbBackupMaxSnapshotCount(): number;
    /**
     * @stability stable
     */
    get rdbStorageConnectionString(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermRedisCacheTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/redis_cache#read DataAzurermRedisCache#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermRedisCacheTimeoutsToTerraform(struct?: DataAzurermRedisCacheTimeoutsOutputReference | DataAzurermRedisCacheTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermRedisCacheTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermRedisCacheTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermRedisCacheTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/redis_cache azurerm_redis_cache}.
 *
 * @stability stable
 */
export declare class DataAzurermRedisCache extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/redis_cache azurerm_redis_cache} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermRedisCacheConfig);
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    get enableNonSslPort(): any;
    /**
     * @stability stable
     */
    get family(): string;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get minimumTlsVersion(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    patchSchedule(index: string): DataAzurermRedisCachePatchSchedule;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get primaryAccessKey(): string;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    /**
     * @stability stable
     */
    get privateStaticIpAddress(): string;
    /**
     * @stability stable
     */
    redisConfiguration(index: string): DataAzurermRedisCacheRedisConfiguration;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAccessKey(): string;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get shardCount(): number;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    get sslPort(): number;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get zones(): string[];
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermRedisCacheTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermRedisCacheTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermRedisCacheTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
