import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermRouteFilterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/route_filter#name DataAzurermRouteFilter#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/route_filter#resource_group_name DataAzurermRouteFilter#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/route_filter#timeouts DataAzurermRouteFilter#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermRouteFilterTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermRouteFilterRule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get access(): string;
    /**
     * @stability stable
     */
    get communities(): string[];
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get ruleType(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermRouteFilterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/route_filter#read DataAzurermRouteFilter#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermRouteFilterTimeoutsToTerraform(struct?: DataAzurermRouteFilterTimeoutsOutputReference | DataAzurermRouteFilterTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermRouteFilterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermRouteFilterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermRouteFilterTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/route_filter azurerm_route_filter}.
 *
 * @stability stable
 */
export declare class DataAzurermRouteFilter extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/route_filter azurerm_route_filter} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermRouteFilterConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    rule(index: string): DataAzurermRouteFilterRule;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermRouteFilterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermRouteFilterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermRouteFilterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
