import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermSearchServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/search_service#name DataAzurermSearchService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/search_service#resource_group_name DataAzurermSearchService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/search_service#timeouts DataAzurermSearchService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermSearchServiceTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermSearchServiceIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermSearchServiceQueryKeys extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermSearchServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/search_service#read DataAzurermSearchService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermSearchServiceTimeoutsToTerraform(struct?: DataAzurermSearchServiceTimeoutsOutputReference | DataAzurermSearchServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermSearchServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermSearchServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermSearchServiceTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/search_service azurerm_search_service}.
 *
 * @stability stable
 */
export declare class DataAzurermSearchService extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/search_service azurerm_search_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermSearchServiceConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermSearchServiceIdentity;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get partitionCount(): number;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): any;
    /**
     * @stability stable
     */
    queryKeys(index: string): DataAzurermSearchServiceQueryKeys;
    /**
     * @stability stable
     */
    get replicaCount(): number;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermSearchServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermSearchServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermSearchServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
