import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermServicebusNamespaceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace#name DataAzurermServicebusNamespace#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace#resource_group_name DataAzurermServicebusNamespace#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace#timeouts DataAzurermServicebusNamespace#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermServicebusNamespaceTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermServicebusNamespaceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace#read DataAzurermServicebusNamespace#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermServicebusNamespaceTimeoutsToTerraform(struct?: DataAzurermServicebusNamespaceTimeoutsOutputReference | DataAzurermServicebusNamespaceTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermServicebusNamespaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermServicebusNamespaceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermServicebusNamespaceTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace azurerm_servicebus_namespace}.
 *
 * @stability stable
 */
export declare class DataAzurermServicebusNamespace extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_namespace azurerm_servicebus_namespace} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusNamespaceConfig);
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    get defaultPrimaryConnectionString(): string;
    /**
     * @stability stable
     */
    get defaultPrimaryKey(): string;
    /**
     * @stability stable
     */
    get defaultSecondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get defaultSecondaryKey(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get zoneRedundant(): any;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermServicebusNamespaceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermServicebusNamespaceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermServicebusNamespaceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
