import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermSharedImageVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions#gallery_name DataAzurermSharedImageVersions#gallery_name}.
     *
     * @stability stable
     */
    readonly galleryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions#image_name DataAzurermSharedImageVersions#image_name}.
     *
     * @stability stable
     */
    readonly imageName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions#resource_group_name DataAzurermSharedImageVersions#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions#tags_filter DataAzurermSharedImageVersions#tags_filter}.
     *
     * @stability stable
     */
    readonly tagsFilter?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions#timeouts DataAzurermSharedImageVersions#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermSharedImageVersionsTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermSharedImageVersionsImagesTargetRegion extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get regionalReplicaCount(): number;
    /**
     * @stability stable
     */
    get storageAccountType(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermSharedImageVersionsImages extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get excludeFromLatest(): any;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get managedImageId(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get tags(): any;
    /**
     * @stability stable
     */
    get targetRegion(): any;
}
/**
 * @stability stable
 */
export interface DataAzurermSharedImageVersionsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions#read DataAzurermSharedImageVersions#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermSharedImageVersionsTimeoutsToTerraform(struct?: DataAzurermSharedImageVersionsTimeoutsOutputReference | DataAzurermSharedImageVersionsTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermSharedImageVersionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermSharedImageVersionsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermSharedImageVersionsTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions azurerm_shared_image_versions}.
 *
 * @stability stable
 */
export declare class DataAzurermSharedImageVersions extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_versions azurerm_shared_image_versions} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermSharedImageVersionsConfig);
    private _galleryName?;
    /**
     * @stability stable
     */
    get galleryName(): string;
    /**
     * @stability stable
     */
    set galleryName(value: string);
    /**
     * @stability stable
     */
    get galleryNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _imageName?;
    /**
     * @stability stable
     */
    get imageName(): string;
    /**
     * @stability stable
     */
    set imageName(value: string);
    /**
     * @stability stable
     */
    get imageNameInput(): string | undefined;
    /**
     * @stability stable
     */
    images(index: string): DataAzurermSharedImageVersionsImages;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tagsFilter?;
    /**
     * @stability stable
     */
    get tagsFilter(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tagsFilter(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTagsFilter(): void;
    /**
     * @stability stable
     */
    get tagsFilterInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermSharedImageVersionsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermSharedImageVersionsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermSharedImageVersionsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
