import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermSpringCloudAppConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#name DataAzurermSpringCloudApp#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#resource_group_name DataAzurermSpringCloudApp#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#service_name DataAzurermSpringCloudApp#service_name}.
     *
     * @stability stable
     */
    readonly serviceName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#timeouts DataAzurermSpringCloudApp#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermSpringCloudAppTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermSpringCloudAppIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermSpringCloudAppPersistentDisk extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get mountPath(): string;
    /**
     * @stability stable
     */
    get sizeInGb(): number;
}
/**
 * @stability stable
 */
export interface DataAzurermSpringCloudAppTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#read DataAzurermSpringCloudApp#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermSpringCloudAppTimeoutsToTerraform(struct?: DataAzurermSpringCloudAppTimeoutsOutputReference | DataAzurermSpringCloudAppTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermSpringCloudAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermSpringCloudAppTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermSpringCloudAppTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app azurerm_spring_cloud_app}.
 *
 * @stability stable
 */
export declare class DataAzurermSpringCloudApp extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app azurerm_spring_cloud_app} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermSpringCloudAppConfig);
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get httpsOnly(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermSpringCloudAppIdentity;
    /**
     * @stability stable
     */
    get isPublic(): any;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    persistentDisk(index: string): DataAzurermSpringCloudAppPersistentDisk;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _serviceName?;
    /**
     * @stability stable
     */
    get serviceName(): string;
    /**
     * @stability stable
     */
    set serviceName(value: string);
    /**
     * @stability stable
     */
    get serviceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get tlsEnabled(): any;
    /**
     * @stability stable
     */
    get url(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermSpringCloudAppTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermSpringCloudAppTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermSpringCloudAppTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
