import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermSpringCloudServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_service#name DataAzurermSpringCloudService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_service#resource_group_name DataAzurermSpringCloudService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_service#timeouts DataAzurermSpringCloudService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermSpringCloudServiceTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingHttpBasicAuth extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingRepositoryHttpBasicAuth extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingRepositorySshAuth extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hostKey(): string;
    /**
     * @stability stable
     */
    get hostKeyAlgorithm(): string;
    /**
     * @stability stable
     */
    get privateKey(): string;
    /**
     * @stability stable
     */
    get strictHostKeyCheckingEnabled(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingRepository extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get httpBasicAuth(): any;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get pattern(): string[];
    /**
     * @stability stable
     */
    get searchPaths(): string[];
    /**
     * @stability stable
     */
    get sshAuth(): any;
    /**
     * @stability stable
     */
    get uri(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermSpringCloudServiceConfigServerGitSettingSshAuth extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hostKey(): string;
    /**
     * @stability stable
     */
    get hostKeyAlgorithm(): string;
    /**
     * @stability stable
     */
    get privateKey(): string;
    /**
     * @stability stable
     */
    get strictHostKeyCheckingEnabled(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermSpringCloudServiceConfigServerGitSetting extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get httpBasicAuth(): any;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    get repository(): any;
    /**
     * @stability stable
     */
    get searchPaths(): string[];
    /**
     * @stability stable
     */
    get sshAuth(): any;
    /**
     * @stability stable
     */
    get uri(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermSpringCloudServiceRequiredNetworkTrafficRules extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get direction(): string;
    /**
     * @stability stable
     */
    get fqdns(): string[];
    /**
     * @stability stable
     */
    get ipAddresses(): string[];
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get protocol(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermSpringCloudServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_service#read DataAzurermSpringCloudService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermSpringCloudServiceTimeoutsToTerraform(struct?: DataAzurermSpringCloudServiceTimeoutsOutputReference | DataAzurermSpringCloudServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermSpringCloudServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermSpringCloudServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermSpringCloudServiceTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_service azurerm_spring_cloud_service}.
 *
 * @stability stable
 */
export declare class DataAzurermSpringCloudService extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_service azurerm_spring_cloud_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermSpringCloudServiceConfig);
    /**
     * @stability stable
     */
    configServerGitSetting(index: string): DataAzurermSpringCloudServiceConfigServerGitSetting;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get outboundPublicIpAddresses(): string[];
    /**
     * @stability stable
     */
    requiredNetworkTrafficRules(index: string): DataAzurermSpringCloudServiceRequiredNetworkTrafficRules;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermSpringCloudServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermSpringCloudServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermSpringCloudServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
