import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermSqlManagedInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance#name DataAzurermSqlManagedInstance#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance#resource_group_name DataAzurermSqlManagedInstance#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance#tags DataAzurermSqlManagedInstance#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance#timeouts DataAzurermSqlManagedInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermSqlManagedInstanceTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermSqlManagedInstanceIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get userAssignedIdentityId(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermSqlManagedInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance#read DataAzurermSqlManagedInstance#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermSqlManagedInstanceTimeoutsToTerraform(struct?: DataAzurermSqlManagedInstanceTimeoutsOutputReference | DataAzurermSqlManagedInstanceTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermSqlManagedInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermSqlManagedInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermSqlManagedInstanceTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance azurerm_sql_managed_instance}.
 *
 * @stability stable
 */
export declare class DataAzurermSqlManagedInstance extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/sql_managed_instance azurerm_sql_managed_instance} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermSqlManagedInstanceConfig);
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    get collation(): string;
    /**
     * @stability stable
     */
    get dnsZonePartnerId(): string;
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermSqlManagedInstanceIdentity;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get minimumTlsVersion(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get proxyOverride(): string;
    /**
     * @stability stable
     */
    get publicDataEndpointEnabled(): any;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    get storageAccountType(): string;
    /**
     * @stability stable
     */
    get storageSizeInGb(): number;
    /**
     * @stability stable
     */
    get subnetId(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get timezoneId(): string;
    /**
     * @stability stable
     */
    get vcores(): number;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermSqlManagedInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermSqlManagedInstanceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermSqlManagedInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
