import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermStorageContainerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container#metadata DataAzurermStorageContainer#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container#name DataAzurermStorageContainer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container#storage_account_name DataAzurermStorageContainer#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container#timeouts DataAzurermStorageContainer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermStorageContainerTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageContainerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container#read DataAzurermStorageContainer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermStorageContainerTimeoutsToTerraform(struct?: DataAzurermStorageContainerTimeoutsOutputReference | DataAzurermStorageContainerTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageContainerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageContainerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageContainerTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container azurerm_storage_container}.
 *
 * @stability stable
 */
export declare class DataAzurermStorageContainer extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_container azurerm_storage_container} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermStorageContainerConfig);
    /**
     * @stability stable
     */
    get containerAccessType(): string;
    /**
     * @stability stable
     */
    get hasImmutabilityPolicy(): any;
    /**
     * @stability stable
     */
    get hasLegalHold(): any;
    /**
     * @stability stable
     */
    get id(): string;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get resourceManagerId(): string;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermStorageContainerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermStorageContainerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermStorageContainerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
