import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermSubnetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subnet#name DataAzurermSubnet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subnet#resource_group_name DataAzurermSubnet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subnet#virtual_network_name DataAzurermSubnet#virtual_network_name}.
     *
     * @stability stable
     */
    readonly virtualNetworkName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subnet#timeouts DataAzurermSubnet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermSubnetTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermSubnetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subnet#read DataAzurermSubnet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermSubnetTimeoutsToTerraform(struct?: DataAzurermSubnetTimeoutsOutputReference | DataAzurermSubnetTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermSubnetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermSubnetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermSubnetTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/subnet azurerm_subnet}.
 *
 * @stability stable
 */
export declare class DataAzurermSubnet extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/subnet azurerm_subnet} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermSubnetConfig);
    /**
     * @stability stable
     */
    get addressPrefix(): string;
    /**
     * @stability stable
     */
    get addressPrefixes(): string[];
    /**
     * @stability stable
     */
    get enforcePrivateLinkEndpointNetworkPolicies(): any;
    /**
     * @stability stable
     */
    get enforcePrivateLinkServiceNetworkPolicies(): any;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get networkSecurityGroupId(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get routeTableId(): string;
    /**
     * @stability stable
     */
    get serviceEndpoints(): string[];
    private _virtualNetworkName?;
    /**
     * @stability stable
     */
    get virtualNetworkName(): string;
    /**
     * @stability stable
     */
    set virtualNetworkName(value: string);
    /**
     * @stability stable
     */
    get virtualNetworkNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermSubnetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermSubnetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermSubnetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
