import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermSubscriptionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscriptions#display_name_contains DataAzurermSubscriptions#display_name_contains}.
     *
     * @stability stable
     */
    readonly displayNameContains?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscriptions#display_name_prefix DataAzurermSubscriptions#display_name_prefix}.
     *
     * @stability stable
     */
    readonly displayNamePrefix?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscriptions#timeouts DataAzurermSubscriptions#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermSubscriptionsTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermSubscriptionsSubscriptions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get locationPlacementId(): string;
    /**
     * @stability stable
     */
    get quotaId(): string;
    /**
     * @stability stable
     */
    get spendingLimit(): string;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
    /**
     * @stability stable
     */
    get tags(): any;
    /**
     * @stability stable
     */
    get tenantId(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermSubscriptionsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscriptions#read DataAzurermSubscriptions#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermSubscriptionsTimeoutsToTerraform(struct?: DataAzurermSubscriptionsTimeoutsOutputReference | DataAzurermSubscriptionsTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermSubscriptionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermSubscriptionsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermSubscriptionsTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/subscriptions azurerm_subscriptions}.
 *
 * @stability stable
 */
export declare class DataAzurermSubscriptions extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/subscriptions azurerm_subscriptions} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzurermSubscriptionsConfig);
    private _displayNameContains?;
    /**
     * @stability stable
     */
    get displayNameContains(): string;
    /**
     * @stability stable
     */
    set displayNameContains(value: string);
    /**
     * @stability stable
     */
    resetDisplayNameContains(): void;
    /**
     * @stability stable
     */
    get displayNameContainsInput(): string | undefined;
    private _displayNamePrefix?;
    /**
     * @stability stable
     */
    get displayNamePrefix(): string;
    /**
     * @stability stable
     */
    set displayNamePrefix(value: string);
    /**
     * @stability stable
     */
    resetDisplayNamePrefix(): void;
    /**
     * @stability stable
     */
    get displayNamePrefixInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    subscriptions(index: string): DataAzurermSubscriptionsSubscriptions;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermSubscriptionsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermSubscriptionsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermSubscriptionsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
