import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermVirtualMachineScaleSetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#name DataAzurermVirtualMachineScaleSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#resource_group_name DataAzurermVirtualMachineScaleSet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#timeouts DataAzurermVirtualMachineScaleSet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermVirtualMachineScaleSetTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualMachineScaleSetIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get tag(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get domainNameLabel(): string;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutes(): number;
    /**
     * @stability stable
     */
    get ipTag(): any;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get publicIpPrefixId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualMachineScaleSetNetworkInterfaceIpConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get applicationGatewayBackendAddressPoolIds(): string[];
    /**
     * @stability stable
     */
    get applicationSecurityGroupIds(): string[];
    /**
     * @stability stable
     */
    get loadBalancerBackendAddressPoolIds(): string[];
    /**
     * @stability stable
     */
    get loadBalancerInboundNatRulesIds(): string[];
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get primary(): any;
    /**
     * @stability stable
     */
    get publicIpAddress(): any;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    get version(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualMachineScaleSetNetworkInterface extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dnsServers(): string[];
    /**
     * @stability stable
     */
    get enableAcceleratedNetworking(): any;
    /**
     * @stability stable
     */
    get enableIpForwarding(): any;
    /**
     * @stability stable
     */
    get ipConfiguration(): any;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get networkSecurityGroupId(): string;
    /**
     * @stability stable
     */
    get primary(): any;
}
/**
 * @stability stable
 */
export interface DataAzurermVirtualMachineScaleSetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set#read DataAzurermVirtualMachineScaleSet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermVirtualMachineScaleSetTimeoutsToTerraform(struct?: DataAzurermVirtualMachineScaleSetTimeoutsOutputReference | DataAzurermVirtualMachineScaleSetTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermVirtualMachineScaleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermVirtualMachineScaleSetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermVirtualMachineScaleSetTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set azurerm_virtual_machine_scale_set}.
 *
 * @stability stable
 */
export declare class DataAzurermVirtualMachineScaleSet extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine_scale_set azurerm_virtual_machine_scale_set} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualMachineScaleSetConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermVirtualMachineScaleSetIdentity;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    networkInterface(index: string): DataAzurermVirtualMachineScaleSetNetworkInterface;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermVirtualMachineScaleSetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermVirtualMachineScaleSetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermVirtualMachineScaleSetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
