import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermVirtualNetworkGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway#name DataAzurermVirtualNetworkGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway#resource_group_name DataAzurermVirtualNetworkGateway#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway#timeouts DataAzurermVirtualNetworkGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermVirtualNetworkGatewayTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkGatewayBgpSettings extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get asn(): number;
    /**
     * @stability stable
     */
    get peerWeight(): number;
    /**
     * @stability stable
     */
    get peeringAddress(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkGatewayCustomRoute extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get addressPrefixes(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkGatewayIpConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get privateIpAddressAllocation(): string;
    /**
     * @stability stable
     */
    get publicIpAddressId(): string;
    /**
     * @stability stable
     */
    get subnetId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkGatewayVpnClientConfigurationRevokedCertificate extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get thumbprint(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkGatewayVpnClientConfigurationRootCertificate extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get publicCertData(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkGatewayVpnClientConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get aadAudience(): string;
    /**
     * @stability stable
     */
    get aadIssuer(): string;
    /**
     * @stability stable
     */
    get aadTenant(): string;
    /**
     * @stability stable
     */
    get addressSpace(): string[];
    /**
     * @stability stable
     */
    get radiusServerAddress(): string;
    /**
     * @stability stable
     */
    get radiusServerSecret(): string;
    /**
     * @stability stable
     */
    get revokedCertificate(): any;
    /**
     * @stability stable
     */
    get rootCertificate(): any;
    /**
     * @stability stable
     */
    get vpnClientProtocols(): string[];
}
/**
 * @stability stable
 */
export interface DataAzurermVirtualNetworkGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway#read DataAzurermVirtualNetworkGateway#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermVirtualNetworkGatewayTimeoutsToTerraform(struct?: DataAzurermVirtualNetworkGatewayTimeoutsOutputReference | DataAzurermVirtualNetworkGatewayTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermVirtualNetworkGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermVirtualNetworkGatewayTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway azurerm_virtual_network_gateway}.
 *
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkGateway extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway azurerm_virtual_network_gateway} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualNetworkGatewayConfig);
    /**
     * @stability stable
     */
    get activeActive(): any;
    /**
     * @stability stable
     */
    bgpSettings(index: string): DataAzurermVirtualNetworkGatewayBgpSettings;
    /**
     * @stability stable
     */
    customRoute(index: string): DataAzurermVirtualNetworkGatewayCustomRoute;
    /**
     * @stability stable
     */
    get defaultLocalNetworkGatewayId(): string;
    /**
     * @stability stable
     */
    get enableBgp(): any;
    /**
     * @stability stable
     */
    get generation(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    ipConfiguration(index: string): DataAzurermVirtualNetworkGatewayIpConfiguration;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateIpAddressEnabled(): any;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    vpnClientConfiguration(index: string): DataAzurermVirtualNetworkGatewayVpnClientConfiguration;
    /**
     * @stability stable
     */
    get vpnType(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermVirtualNetworkGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermVirtualNetworkGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermVirtualNetworkGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
