import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermVirtualNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network#name DataAzurermVirtualNetwork#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network#resource_group_name DataAzurermVirtualNetwork#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network#timeouts DataAzurermVirtualNetwork#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermVirtualNetworkTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermVirtualNetworkTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network#read DataAzurermVirtualNetwork#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermVirtualNetworkTimeoutsToTerraform(struct?: DataAzurermVirtualNetworkTimeoutsOutputReference | DataAzurermVirtualNetworkTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermVirtualNetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermVirtualNetworkTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network azurerm_virtual_network}.
 *
 * @stability stable
 */
export declare class DataAzurermVirtualNetwork extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network azurerm_virtual_network} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualNetworkConfig);
    /**
     * @stability stable
     */
    get addressSpace(): string[];
    /**
     * @stability stable
     */
    get dnsServers(): string[];
    /**
     * @stability stable
     */
    get guid(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get subnets(): string[];
    /**
     * @stability stable
     */
    vnetPeerings(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermVirtualNetworkTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermVirtualNetworkTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermVirtualNetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
