import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryDatasetDelimitedTextConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#additional_properties DataFactoryDatasetDelimitedText#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#annotations DataFactoryDatasetDelimitedText#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#column_delimiter DataFactoryDatasetDelimitedText#column_delimiter}.
     *
     * @stability stable
     */
    readonly columnDelimiter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#compression_codec DataFactoryDatasetDelimitedText#compression_codec}.
     *
     * @stability stable
     */
    readonly compressionCodec?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#compression_level DataFactoryDatasetDelimitedText#compression_level}.
     *
     * @stability stable
     */
    readonly compressionLevel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#data_factory_id DataFactoryDatasetDelimitedText#data_factory_id}.
     *
     * @stability stable
     */
    readonly dataFactoryId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#data_factory_name DataFactoryDatasetDelimitedText#data_factory_name}.
     *
     * @stability stable
     */
    readonly dataFactoryName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#description DataFactoryDatasetDelimitedText#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#encoding DataFactoryDatasetDelimitedText#encoding}.
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#escape_character DataFactoryDatasetDelimitedText#escape_character}.
     *
     * @stability stable
     */
    readonly escapeCharacter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#first_row_as_header DataFactoryDatasetDelimitedText#first_row_as_header}.
     *
     * @stability stable
     */
    readonly firstRowAsHeader?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#folder DataFactoryDatasetDelimitedText#folder}.
     *
     * @stability stable
     */
    readonly folder?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#linked_service_name DataFactoryDatasetDelimitedText#linked_service_name}.
     *
     * @stability stable
     */
    readonly linkedServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#name DataFactoryDatasetDelimitedText#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#null_value DataFactoryDatasetDelimitedText#null_value}.
     *
     * @stability stable
     */
    readonly nullValue?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#parameters DataFactoryDatasetDelimitedText#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#quote_character DataFactoryDatasetDelimitedText#quote_character}.
     *
     * @stability stable
     */
    readonly quoteCharacter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#resource_group_name DataFactoryDatasetDelimitedText#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#row_delimiter DataFactoryDatasetDelimitedText#row_delimiter}.
     *
     * @stability stable
     */
    readonly rowDelimiter?: string;
    /**
     * azure_blob_fs_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#azure_blob_fs_location DataFactoryDatasetDelimitedText#azure_blob_fs_location}
     *
     * @stability stable
     */
    readonly azureBlobFsLocation?: DataFactoryDatasetDelimitedTextAzureBlobFsLocation;
    /**
     * azure_blob_storage_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#azure_blob_storage_location DataFactoryDatasetDelimitedText#azure_blob_storage_location}
     *
     * @stability stable
     */
    readonly azureBlobStorageLocation?: DataFactoryDatasetDelimitedTextAzureBlobStorageLocation;
    /**
     * http_server_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#http_server_location DataFactoryDatasetDelimitedText#http_server_location}
     *
     * @stability stable
     */
    readonly httpServerLocation?: DataFactoryDatasetDelimitedTextHttpServerLocation;
    /**
     * schema_column block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#schema_column DataFactoryDatasetDelimitedText#schema_column}
     *
     * @stability stable
     */
    readonly schemaColumn?: DataFactoryDatasetDelimitedTextSchemaColumn[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#timeouts DataFactoryDatasetDelimitedText#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryDatasetDelimitedTextTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetDelimitedTextAzureBlobFsLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#file_system DataFactoryDatasetDelimitedText#file_system}.
     *
     * @stability stable
     */
    readonly fileSystem: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#filename DataFactoryDatasetDelimitedText#filename}.
     *
     * @stability stable
     */
    readonly filename?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#path DataFactoryDatasetDelimitedText#path}.
     *
     * @stability stable
     */
    readonly path?: string;
}
export declare function dataFactoryDatasetDelimitedTextAzureBlobFsLocationToTerraform(struct?: DataFactoryDatasetDelimitedTextAzureBlobFsLocationOutputReference | DataFactoryDatasetDelimitedTextAzureBlobFsLocation): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetDelimitedTextAzureBlobFsLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetDelimitedTextAzureBlobFsLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetDelimitedTextAzureBlobFsLocation | undefined);
    private _fileSystem?;
    /**
     * @stability stable
     */
    get fileSystem(): string;
    /**
     * @stability stable
     */
    set fileSystem(value: string);
    /**
     * @stability stable
     */
    get fileSystemInput(): string | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetDelimitedTextAzureBlobStorageLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#container DataFactoryDatasetDelimitedText#container}.
     *
     * @stability stable
     */
    readonly container: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#dynamic_filename_enabled DataFactoryDatasetDelimitedText#dynamic_filename_enabled}.
     *
     * @stability stable
     */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#dynamic_path_enabled DataFactoryDatasetDelimitedText#dynamic_path_enabled}.
     *
     * @stability stable
     */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#filename DataFactoryDatasetDelimitedText#filename}.
     *
     * @stability stable
     */
    readonly filename?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#path DataFactoryDatasetDelimitedText#path}.
     *
     * @stability stable
     */
    readonly path?: string;
}
export declare function dataFactoryDatasetDelimitedTextAzureBlobStorageLocationToTerraform(struct?: DataFactoryDatasetDelimitedTextAzureBlobStorageLocationOutputReference | DataFactoryDatasetDelimitedTextAzureBlobStorageLocation): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetDelimitedTextAzureBlobStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetDelimitedTextAzureBlobStorageLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetDelimitedTextAzureBlobStorageLocation | undefined);
    private _container?;
    /**
     * @stability stable
     */
    get container(): string;
    /**
     * @stability stable
     */
    set container(value: string);
    /**
     * @stability stable
     */
    get containerInput(): string | undefined;
    private _dynamicFilenameEnabled?;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicFilenameEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    /**
     * @stability stable
     */
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicPathEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetDelimitedTextHttpServerLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#dynamic_filename_enabled DataFactoryDatasetDelimitedText#dynamic_filename_enabled}.
     *
     * @stability stable
     */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#dynamic_path_enabled DataFactoryDatasetDelimitedText#dynamic_path_enabled}.
     *
     * @stability stable
     */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#filename DataFactoryDatasetDelimitedText#filename}.
     *
     * @stability stable
     */
    readonly filename: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#path DataFactoryDatasetDelimitedText#path}.
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#relative_url DataFactoryDatasetDelimitedText#relative_url}.
     *
     * @stability stable
     */
    readonly relativeUrl: string;
}
export declare function dataFactoryDatasetDelimitedTextHttpServerLocationToTerraform(struct?: DataFactoryDatasetDelimitedTextHttpServerLocationOutputReference | DataFactoryDatasetDelimitedTextHttpServerLocation): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetDelimitedTextHttpServerLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetDelimitedTextHttpServerLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetDelimitedTextHttpServerLocation | undefined);
    private _dynamicFilenameEnabled?;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicFilenameEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    /**
     * @stability stable
     */
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicPathEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _relativeUrl?;
    /**
     * @stability stable
     */
    get relativeUrl(): string;
    /**
     * @stability stable
     */
    set relativeUrl(value: string);
    /**
     * @stability stable
     */
    get relativeUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetDelimitedTextSchemaColumn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#description DataFactoryDatasetDelimitedText#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#name DataFactoryDatasetDelimitedText#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#type DataFactoryDatasetDelimitedText#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function dataFactoryDatasetDelimitedTextSchemaColumnToTerraform(struct?: DataFactoryDatasetDelimitedTextSchemaColumn): any;
/**
 * @stability stable
 */
export interface DataFactoryDatasetDelimitedTextTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#create DataFactoryDatasetDelimitedText#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#delete DataFactoryDatasetDelimitedText#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#read DataFactoryDatasetDelimitedText#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text#update DataFactoryDatasetDelimitedText#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryDatasetDelimitedTextTimeoutsToTerraform(struct?: DataFactoryDatasetDelimitedTextTimeoutsOutputReference | DataFactoryDatasetDelimitedTextTimeouts): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetDelimitedTextTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetDelimitedTextTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetDelimitedTextTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text azurerm_data_factory_dataset_delimited_text}.
 *
 * @stability stable
 */
export declare class DataFactoryDatasetDelimitedText extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_delimited_text azurerm_data_factory_dataset_delimited_text} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryDatasetDelimitedTextConfig);
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _columnDelimiter?;
    /**
     * @stability stable
     */
    get columnDelimiter(): string;
    /**
     * @stability stable
     */
    set columnDelimiter(value: string);
    /**
     * @stability stable
     */
    resetColumnDelimiter(): void;
    /**
     * @stability stable
     */
    get columnDelimiterInput(): string | undefined;
    private _compressionCodec?;
    /**
     * @stability stable
     */
    get compressionCodec(): string;
    /**
     * @stability stable
     */
    set compressionCodec(value: string);
    /**
     * @stability stable
     */
    resetCompressionCodec(): void;
    /**
     * @stability stable
     */
    get compressionCodecInput(): string | undefined;
    private _compressionLevel?;
    /**
     * @stability stable
     */
    get compressionLevel(): string;
    /**
     * @stability stable
     */
    set compressionLevel(value: string);
    /**
     * @stability stable
     */
    resetCompressionLevel(): void;
    /**
     * @stability stable
     */
    get compressionLevelInput(): string | undefined;
    private _dataFactoryId?;
    /**
     * @stability stable
     */
    get dataFactoryId(): string;
    /**
     * @stability stable
     */
    set dataFactoryId(value: string);
    /**
     * @stability stable
     */
    resetDataFactoryId(): void;
    /**
     * @stability stable
     */
    get dataFactoryIdInput(): string | undefined;
    private _dataFactoryName?;
    /**
     * @stability stable
     */
    get dataFactoryName(): string;
    /**
     * @stability stable
     */
    set dataFactoryName(value: string);
    /**
     * @stability stable
     */
    resetDataFactoryName(): void;
    /**
     * @stability stable
     */
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _escapeCharacter?;
    /**
     * @stability stable
     */
    get escapeCharacter(): string;
    /**
     * @stability stable
     */
    set escapeCharacter(value: string);
    /**
     * @stability stable
     */
    resetEscapeCharacter(): void;
    /**
     * @stability stable
     */
    get escapeCharacterInput(): string | undefined;
    private _firstRowAsHeader?;
    /**
     * @stability stable
     */
    get firstRowAsHeader(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set firstRowAsHeader(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFirstRowAsHeader(): void;
    /**
     * @stability stable
     */
    get firstRowAsHeaderInput(): boolean | cdktf.IResolvable | undefined;
    private _folder?;
    /**
     * @stability stable
     */
    get folder(): string;
    /**
     * @stability stable
     */
    set folder(value: string);
    /**
     * @stability stable
     */
    resetFolder(): void;
    /**
     * @stability stable
     */
    get folderInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _linkedServiceName?;
    /**
     * @stability stable
     */
    get linkedServiceName(): string;
    /**
     * @stability stable
     */
    set linkedServiceName(value: string);
    /**
     * @stability stable
     */
    get linkedServiceNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nullValue?;
    /**
     * @stability stable
     */
    get nullValue(): string;
    /**
     * @stability stable
     */
    set nullValue(value: string);
    /**
     * @stability stable
     */
    resetNullValue(): void;
    /**
     * @stability stable
     */
    get nullValueInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _quoteCharacter?;
    /**
     * @stability stable
     */
    get quoteCharacter(): string;
    /**
     * @stability stable
     */
    set quoteCharacter(value: string);
    /**
     * @stability stable
     */
    resetQuoteCharacter(): void;
    /**
     * @stability stable
     */
    get quoteCharacterInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _rowDelimiter?;
    /**
     * @stability stable
     */
    get rowDelimiter(): string;
    /**
     * @stability stable
     */
    set rowDelimiter(value: string);
    /**
     * @stability stable
     */
    resetRowDelimiter(): void;
    /**
     * @stability stable
     */
    get rowDelimiterInput(): string | undefined;
    private _azureBlobFsLocation;
    /**
     * @stability stable
     */
    get azureBlobFsLocation(): DataFactoryDatasetDelimitedTextAzureBlobFsLocationOutputReference;
    /**
     * @stability stable
     */
    putAzureBlobFsLocation(value: DataFactoryDatasetDelimitedTextAzureBlobFsLocation): void;
    /**
     * @stability stable
     */
    resetAzureBlobFsLocation(): void;
    /**
     * @stability stable
     */
    get azureBlobFsLocationInput(): DataFactoryDatasetDelimitedTextAzureBlobFsLocation | undefined;
    private _azureBlobStorageLocation;
    /**
     * @stability stable
     */
    get azureBlobStorageLocation(): DataFactoryDatasetDelimitedTextAzureBlobStorageLocationOutputReference;
    /**
     * @stability stable
     */
    putAzureBlobStorageLocation(value: DataFactoryDatasetDelimitedTextAzureBlobStorageLocation): void;
    /**
     * @stability stable
     */
    resetAzureBlobStorageLocation(): void;
    /**
     * @stability stable
     */
    get azureBlobStorageLocationInput(): DataFactoryDatasetDelimitedTextAzureBlobStorageLocation | undefined;
    private _httpServerLocation;
    /**
     * @stability stable
     */
    get httpServerLocation(): DataFactoryDatasetDelimitedTextHttpServerLocationOutputReference;
    /**
     * @stability stable
     */
    putHttpServerLocation(value: DataFactoryDatasetDelimitedTextHttpServerLocation): void;
    /**
     * @stability stable
     */
    resetHttpServerLocation(): void;
    /**
     * @stability stable
     */
    get httpServerLocationInput(): DataFactoryDatasetDelimitedTextHttpServerLocation | undefined;
    private _schemaColumn?;
    /**
     * @stability stable
     */
    get schemaColumn(): DataFactoryDatasetDelimitedTextSchemaColumn[];
    /**
     * @stability stable
     */
    set schemaColumn(value: DataFactoryDatasetDelimitedTextSchemaColumn[]);
    /**
     * @stability stable
     */
    resetSchemaColumn(): void;
    /**
     * @stability stable
     */
    get schemaColumnInput(): DataFactoryDatasetDelimitedTextSchemaColumn[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryDatasetDelimitedTextTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryDatasetDelimitedTextTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryDatasetDelimitedTextTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
