import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeAzureSsisConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#data_factory_id DataFactoryIntegrationRuntimeAzureSsis#data_factory_id}.
     *
     * @stability stable
     */
    readonly dataFactoryId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#data_factory_name DataFactoryIntegrationRuntimeAzureSsis#data_factory_name}.
     *
     * @stability stable
     */
    readonly dataFactoryName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#description DataFactoryIntegrationRuntimeAzureSsis#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#edition DataFactoryIntegrationRuntimeAzureSsis#edition}.
     *
     * @stability stable
     */
    readonly edition?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#license_type DataFactoryIntegrationRuntimeAzureSsis#license_type}.
     *
     * @stability stable
     */
    readonly licenseType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#location DataFactoryIntegrationRuntimeAzureSsis#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#max_parallel_executions_per_node DataFactoryIntegrationRuntimeAzureSsis#max_parallel_executions_per_node}.
     *
     * @stability stable
     */
    readonly maxParallelExecutionsPerNode?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#name DataFactoryIntegrationRuntimeAzureSsis#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#node_size DataFactoryIntegrationRuntimeAzureSsis#node_size}.
     *
     * @stability stable
     */
    readonly nodeSize: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#number_of_nodes DataFactoryIntegrationRuntimeAzureSsis#number_of_nodes}.
     *
     * @stability stable
     */
    readonly numberOfNodes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#resource_group_name DataFactoryIntegrationRuntimeAzureSsis#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * catalog_info block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#catalog_info DataFactoryIntegrationRuntimeAzureSsis#catalog_info}
     *
     * @stability stable
     */
    readonly catalogInfo?: DataFactoryIntegrationRuntimeAzureSsisCatalogInfo;
    /**
     * custom_setup_script block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#custom_setup_script DataFactoryIntegrationRuntimeAzureSsis#custom_setup_script}
     *
     * @stability stable
     */
    readonly customSetupScript?: DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript;
    /**
     * express_custom_setup block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#express_custom_setup DataFactoryIntegrationRuntimeAzureSsis#express_custom_setup}
     *
     * @stability stable
     */
    readonly expressCustomSetup?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup;
    /**
     * package_store block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#package_store DataFactoryIntegrationRuntimeAzureSsis#package_store}
     *
     * @stability stable
     */
    readonly packageStore?: DataFactoryIntegrationRuntimeAzureSsisPackageStore[];
    /**
     * proxy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#proxy DataFactoryIntegrationRuntimeAzureSsis#proxy}
     *
     * @stability stable
     */
    readonly proxy?: DataFactoryIntegrationRuntimeAzureSsisProxy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#timeouts DataFactoryIntegrationRuntimeAzureSsis#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryIntegrationRuntimeAzureSsisTimeouts;
    /**
     * vnet_integration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#vnet_integration DataFactoryIntegrationRuntimeAzureSsis#vnet_integration}
     *
     * @stability stable
     */
    readonly vnetIntegration?: DataFactoryIntegrationRuntimeAzureSsisVnetIntegration;
}
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeAzureSsisCatalogInfo {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#administrator_login DataFactoryIntegrationRuntimeAzureSsis#administrator_login}.
     *
     * @stability stable
     */
    readonly administratorLogin?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#administrator_password DataFactoryIntegrationRuntimeAzureSsis#administrator_password}.
     *
     * @stability stable
     */
    readonly administratorPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#dual_standby_pair_name DataFactoryIntegrationRuntimeAzureSsis#dual_standby_pair_name}.
     *
     * @stability stable
     */
    readonly dualStandbyPairName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#pricing_tier DataFactoryIntegrationRuntimeAzureSsis#pricing_tier}.
     *
     * @stability stable
     */
    readonly pricingTier?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#server_endpoint DataFactoryIntegrationRuntimeAzureSsis#server_endpoint}.
     *
     * @stability stable
     */
    readonly serverEndpoint: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisCatalogInfoToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisCatalogInfoOutputReference | DataFactoryIntegrationRuntimeAzureSsisCatalogInfo): any;
/**
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeAzureSsisCatalogInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisCatalogInfo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisCatalogInfo | undefined);
    private _administratorLogin?;
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    set administratorLogin(value: string);
    /**
     * @stability stable
     */
    resetAdministratorLogin(): void;
    /**
     * @stability stable
     */
    get administratorLoginInput(): string | undefined;
    private _administratorPassword?;
    /**
     * @stability stable
     */
    get administratorPassword(): string;
    /**
     * @stability stable
     */
    set administratorPassword(value: string);
    /**
     * @stability stable
     */
    resetAdministratorPassword(): void;
    /**
     * @stability stable
     */
    get administratorPasswordInput(): string | undefined;
    private _dualStandbyPairName?;
    /**
     * @stability stable
     */
    get dualStandbyPairName(): string;
    /**
     * @stability stable
     */
    set dualStandbyPairName(value: string);
    /**
     * @stability stable
     */
    resetDualStandbyPairName(): void;
    /**
     * @stability stable
     */
    get dualStandbyPairNameInput(): string | undefined;
    private _pricingTier?;
    /**
     * @stability stable
     */
    get pricingTier(): string;
    /**
     * @stability stable
     */
    set pricingTier(value: string);
    /**
     * @stability stable
     */
    resetPricingTier(): void;
    /**
     * @stability stable
     */
    get pricingTierInput(): string | undefined;
    private _serverEndpoint?;
    /**
     * @stability stable
     */
    get serverEndpoint(): string;
    /**
     * @stability stable
     */
    set serverEndpoint(value: string);
    /**
     * @stability stable
     */
    get serverEndpointInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#blob_container_uri DataFactoryIntegrationRuntimeAzureSsis#blob_container_uri}.
     *
     * @stability stable
     */
    readonly blobContainerUri: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#sas_token DataFactoryIntegrationRuntimeAzureSsis#sas_token}.
     *
     * @stability stable
     */
    readonly sasToken: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisCustomSetupScriptToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisCustomSetupScriptOutputReference | DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript): any;
/**
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeAzureSsisCustomSetupScriptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript | undefined);
    private _blobContainerUri?;
    /**
     * @stability stable
     */
    get blobContainerUri(): string;
    /**
     * @stability stable
     */
    set blobContainerUri(value: string);
    /**
     * @stability stable
     */
    get blobContainerUriInput(): string | undefined;
    private _sasToken?;
    /**
     * @stability stable
     */
    get sasToken(): string;
    /**
     * @stability stable
     */
    set sasToken(value: string);
    /**
     * @stability stable
     */
    get sasTokenInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#linked_service_name DataFactoryIntegrationRuntimeAzureSsis#linked_service_name}.
     *
     * @stability stable
     */
    readonly linkedServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#parameters DataFactoryIntegrationRuntimeAzureSsis#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#secret_name DataFactoryIntegrationRuntimeAzureSsis#secret_name}.
     *
     * @stability stable
     */
    readonly secretName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#secret_version DataFactoryIntegrationRuntimeAzureSsis#secret_version}.
     *
     * @stability stable
     */
    readonly secretVersion?: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPasswordToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPasswordOutputReference | DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword): any;
/**
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPasswordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword | undefined);
    private _linkedServiceName?;
    /**
     * @stability stable
     */
    get linkedServiceName(): string;
    /**
     * @stability stable
     */
    set linkedServiceName(value: string);
    /**
     * @stability stable
     */
    get linkedServiceNameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _secretName?;
    /**
     * @stability stable
     */
    get secretName(): string;
    /**
     * @stability stable
     */
    set secretName(value: string);
    /**
     * @stability stable
     */
    get secretNameInput(): string | undefined;
    private _secretVersion?;
    /**
     * @stability stable
     */
    get secretVersion(): string;
    /**
     * @stability stable
     */
    set secretVersion(value: string);
    /**
     * @stability stable
     */
    resetSecretVersion(): void;
    /**
     * @stability stable
     */
    get secretVersionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#password DataFactoryIntegrationRuntimeAzureSsis#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#target_name DataFactoryIntegrationRuntimeAzureSsis#target_name}.
     *
     * @stability stable
     */
    readonly targetName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#user_name DataFactoryIntegrationRuntimeAzureSsis#user_name}.
     *
     * @stability stable
     */
    readonly userName: string;
    /**
     * key_vault_password block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#key_vault_password DataFactoryIntegrationRuntimeAzureSsis#key_vault_password}
     *
     * @stability stable
     */
    readonly keyVaultPassword?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey): any;
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#linked_service_name DataFactoryIntegrationRuntimeAzureSsis#linked_service_name}.
     *
     * @stability stable
     */
    readonly linkedServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#parameters DataFactoryIntegrationRuntimeAzureSsis#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#secret_name DataFactoryIntegrationRuntimeAzureSsis#secret_name}.
     *
     * @stability stable
     */
    readonly secretName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#secret_version DataFactoryIntegrationRuntimeAzureSsis#secret_version}.
     *
     * @stability stable
     */
    readonly secretVersion?: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicenseToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicenseOutputReference | DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense): any;
/**
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicenseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense | undefined);
    private _linkedServiceName?;
    /**
     * @stability stable
     */
    get linkedServiceName(): string;
    /**
     * @stability stable
     */
    set linkedServiceName(value: string);
    /**
     * @stability stable
     */
    get linkedServiceNameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _secretName?;
    /**
     * @stability stable
     */
    get secretName(): string;
    /**
     * @stability stable
     */
    set secretName(value: string);
    /**
     * @stability stable
     */
    get secretNameInput(): string | undefined;
    private _secretVersion?;
    /**
     * @stability stable
     */
    get secretVersion(): string;
    /**
     * @stability stable
     */
    set secretVersion(value: string);
    /**
     * @stability stable
     */
    resetSecretVersion(): void;
    /**
     * @stability stable
     */
    get secretVersionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#license DataFactoryIntegrationRuntimeAzureSsis#license}.
     *
     * @stability stable
     */
    readonly license?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#name DataFactoryIntegrationRuntimeAzureSsis#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * key_vault_license block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#key_vault_license DataFactoryIntegrationRuntimeAzureSsis#key_vault_license}
     *
     * @stability stable
     */
    readonly keyVaultLicense?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent): any;
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#environment DataFactoryIntegrationRuntimeAzureSsis#environment}.
     *
     * @stability stable
     */
    readonly environment?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#powershell_version DataFactoryIntegrationRuntimeAzureSsis#powershell_version}.
     *
     * @stability stable
     */
    readonly powershellVersion?: string;
    /**
     * command_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#command_key DataFactoryIntegrationRuntimeAzureSsis#command_key}
     *
     * @stability stable
     */
    readonly commandKey?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey[];
    /**
     * component block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#component DataFactoryIntegrationRuntimeAzureSsis#component}
     *
     * @stability stable
     */
    readonly component?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent[];
}
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupOutputReference | DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup): any;
/**
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup | undefined);
    private _environment?;
    /**
     * @stability stable
     */
    get environment(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set environment(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnvironment(): void;
    /**
     * @stability stable
     */
    get environmentInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _powershellVersion?;
    /**
     * @stability stable
     */
    get powershellVersion(): string;
    /**
     * @stability stable
     */
    set powershellVersion(value: string);
    /**
     * @stability stable
     */
    resetPowershellVersion(): void;
    /**
     * @stability stable
     */
    get powershellVersionInput(): string | undefined;
    private _commandKey?;
    /**
     * @stability stable
     */
    get commandKey(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey[];
    /**
     * @stability stable
     */
    set commandKey(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey[]);
    /**
     * @stability stable
     */
    resetCommandKey(): void;
    /**
     * @stability stable
     */
    get commandKeyInput(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey[] | undefined;
    private _component?;
    /**
     * @stability stable
     */
    get component(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent[];
    /**
     * @stability stable
     */
    set component(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent[]);
    /**
     * @stability stable
     */
    resetComponent(): void;
    /**
     * @stability stable
     */
    get componentInput(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent[] | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeAzureSsisPackageStore {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#linked_service_name DataFactoryIntegrationRuntimeAzureSsis#linked_service_name}.
     *
     * @stability stable
     */
    readonly linkedServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#name DataFactoryIntegrationRuntimeAzureSsis#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisPackageStoreToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisPackageStore): any;
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeAzureSsisProxy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#path DataFactoryIntegrationRuntimeAzureSsis#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#self_hosted_integration_runtime_name DataFactoryIntegrationRuntimeAzureSsis#self_hosted_integration_runtime_name}.
     *
     * @stability stable
     */
    readonly selfHostedIntegrationRuntimeName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#staging_storage_linked_service_name DataFactoryIntegrationRuntimeAzureSsis#staging_storage_linked_service_name}.
     *
     * @stability stable
     */
    readonly stagingStorageLinkedServiceName: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisProxyToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisProxyOutputReference | DataFactoryIntegrationRuntimeAzureSsisProxy): any;
/**
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeAzureSsisProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisProxy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisProxy | undefined);
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _selfHostedIntegrationRuntimeName?;
    /**
     * @stability stable
     */
    get selfHostedIntegrationRuntimeName(): string;
    /**
     * @stability stable
     */
    set selfHostedIntegrationRuntimeName(value: string);
    /**
     * @stability stable
     */
    get selfHostedIntegrationRuntimeNameInput(): string | undefined;
    private _stagingStorageLinkedServiceName?;
    /**
     * @stability stable
     */
    get stagingStorageLinkedServiceName(): string;
    /**
     * @stability stable
     */
    set stagingStorageLinkedServiceName(value: string);
    /**
     * @stability stable
     */
    get stagingStorageLinkedServiceNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeAzureSsisTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#create DataFactoryIntegrationRuntimeAzureSsis#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#delete DataFactoryIntegrationRuntimeAzureSsis#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#read DataFactoryIntegrationRuntimeAzureSsis#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#update DataFactoryIntegrationRuntimeAzureSsis#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisTimeoutsToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisTimeoutsOutputReference | DataFactoryIntegrationRuntimeAzureSsisTimeouts): any;
/**
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeAzureSsisTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeAzureSsisVnetIntegration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#public_ips DataFactoryIntegrationRuntimeAzureSsis#public_ips}.
     *
     * @stability stable
     */
    readonly publicIps?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#subnet_id DataFactoryIntegrationRuntimeAzureSsis#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#subnet_name DataFactoryIntegrationRuntimeAzureSsis#subnet_name}.
     *
     * @stability stable
     */
    readonly subnetName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis#vnet_id DataFactoryIntegrationRuntimeAzureSsis#vnet_id}.
     *
     * @stability stable
     */
    readonly vnetId?: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisVnetIntegrationToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisVnetIntegrationOutputReference | DataFactoryIntegrationRuntimeAzureSsisVnetIntegration): any;
/**
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeAzureSsisVnetIntegrationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisVnetIntegration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisVnetIntegration | undefined);
    private _publicIps?;
    /**
     * @stability stable
     */
    get publicIps(): string[];
    /**
     * @stability stable
     */
    set publicIps(value: string[]);
    /**
     * @stability stable
     */
    resetPublicIps(): void;
    /**
     * @stability stable
     */
    get publicIpsInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _subnetName?;
    /**
     * @stability stable
     */
    get subnetName(): string;
    /**
     * @stability stable
     */
    set subnetName(value: string);
    /**
     * @stability stable
     */
    resetSubnetName(): void;
    /**
     * @stability stable
     */
    get subnetNameInput(): string | undefined;
    private _vnetId?;
    /**
     * @stability stable
     */
    get vnetId(): string;
    /**
     * @stability stable
     */
    set vnetId(value: string);
    /**
     * @stability stable
     */
    resetVnetId(): void;
    /**
     * @stability stable
     */
    get vnetIdInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis azurerm_data_factory_integration_runtime_azure_ssis}.
 *
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeAzureSsis extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_azure_ssis azurerm_data_factory_integration_runtime_azure_ssis} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryIntegrationRuntimeAzureSsisConfig);
    private _dataFactoryId?;
    /**
     * @stability stable
     */
    get dataFactoryId(): string;
    /**
     * @stability stable
     */
    set dataFactoryId(value: string);
    /**
     * @stability stable
     */
    resetDataFactoryId(): void;
    /**
     * @stability stable
     */
    get dataFactoryIdInput(): string | undefined;
    private _dataFactoryName?;
    /**
     * @stability stable
     */
    get dataFactoryName(): string;
    /**
     * @stability stable
     */
    set dataFactoryName(value: string);
    /**
     * @stability stable
     */
    resetDataFactoryName(): void;
    /**
     * @stability stable
     */
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _edition?;
    /**
     * @stability stable
     */
    get edition(): string;
    /**
     * @stability stable
     */
    set edition(value: string);
    /**
     * @stability stable
     */
    resetEdition(): void;
    /**
     * @stability stable
     */
    get editionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _licenseType?;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    set licenseType(value: string);
    /**
     * @stability stable
     */
    resetLicenseType(): void;
    /**
     * @stability stable
     */
    get licenseTypeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maxParallelExecutionsPerNode?;
    /**
     * @stability stable
     */
    get maxParallelExecutionsPerNode(): number;
    /**
     * @stability stable
     */
    set maxParallelExecutionsPerNode(value: number);
    /**
     * @stability stable
     */
    resetMaxParallelExecutionsPerNode(): void;
    /**
     * @stability stable
     */
    get maxParallelExecutionsPerNodeInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeSize?;
    /**
     * @stability stable
     */
    get nodeSize(): string;
    /**
     * @stability stable
     */
    set nodeSize(value: string);
    /**
     * @stability stable
     */
    get nodeSizeInput(): string | undefined;
    private _numberOfNodes?;
    /**
     * @stability stable
     */
    get numberOfNodes(): number;
    /**
     * @stability stable
     */
    set numberOfNodes(value: number);
    /**
     * @stability stable
     */
    resetNumberOfNodes(): void;
    /**
     * @stability stable
     */
    get numberOfNodesInput(): number | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _catalogInfo;
    /**
     * @stability stable
     */
    get catalogInfo(): DataFactoryIntegrationRuntimeAzureSsisCatalogInfoOutputReference;
    /**
     * @stability stable
     */
    putCatalogInfo(value: DataFactoryIntegrationRuntimeAzureSsisCatalogInfo): void;
    /**
     * @stability stable
     */
    resetCatalogInfo(): void;
    /**
     * @stability stable
     */
    get catalogInfoInput(): DataFactoryIntegrationRuntimeAzureSsisCatalogInfo | undefined;
    private _customSetupScript;
    /**
     * @stability stable
     */
    get customSetupScript(): DataFactoryIntegrationRuntimeAzureSsisCustomSetupScriptOutputReference;
    /**
     * @stability stable
     */
    putCustomSetupScript(value: DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript): void;
    /**
     * @stability stable
     */
    resetCustomSetupScript(): void;
    /**
     * @stability stable
     */
    get customSetupScriptInput(): DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript | undefined;
    private _expressCustomSetup;
    /**
     * @stability stable
     */
    get expressCustomSetup(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupOutputReference;
    /**
     * @stability stable
     */
    putExpressCustomSetup(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup): void;
    /**
     * @stability stable
     */
    resetExpressCustomSetup(): void;
    /**
     * @stability stable
     */
    get expressCustomSetupInput(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup | undefined;
    private _packageStore?;
    /**
     * @stability stable
     */
    get packageStore(): DataFactoryIntegrationRuntimeAzureSsisPackageStore[];
    /**
     * @stability stable
     */
    set packageStore(value: DataFactoryIntegrationRuntimeAzureSsisPackageStore[]);
    /**
     * @stability stable
     */
    resetPackageStore(): void;
    /**
     * @stability stable
     */
    get packageStoreInput(): DataFactoryIntegrationRuntimeAzureSsisPackageStore[] | undefined;
    private _proxy;
    /**
     * @stability stable
     */
    get proxy(): DataFactoryIntegrationRuntimeAzureSsisProxyOutputReference;
    /**
     * @stability stable
     */
    putProxy(value: DataFactoryIntegrationRuntimeAzureSsisProxy): void;
    /**
     * @stability stable
     */
    resetProxy(): void;
    /**
     * @stability stable
     */
    get proxyInput(): DataFactoryIntegrationRuntimeAzureSsisProxy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryIntegrationRuntimeAzureSsisTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryIntegrationRuntimeAzureSsisTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryIntegrationRuntimeAzureSsisTimeouts | undefined;
    private _vnetIntegration;
    /**
     * @stability stable
     */
    get vnetIntegration(): DataFactoryIntegrationRuntimeAzureSsisVnetIntegrationOutputReference;
    /**
     * @stability stable
     */
    putVnetIntegration(value: DataFactoryIntegrationRuntimeAzureSsisVnetIntegration): void;
    /**
     * @stability stable
     */
    resetVnetIntegration(): void;
    /**
     * @stability stable
     */
    get vnetIntegrationInput(): DataFactoryIntegrationRuntimeAzureSsisVnetIntegration | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
