import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataShareDatasetDataLakeGen1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#data_lake_store_id DataShareDatasetDataLakeGen1#data_lake_store_id}.
     *
     * @stability stable
     */
    readonly dataLakeStoreId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#data_share_id DataShareDatasetDataLakeGen1#data_share_id}.
     *
     * @stability stable
     */
    readonly dataShareId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#file_name DataShareDatasetDataLakeGen1#file_name}.
     *
     * @stability stable
     */
    readonly fileName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#folder_path DataShareDatasetDataLakeGen1#folder_path}.
     *
     * @stability stable
     */
    readonly folderPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#name DataShareDatasetDataLakeGen1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#timeouts DataShareDatasetDataLakeGen1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataShareDatasetDataLakeGen1Timeouts;
}
/**
 * @stability stable
 */
export interface DataShareDatasetDataLakeGen1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#create DataShareDatasetDataLakeGen1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#delete DataShareDatasetDataLakeGen1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1#read DataShareDatasetDataLakeGen1#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataShareDatasetDataLakeGen1TimeoutsToTerraform(struct?: DataShareDatasetDataLakeGen1TimeoutsOutputReference | DataShareDatasetDataLakeGen1Timeouts): any;
/**
 * @stability stable
 */
export declare class DataShareDatasetDataLakeGen1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataShareDatasetDataLakeGen1Timeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataShareDatasetDataLakeGen1Timeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1 azurerm_data_share_dataset_data_lake_gen1}.
 *
 * @stability stable
 */
export declare class DataShareDatasetDataLakeGen1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen1 azurerm_data_share_dataset_data_lake_gen1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataShareDatasetDataLakeGen1Config);
    private _dataLakeStoreId?;
    /**
     * @stability stable
     */
    get dataLakeStoreId(): string;
    /**
     * @stability stable
     */
    set dataLakeStoreId(value: string);
    /**
     * @stability stable
     */
    get dataLakeStoreIdInput(): string | undefined;
    private _dataShareId?;
    /**
     * @stability stable
     */
    get dataShareId(): string;
    /**
     * @stability stable
     */
    set dataShareId(value: string);
    /**
     * @stability stable
     */
    get dataShareIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get displayName(): string;
    private _fileName?;
    /**
     * @stability stable
     */
    get fileName(): string;
    /**
     * @stability stable
     */
    set fileName(value: string);
    /**
     * @stability stable
     */
    resetFileName(): void;
    /**
     * @stability stable
     */
    get fileNameInput(): string | undefined;
    private _folderPath?;
    /**
     * @stability stable
     */
    get folderPath(): string;
    /**
     * @stability stable
     */
    set folderPath(value: string);
    /**
     * @stability stable
     */
    get folderPathInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataShareDatasetDataLakeGen1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataShareDatasetDataLakeGen1Timeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataShareDatasetDataLakeGen1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
