import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DatabricksWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#customer_managed_key_enabled DatabricksWorkspace#customer_managed_key_enabled}.
     *
     * @stability stable
     */
    readonly customerManagedKeyEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#infrastructure_encryption_enabled DatabricksWorkspace#infrastructure_encryption_enabled}.
     *
     * @stability stable
     */
    readonly infrastructureEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#load_balancer_backend_address_pool_id DatabricksWorkspace#load_balancer_backend_address_pool_id}.
     *
     * @stability stable
     */
    readonly loadBalancerBackendAddressPoolId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#location DatabricksWorkspace#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#managed_resource_group_name DatabricksWorkspace#managed_resource_group_name}.
     *
     * @stability stable
     */
    readonly managedResourceGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#managed_services_cmk_key_vault_key_id DatabricksWorkspace#managed_services_cmk_key_vault_key_id}.
     *
     * @stability stable
     */
    readonly managedServicesCmkKeyVaultKeyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#name DatabricksWorkspace#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#network_security_group_rules_required DatabricksWorkspace#network_security_group_rules_required}.
     *
     * @stability stable
     */
    readonly networkSecurityGroupRulesRequired?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#public_network_access_enabled DatabricksWorkspace#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#resource_group_name DatabricksWorkspace#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#sku DatabricksWorkspace#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#tags DatabricksWorkspace#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * custom_parameters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#custom_parameters DatabricksWorkspace#custom_parameters}
     *
     * @stability stable
     */
    readonly customParameters?: DatabricksWorkspaceCustomParameters;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#timeouts DatabricksWorkspace#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DatabricksWorkspaceTimeouts;
}
/**
 * @stability stable
 */
export declare class DatabricksWorkspaceStorageAccountIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export interface DatabricksWorkspaceCustomParameters {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#machine_learning_workspace_id DatabricksWorkspace#machine_learning_workspace_id}.
     *
     * @stability stable
     */
    readonly machineLearningWorkspaceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#nat_gateway_name DatabricksWorkspace#nat_gateway_name}.
     *
     * @stability stable
     */
    readonly natGatewayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#no_public_ip DatabricksWorkspace#no_public_ip}.
     *
     * @stability stable
     */
    readonly noPublicIp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#private_subnet_name DatabricksWorkspace#private_subnet_name}.
     *
     * @stability stable
     */
    readonly privateSubnetName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#private_subnet_network_security_group_association_id DatabricksWorkspace#private_subnet_network_security_group_association_id}.
     *
     * @stability stable
     */
    readonly privateSubnetNetworkSecurityGroupAssociationId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#public_ip_name DatabricksWorkspace#public_ip_name}.
     *
     * @stability stable
     */
    readonly publicIpName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#public_subnet_name DatabricksWorkspace#public_subnet_name}.
     *
     * @stability stable
     */
    readonly publicSubnetName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#public_subnet_network_security_group_association_id DatabricksWorkspace#public_subnet_network_security_group_association_id}.
     *
     * @stability stable
     */
    readonly publicSubnetNetworkSecurityGroupAssociationId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#storage_account_name DatabricksWorkspace#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#storage_account_sku_name DatabricksWorkspace#storage_account_sku_name}.
     *
     * @stability stable
     */
    readonly storageAccountSkuName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#virtual_network_id DatabricksWorkspace#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#vnet_address_prefix DatabricksWorkspace#vnet_address_prefix}.
     *
     * @stability stable
     */
    readonly vnetAddressPrefix?: string;
}
export declare function databricksWorkspaceCustomParametersToTerraform(struct?: DatabricksWorkspaceCustomParametersOutputReference | DatabricksWorkspaceCustomParameters): any;
/**
 * @stability stable
 */
export declare class DatabricksWorkspaceCustomParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DatabricksWorkspaceCustomParameters | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DatabricksWorkspaceCustomParameters | undefined);
    private _machineLearningWorkspaceId?;
    /**
     * @stability stable
     */
    get machineLearningWorkspaceId(): string;
    /**
     * @stability stable
     */
    set machineLearningWorkspaceId(value: string);
    /**
     * @stability stable
     */
    resetMachineLearningWorkspaceId(): void;
    /**
     * @stability stable
     */
    get machineLearningWorkspaceIdInput(): string | undefined;
    private _natGatewayName?;
    /**
     * @stability stable
     */
    get natGatewayName(): string;
    /**
     * @stability stable
     */
    set natGatewayName(value: string);
    /**
     * @stability stable
     */
    resetNatGatewayName(): void;
    /**
     * @stability stable
     */
    get natGatewayNameInput(): string | undefined;
    private _noPublicIp?;
    /**
     * @stability stable
     */
    get noPublicIp(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set noPublicIp(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNoPublicIp(): void;
    /**
     * @stability stable
     */
    get noPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _privateSubnetName?;
    /**
     * @stability stable
     */
    get privateSubnetName(): string;
    /**
     * @stability stable
     */
    set privateSubnetName(value: string);
    /**
     * @stability stable
     */
    resetPrivateSubnetName(): void;
    /**
     * @stability stable
     */
    get privateSubnetNameInput(): string | undefined;
    private _privateSubnetNetworkSecurityGroupAssociationId?;
    /**
     * @stability stable
     */
    get privateSubnetNetworkSecurityGroupAssociationId(): string;
    /**
     * @stability stable
     */
    set privateSubnetNetworkSecurityGroupAssociationId(value: string);
    /**
     * @stability stable
     */
    resetPrivateSubnetNetworkSecurityGroupAssociationId(): void;
    /**
     * @stability stable
     */
    get privateSubnetNetworkSecurityGroupAssociationIdInput(): string | undefined;
    private _publicIpName?;
    /**
     * @stability stable
     */
    get publicIpName(): string;
    /**
     * @stability stable
     */
    set publicIpName(value: string);
    /**
     * @stability stable
     */
    resetPublicIpName(): void;
    /**
     * @stability stable
     */
    get publicIpNameInput(): string | undefined;
    private _publicSubnetName?;
    /**
     * @stability stable
     */
    get publicSubnetName(): string;
    /**
     * @stability stable
     */
    set publicSubnetName(value: string);
    /**
     * @stability stable
     */
    resetPublicSubnetName(): void;
    /**
     * @stability stable
     */
    get publicSubnetNameInput(): string | undefined;
    private _publicSubnetNetworkSecurityGroupAssociationId?;
    /**
     * @stability stable
     */
    get publicSubnetNetworkSecurityGroupAssociationId(): string;
    /**
     * @stability stable
     */
    set publicSubnetNetworkSecurityGroupAssociationId(value: string);
    /**
     * @stability stable
     */
    resetPublicSubnetNetworkSecurityGroupAssociationId(): void;
    /**
     * @stability stable
     */
    get publicSubnetNetworkSecurityGroupAssociationIdInput(): string | undefined;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountName(): void;
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _storageAccountSkuName?;
    /**
     * @stability stable
     */
    get storageAccountSkuName(): string;
    /**
     * @stability stable
     */
    set storageAccountSkuName(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountSkuName(): void;
    /**
     * @stability stable
     */
    get storageAccountSkuNameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vnetAddressPrefix?;
    /**
     * @stability stable
     */
    get vnetAddressPrefix(): string;
    /**
     * @stability stable
     */
    set vnetAddressPrefix(value: string);
    /**
     * @stability stable
     */
    resetVnetAddressPrefix(): void;
    /**
     * @stability stable
     */
    get vnetAddressPrefixInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DatabricksWorkspaceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#create DatabricksWorkspace#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#delete DatabricksWorkspace#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#read DatabricksWorkspace#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace#update DatabricksWorkspace#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function databricksWorkspaceTimeoutsToTerraform(struct?: DatabricksWorkspaceTimeoutsOutputReference | DatabricksWorkspaceTimeouts): any;
/**
 * @stability stable
 */
export declare class DatabricksWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DatabricksWorkspaceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DatabricksWorkspaceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace azurerm_databricks_workspace}.
 *
 * @stability stable
 */
export declare class DatabricksWorkspace extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace azurerm_databricks_workspace} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DatabricksWorkspaceConfig);
    private _customerManagedKeyEnabled?;
    /**
     * @stability stable
     */
    get customerManagedKeyEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customerManagedKeyEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomerManagedKeyEnabled(): void;
    /**
     * @stability stable
     */
    get customerManagedKeyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _infrastructureEncryptionEnabled?;
    /**
     * @stability stable
     */
    get infrastructureEncryptionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set infrastructureEncryptionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInfrastructureEncryptionEnabled(): void;
    /**
     * @stability stable
     */
    get infrastructureEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _loadBalancerBackendAddressPoolId?;
    /**
     * @stability stable
     */
    get loadBalancerBackendAddressPoolId(): string;
    /**
     * @stability stable
     */
    set loadBalancerBackendAddressPoolId(value: string);
    /**
     * @stability stable
     */
    resetLoadBalancerBackendAddressPoolId(): void;
    /**
     * @stability stable
     */
    get loadBalancerBackendAddressPoolIdInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get managedResourceGroupId(): string;
    private _managedResourceGroupName?;
    /**
     * @stability stable
     */
    get managedResourceGroupName(): string;
    /**
     * @stability stable
     */
    set managedResourceGroupName(value: string);
    /**
     * @stability stable
     */
    resetManagedResourceGroupName(): void;
    /**
     * @stability stable
     */
    get managedResourceGroupNameInput(): string | undefined;
    private _managedServicesCmkKeyVaultKeyId?;
    /**
     * @stability stable
     */
    get managedServicesCmkKeyVaultKeyId(): string;
    /**
     * @stability stable
     */
    set managedServicesCmkKeyVaultKeyId(value: string);
    /**
     * @stability stable
     */
    resetManagedServicesCmkKeyVaultKeyId(): void;
    /**
     * @stability stable
     */
    get managedServicesCmkKeyVaultKeyIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkSecurityGroupRulesRequired?;
    /**
     * @stability stable
     */
    get networkSecurityGroupRulesRequired(): string;
    /**
     * @stability stable
     */
    set networkSecurityGroupRulesRequired(value: string);
    /**
     * @stability stable
     */
    resetNetworkSecurityGroupRulesRequired(): void;
    /**
     * @stability stable
     */
    get networkSecurityGroupRulesRequiredInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    /**
     * @stability stable
     */
    storageAccountIdentity(index: string): DatabricksWorkspaceStorageAccountIdentity;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get workspaceId(): string;
    /**
     * @stability stable
     */
    get workspaceUrl(): string;
    private _customParameters;
    /**
     * @stability stable
     */
    get customParameters(): DatabricksWorkspaceCustomParametersOutputReference;
    /**
     * @stability stable
     */
    putCustomParameters(value: DatabricksWorkspaceCustomParameters): void;
    /**
     * @stability stable
     */
    resetCustomParameters(): void;
    /**
     * @stability stable
     */
    get customParametersInput(): DatabricksWorkspaceCustomParameters | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DatabricksWorkspaceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DatabricksWorkspaceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DatabricksWorkspaceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
