import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DiskEncryptionSetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#auto_key_rotation_enabled DiskEncryptionSet#auto_key_rotation_enabled}.
     *
     * @stability stable
     */
    readonly autoKeyRotationEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#encryption_type DiskEncryptionSet#encryption_type}.
     *
     * @stability stable
     */
    readonly encryptionType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#key_vault_key_id DiskEncryptionSet#key_vault_key_id}.
     *
     * @stability stable
     */
    readonly keyVaultKeyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#location DiskEncryptionSet#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#name DiskEncryptionSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#resource_group_name DiskEncryptionSet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#tags DiskEncryptionSet#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#identity DiskEncryptionSet#identity}
     *
     * @stability stable
     */
    readonly identity: DiskEncryptionSetIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#timeouts DiskEncryptionSet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DiskEncryptionSetTimeouts;
}
/**
 * @stability stable
 */
export interface DiskEncryptionSetIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#type DiskEncryptionSet#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function diskEncryptionSetIdentityToTerraform(struct?: DiskEncryptionSetIdentityOutputReference | DiskEncryptionSetIdentity): any;
/**
 * @stability stable
 */
export declare class DiskEncryptionSetIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DiskEncryptionSetIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DiskEncryptionSetIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DiskEncryptionSetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#create DiskEncryptionSet#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#delete DiskEncryptionSet#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#read DiskEncryptionSet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set#update DiskEncryptionSet#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function diskEncryptionSetTimeoutsToTerraform(struct?: DiskEncryptionSetTimeoutsOutputReference | DiskEncryptionSetTimeouts): any;
/**
 * @stability stable
 */
export declare class DiskEncryptionSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DiskEncryptionSetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DiskEncryptionSetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set azurerm_disk_encryption_set}.
 *
 * @stability stable
 */
export declare class DiskEncryptionSet extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/disk_encryption_set azurerm_disk_encryption_set} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DiskEncryptionSetConfig);
    private _autoKeyRotationEnabled?;
    /**
     * @stability stable
     */
    get autoKeyRotationEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoKeyRotationEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoKeyRotationEnabled(): void;
    /**
     * @stability stable
     */
    get autoKeyRotationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionType?;
    /**
     * @stability stable
     */
    get encryptionType(): string;
    /**
     * @stability stable
     */
    set encryptionType(value: string);
    /**
     * @stability stable
     */
    resetEncryptionType(): void;
    /**
     * @stability stable
     */
    get encryptionTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultKeyId?;
    /**
     * @stability stable
     */
    get keyVaultKeyId(): string;
    /**
     * @stability stable
     */
    set keyVaultKeyId(value: string);
    /**
     * @stability stable
     */
    get keyVaultKeyIdInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): DiskEncryptionSetIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: DiskEncryptionSetIdentity): void;
    /**
     * @stability stable
     */
    get identityInput(): DiskEncryptionSetIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DiskEncryptionSetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DiskEncryptionSetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DiskEncryptionSetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
