import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#advanced_filtering_on_arrays_enabled EventgridEventSubscription#advanced_filtering_on_arrays_enabled}.
     *
     * @stability stable
     */
    readonly advancedFilteringOnArraysEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#event_delivery_schema EventgridEventSubscription#event_delivery_schema}.
     *
     * @stability stable
     */
    readonly eventDeliverySchema?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#eventhub_endpoint_id EventgridEventSubscription#eventhub_endpoint_id}.
     *
     * @stability stable
     */
    readonly eventhubEndpointId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#expiration_time_utc EventgridEventSubscription#expiration_time_utc}.
     *
     * @stability stable
     */
    readonly expirationTimeUtc?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#hybrid_connection_endpoint_id EventgridEventSubscription#hybrid_connection_endpoint_id}.
     *
     * @stability stable
     */
    readonly hybridConnectionEndpointId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#included_event_types EventgridEventSubscription#included_event_types}.
     *
     * @stability stable
     */
    readonly includedEventTypes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#labels EventgridEventSubscription#labels}.
     *
     * @stability stable
     */
    readonly labels?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#name EventgridEventSubscription#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#scope EventgridEventSubscription#scope}.
     *
     * @stability stable
     */
    readonly scope: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#service_bus_queue_endpoint_id EventgridEventSubscription#service_bus_queue_endpoint_id}.
     *
     * @stability stable
     */
    readonly serviceBusQueueEndpointId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#service_bus_topic_endpoint_id EventgridEventSubscription#service_bus_topic_endpoint_id}.
     *
     * @stability stable
     */
    readonly serviceBusTopicEndpointId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#topic_name EventgridEventSubscription#topic_name}.
     *
     * @stability stable
     */
    readonly topicName?: string;
    /**
     * advanced_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#advanced_filter EventgridEventSubscription#advanced_filter}
     *
     * @stability stable
     */
    readonly advancedFilter?: EventgridEventSubscriptionAdvancedFilter;
    /**
     * azure_function_endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#azure_function_endpoint EventgridEventSubscription#azure_function_endpoint}
     *
     * @stability stable
     */
    readonly azureFunctionEndpoint?: EventgridEventSubscriptionAzureFunctionEndpoint;
    /**
     * dead_letter_identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#dead_letter_identity EventgridEventSubscription#dead_letter_identity}
     *
     * @stability stable
     */
    readonly deadLetterIdentity?: EventgridEventSubscriptionDeadLetterIdentity;
    /**
     * delivery_identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#delivery_identity EventgridEventSubscription#delivery_identity}
     *
     * @stability stable
     */
    readonly deliveryIdentity?: EventgridEventSubscriptionDeliveryIdentity;
    /**
     * delivery_property block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#delivery_property EventgridEventSubscription#delivery_property}
     *
     * @stability stable
     */
    readonly deliveryProperty?: EventgridEventSubscriptionDeliveryProperty[];
    /**
     * eventhub_endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#eventhub_endpoint EventgridEventSubscription#eventhub_endpoint}
     *
     * @stability stable
     */
    readonly eventhubEndpoint?: EventgridEventSubscriptionEventhubEndpoint;
    /**
     * hybrid_connection_endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#hybrid_connection_endpoint EventgridEventSubscription#hybrid_connection_endpoint}
     *
     * @stability stable
     */
    readonly hybridConnectionEndpoint?: EventgridEventSubscriptionHybridConnectionEndpoint;
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#retry_policy EventgridEventSubscription#retry_policy}
     *
     * @stability stable
     */
    readonly retryPolicy?: EventgridEventSubscriptionRetryPolicy;
    /**
     * storage_blob_dead_letter_destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#storage_blob_dead_letter_destination EventgridEventSubscription#storage_blob_dead_letter_destination}
     *
     * @stability stable
     */
    readonly storageBlobDeadLetterDestination?: EventgridEventSubscriptionStorageBlobDeadLetterDestination;
    /**
     * storage_queue_endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#storage_queue_endpoint EventgridEventSubscription#storage_queue_endpoint}
     *
     * @stability stable
     */
    readonly storageQueueEndpoint?: EventgridEventSubscriptionStorageQueueEndpoint;
    /**
     * subject_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#subject_filter EventgridEventSubscription#subject_filter}
     *
     * @stability stable
     */
    readonly subjectFilter?: EventgridEventSubscriptionSubjectFilter;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#timeouts EventgridEventSubscription#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EventgridEventSubscriptionTimeouts;
    /**
     * webhook_endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#webhook_endpoint EventgridEventSubscription#webhook_endpoint}
     *
     * @stability stable
     */
    readonly webhookEndpoint?: EventgridEventSubscriptionWebhookEndpoint;
}
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterBoolEquals {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#value EventgridEventSubscription#value}.
     *
     * @stability stable
     */
    readonly value: boolean | cdktf.IResolvable;
}
export declare function eventgridEventSubscriptionAdvancedFilterBoolEqualsToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterBoolEquals): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterIsNotNull {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
}
export declare function eventgridEventSubscriptionAdvancedFilterIsNotNullToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterIsNotNull): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterIsNullOrUndefined {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
}
export declare function eventgridEventSubscriptionAdvancedFilterIsNullOrUndefinedToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterIsNullOrUndefined): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterNumberGreaterThan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#value EventgridEventSubscription#value}.
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberGreaterThanToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberGreaterThan): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#value EventgridEventSubscription#value}.
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEqualsToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterNumberIn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: number[];
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberInToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberIn): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterNumberInRange {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: number[];
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberInRangeToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberInRange): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterNumberLessThan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#value EventgridEventSubscription#value}.
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberLessThanToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberLessThan): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterNumberLessThanOrEquals {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#value EventgridEventSubscription#value}.
     *
     * @stability stable
     */
    readonly value: number;
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberLessThanOrEqualsToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberLessThanOrEquals): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterNumberNotIn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: number[];
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberNotInToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberNotIn): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterNumberNotInRange {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: number[];
}
export declare function eventgridEventSubscriptionAdvancedFilterNumberNotInRangeToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterNumberNotInRange): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterStringBeginsWith {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringBeginsWithToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringBeginsWith): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterStringContains {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringContainsToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringContains): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterStringEndsWith {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringEndsWithToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringEndsWith): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterStringIn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringInToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringIn): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterStringNotBeginsWith {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringNotBeginsWithToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringNotBeginsWith): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterStringNotContains {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringNotContainsToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringNotContains): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterStringNotEndsWith {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringNotEndsWithToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringNotEndsWith): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilterStringNotIn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#key EventgridEventSubscription#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#values EventgridEventSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function eventgridEventSubscriptionAdvancedFilterStringNotInToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterStringNotIn): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAdvancedFilter {
    /**
     * bool_equals block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#bool_equals EventgridEventSubscription#bool_equals}
     *
     * @stability stable
     */
    readonly boolEquals?: EventgridEventSubscriptionAdvancedFilterBoolEquals[];
    /**
     * is_not_null block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#is_not_null EventgridEventSubscription#is_not_null}
     *
     * @stability stable
     */
    readonly isNotNull?: EventgridEventSubscriptionAdvancedFilterIsNotNull[];
    /**
     * is_null_or_undefined block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#is_null_or_undefined EventgridEventSubscription#is_null_or_undefined}
     *
     * @stability stable
     */
    readonly isNullOrUndefined?: EventgridEventSubscriptionAdvancedFilterIsNullOrUndefined[];
    /**
     * number_greater_than block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_greater_than EventgridEventSubscription#number_greater_than}
     *
     * @stability stable
     */
    readonly numberGreaterThan?: EventgridEventSubscriptionAdvancedFilterNumberGreaterThan[];
    /**
     * number_greater_than_or_equals block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_greater_than_or_equals EventgridEventSubscription#number_greater_than_or_equals}
     *
     * @stability stable
     */
    readonly numberGreaterThanOrEquals?: EventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals[];
    /**
     * number_in block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_in EventgridEventSubscription#number_in}
     *
     * @stability stable
     */
    readonly numberIn?: EventgridEventSubscriptionAdvancedFilterNumberIn[];
    /**
     * number_in_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_in_range EventgridEventSubscription#number_in_range}
     *
     * @stability stable
     */
    readonly numberInRange?: EventgridEventSubscriptionAdvancedFilterNumberInRange[];
    /**
     * number_less_than block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_less_than EventgridEventSubscription#number_less_than}
     *
     * @stability stable
     */
    readonly numberLessThan?: EventgridEventSubscriptionAdvancedFilterNumberLessThan[];
    /**
     * number_less_than_or_equals block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_less_than_or_equals EventgridEventSubscription#number_less_than_or_equals}
     *
     * @stability stable
     */
    readonly numberLessThanOrEquals?: EventgridEventSubscriptionAdvancedFilterNumberLessThanOrEquals[];
    /**
     * number_not_in block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_not_in EventgridEventSubscription#number_not_in}
     *
     * @stability stable
     */
    readonly numberNotIn?: EventgridEventSubscriptionAdvancedFilterNumberNotIn[];
    /**
     * number_not_in_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#number_not_in_range EventgridEventSubscription#number_not_in_range}
     *
     * @stability stable
     */
    readonly numberNotInRange?: EventgridEventSubscriptionAdvancedFilterNumberNotInRange[];
    /**
     * string_begins_with block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_begins_with EventgridEventSubscription#string_begins_with}
     *
     * @stability stable
     */
    readonly stringBeginsWith?: EventgridEventSubscriptionAdvancedFilterStringBeginsWith[];
    /**
     * string_contains block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_contains EventgridEventSubscription#string_contains}
     *
     * @stability stable
     */
    readonly stringContains?: EventgridEventSubscriptionAdvancedFilterStringContains[];
    /**
     * string_ends_with block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_ends_with EventgridEventSubscription#string_ends_with}
     *
     * @stability stable
     */
    readonly stringEndsWith?: EventgridEventSubscriptionAdvancedFilterStringEndsWith[];
    /**
     * string_in block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_in EventgridEventSubscription#string_in}
     *
     * @stability stable
     */
    readonly stringIn?: EventgridEventSubscriptionAdvancedFilterStringIn[];
    /**
     * string_not_begins_with block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_not_begins_with EventgridEventSubscription#string_not_begins_with}
     *
     * @stability stable
     */
    readonly stringNotBeginsWith?: EventgridEventSubscriptionAdvancedFilterStringNotBeginsWith[];
    /**
     * string_not_contains block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_not_contains EventgridEventSubscription#string_not_contains}
     *
     * @stability stable
     */
    readonly stringNotContains?: EventgridEventSubscriptionAdvancedFilterStringNotContains[];
    /**
     * string_not_ends_with block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_not_ends_with EventgridEventSubscription#string_not_ends_with}
     *
     * @stability stable
     */
    readonly stringNotEndsWith?: EventgridEventSubscriptionAdvancedFilterStringNotEndsWith[];
    /**
     * string_not_in block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#string_not_in EventgridEventSubscription#string_not_in}
     *
     * @stability stable
     */
    readonly stringNotIn?: EventgridEventSubscriptionAdvancedFilterStringNotIn[];
}
export declare function eventgridEventSubscriptionAdvancedFilterToTerraform(struct?: EventgridEventSubscriptionAdvancedFilterOutputReference | EventgridEventSubscriptionAdvancedFilter): any;
/**
 * @stability stable
 */
export declare class EventgridEventSubscriptionAdvancedFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridEventSubscriptionAdvancedFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridEventSubscriptionAdvancedFilter | undefined);
    private _boolEquals?;
    /**
     * @stability stable
     */
    get boolEquals(): EventgridEventSubscriptionAdvancedFilterBoolEquals[];
    /**
     * @stability stable
     */
    set boolEquals(value: EventgridEventSubscriptionAdvancedFilterBoolEquals[]);
    /**
     * @stability stable
     */
    resetBoolEquals(): void;
    /**
     * @stability stable
     */
    get boolEqualsInput(): EventgridEventSubscriptionAdvancedFilterBoolEquals[] | undefined;
    private _isNotNull?;
    /**
     * @stability stable
     */
    get isNotNull(): EventgridEventSubscriptionAdvancedFilterIsNotNull[];
    /**
     * @stability stable
     */
    set isNotNull(value: EventgridEventSubscriptionAdvancedFilterIsNotNull[]);
    /**
     * @stability stable
     */
    resetIsNotNull(): void;
    /**
     * @stability stable
     */
    get isNotNullInput(): EventgridEventSubscriptionAdvancedFilterIsNotNull[] | undefined;
    private _isNullOrUndefined?;
    /**
     * @stability stable
     */
    get isNullOrUndefined(): EventgridEventSubscriptionAdvancedFilterIsNullOrUndefined[];
    /**
     * @stability stable
     */
    set isNullOrUndefined(value: EventgridEventSubscriptionAdvancedFilterIsNullOrUndefined[]);
    /**
     * @stability stable
     */
    resetIsNullOrUndefined(): void;
    /**
     * @stability stable
     */
    get isNullOrUndefinedInput(): EventgridEventSubscriptionAdvancedFilterIsNullOrUndefined[] | undefined;
    private _numberGreaterThan?;
    /**
     * @stability stable
     */
    get numberGreaterThan(): EventgridEventSubscriptionAdvancedFilterNumberGreaterThan[];
    /**
     * @stability stable
     */
    set numberGreaterThan(value: EventgridEventSubscriptionAdvancedFilterNumberGreaterThan[]);
    /**
     * @stability stable
     */
    resetNumberGreaterThan(): void;
    /**
     * @stability stable
     */
    get numberGreaterThanInput(): EventgridEventSubscriptionAdvancedFilterNumberGreaterThan[] | undefined;
    private _numberGreaterThanOrEquals?;
    /**
     * @stability stable
     */
    get numberGreaterThanOrEquals(): EventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals[];
    /**
     * @stability stable
     */
    set numberGreaterThanOrEquals(value: EventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals[]);
    /**
     * @stability stable
     */
    resetNumberGreaterThanOrEquals(): void;
    /**
     * @stability stable
     */
    get numberGreaterThanOrEqualsInput(): EventgridEventSubscriptionAdvancedFilterNumberGreaterThanOrEquals[] | undefined;
    private _numberIn?;
    /**
     * @stability stable
     */
    get numberIn(): EventgridEventSubscriptionAdvancedFilterNumberIn[];
    /**
     * @stability stable
     */
    set numberIn(value: EventgridEventSubscriptionAdvancedFilterNumberIn[]);
    /**
     * @stability stable
     */
    resetNumberIn(): void;
    /**
     * @stability stable
     */
    get numberInInput(): EventgridEventSubscriptionAdvancedFilterNumberIn[] | undefined;
    private _numberInRange?;
    /**
     * @stability stable
     */
    get numberInRange(): EventgridEventSubscriptionAdvancedFilterNumberInRange[];
    /**
     * @stability stable
     */
    set numberInRange(value: EventgridEventSubscriptionAdvancedFilterNumberInRange[]);
    /**
     * @stability stable
     */
    resetNumberInRange(): void;
    /**
     * @stability stable
     */
    get numberInRangeInput(): EventgridEventSubscriptionAdvancedFilterNumberInRange[] | undefined;
    private _numberLessThan?;
    /**
     * @stability stable
     */
    get numberLessThan(): EventgridEventSubscriptionAdvancedFilterNumberLessThan[];
    /**
     * @stability stable
     */
    set numberLessThan(value: EventgridEventSubscriptionAdvancedFilterNumberLessThan[]);
    /**
     * @stability stable
     */
    resetNumberLessThan(): void;
    /**
     * @stability stable
     */
    get numberLessThanInput(): EventgridEventSubscriptionAdvancedFilterNumberLessThan[] | undefined;
    private _numberLessThanOrEquals?;
    /**
     * @stability stable
     */
    get numberLessThanOrEquals(): EventgridEventSubscriptionAdvancedFilterNumberLessThanOrEquals[];
    /**
     * @stability stable
     */
    set numberLessThanOrEquals(value: EventgridEventSubscriptionAdvancedFilterNumberLessThanOrEquals[]);
    /**
     * @stability stable
     */
    resetNumberLessThanOrEquals(): void;
    /**
     * @stability stable
     */
    get numberLessThanOrEqualsInput(): EventgridEventSubscriptionAdvancedFilterNumberLessThanOrEquals[] | undefined;
    private _numberNotIn?;
    /**
     * @stability stable
     */
    get numberNotIn(): EventgridEventSubscriptionAdvancedFilterNumberNotIn[];
    /**
     * @stability stable
     */
    set numberNotIn(value: EventgridEventSubscriptionAdvancedFilterNumberNotIn[]);
    /**
     * @stability stable
     */
    resetNumberNotIn(): void;
    /**
     * @stability stable
     */
    get numberNotInInput(): EventgridEventSubscriptionAdvancedFilterNumberNotIn[] | undefined;
    private _numberNotInRange?;
    /**
     * @stability stable
     */
    get numberNotInRange(): EventgridEventSubscriptionAdvancedFilterNumberNotInRange[];
    /**
     * @stability stable
     */
    set numberNotInRange(value: EventgridEventSubscriptionAdvancedFilterNumberNotInRange[]);
    /**
     * @stability stable
     */
    resetNumberNotInRange(): void;
    /**
     * @stability stable
     */
    get numberNotInRangeInput(): EventgridEventSubscriptionAdvancedFilterNumberNotInRange[] | undefined;
    private _stringBeginsWith?;
    /**
     * @stability stable
     */
    get stringBeginsWith(): EventgridEventSubscriptionAdvancedFilterStringBeginsWith[];
    /**
     * @stability stable
     */
    set stringBeginsWith(value: EventgridEventSubscriptionAdvancedFilterStringBeginsWith[]);
    /**
     * @stability stable
     */
    resetStringBeginsWith(): void;
    /**
     * @stability stable
     */
    get stringBeginsWithInput(): EventgridEventSubscriptionAdvancedFilterStringBeginsWith[] | undefined;
    private _stringContains?;
    /**
     * @stability stable
     */
    get stringContains(): EventgridEventSubscriptionAdvancedFilterStringContains[];
    /**
     * @stability stable
     */
    set stringContains(value: EventgridEventSubscriptionAdvancedFilterStringContains[]);
    /**
     * @stability stable
     */
    resetStringContains(): void;
    /**
     * @stability stable
     */
    get stringContainsInput(): EventgridEventSubscriptionAdvancedFilterStringContains[] | undefined;
    private _stringEndsWith?;
    /**
     * @stability stable
     */
    get stringEndsWith(): EventgridEventSubscriptionAdvancedFilterStringEndsWith[];
    /**
     * @stability stable
     */
    set stringEndsWith(value: EventgridEventSubscriptionAdvancedFilterStringEndsWith[]);
    /**
     * @stability stable
     */
    resetStringEndsWith(): void;
    /**
     * @stability stable
     */
    get stringEndsWithInput(): EventgridEventSubscriptionAdvancedFilterStringEndsWith[] | undefined;
    private _stringIn?;
    /**
     * @stability stable
     */
    get stringIn(): EventgridEventSubscriptionAdvancedFilterStringIn[];
    /**
     * @stability stable
     */
    set stringIn(value: EventgridEventSubscriptionAdvancedFilterStringIn[]);
    /**
     * @stability stable
     */
    resetStringIn(): void;
    /**
     * @stability stable
     */
    get stringInInput(): EventgridEventSubscriptionAdvancedFilterStringIn[] | undefined;
    private _stringNotBeginsWith?;
    /**
     * @stability stable
     */
    get stringNotBeginsWith(): EventgridEventSubscriptionAdvancedFilterStringNotBeginsWith[];
    /**
     * @stability stable
     */
    set stringNotBeginsWith(value: EventgridEventSubscriptionAdvancedFilterStringNotBeginsWith[]);
    /**
     * @stability stable
     */
    resetStringNotBeginsWith(): void;
    /**
     * @stability stable
     */
    get stringNotBeginsWithInput(): EventgridEventSubscriptionAdvancedFilterStringNotBeginsWith[] | undefined;
    private _stringNotContains?;
    /**
     * @stability stable
     */
    get stringNotContains(): EventgridEventSubscriptionAdvancedFilterStringNotContains[];
    /**
     * @stability stable
     */
    set stringNotContains(value: EventgridEventSubscriptionAdvancedFilterStringNotContains[]);
    /**
     * @stability stable
     */
    resetStringNotContains(): void;
    /**
     * @stability stable
     */
    get stringNotContainsInput(): EventgridEventSubscriptionAdvancedFilterStringNotContains[] | undefined;
    private _stringNotEndsWith?;
    /**
     * @stability stable
     */
    get stringNotEndsWith(): EventgridEventSubscriptionAdvancedFilterStringNotEndsWith[];
    /**
     * @stability stable
     */
    set stringNotEndsWith(value: EventgridEventSubscriptionAdvancedFilterStringNotEndsWith[]);
    /**
     * @stability stable
     */
    resetStringNotEndsWith(): void;
    /**
     * @stability stable
     */
    get stringNotEndsWithInput(): EventgridEventSubscriptionAdvancedFilterStringNotEndsWith[] | undefined;
    private _stringNotIn?;
    /**
     * @stability stable
     */
    get stringNotIn(): EventgridEventSubscriptionAdvancedFilterStringNotIn[];
    /**
     * @stability stable
     */
    set stringNotIn(value: EventgridEventSubscriptionAdvancedFilterStringNotIn[]);
    /**
     * @stability stable
     */
    resetStringNotIn(): void;
    /**
     * @stability stable
     */
    get stringNotInInput(): EventgridEventSubscriptionAdvancedFilterStringNotIn[] | undefined;
}
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionAzureFunctionEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#function_id EventgridEventSubscription#function_id}.
     *
     * @stability stable
     */
    readonly functionId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#max_events_per_batch EventgridEventSubscription#max_events_per_batch}.
     *
     * @stability stable
     */
    readonly maxEventsPerBatch?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#preferred_batch_size_in_kilobytes EventgridEventSubscription#preferred_batch_size_in_kilobytes}.
     *
     * @stability stable
     */
    readonly preferredBatchSizeInKilobytes?: number;
}
export declare function eventgridEventSubscriptionAzureFunctionEndpointToTerraform(struct?: EventgridEventSubscriptionAzureFunctionEndpointOutputReference | EventgridEventSubscriptionAzureFunctionEndpoint): any;
/**
 * @stability stable
 */
export declare class EventgridEventSubscriptionAzureFunctionEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridEventSubscriptionAzureFunctionEndpoint | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridEventSubscriptionAzureFunctionEndpoint | undefined);
    private _functionId?;
    /**
     * @stability stable
     */
    get functionId(): string;
    /**
     * @stability stable
     */
    set functionId(value: string);
    /**
     * @stability stable
     */
    get functionIdInput(): string | undefined;
    private _maxEventsPerBatch?;
    /**
     * @stability stable
     */
    get maxEventsPerBatch(): number;
    /**
     * @stability stable
     */
    set maxEventsPerBatch(value: number);
    /**
     * @stability stable
     */
    resetMaxEventsPerBatch(): void;
    /**
     * @stability stable
     */
    get maxEventsPerBatchInput(): number | undefined;
    private _preferredBatchSizeInKilobytes?;
    /**
     * @stability stable
     */
    get preferredBatchSizeInKilobytes(): number;
    /**
     * @stability stable
     */
    set preferredBatchSizeInKilobytes(value: number);
    /**
     * @stability stable
     */
    resetPreferredBatchSizeInKilobytes(): void;
    /**
     * @stability stable
     */
    get preferredBatchSizeInKilobytesInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionDeadLetterIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#type EventgridEventSubscription#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#user_assigned_identity EventgridEventSubscription#user_assigned_identity}.
     *
     * @stability stable
     */
    readonly userAssignedIdentity?: string;
}
export declare function eventgridEventSubscriptionDeadLetterIdentityToTerraform(struct?: EventgridEventSubscriptionDeadLetterIdentityOutputReference | EventgridEventSubscriptionDeadLetterIdentity): any;
/**
 * @stability stable
 */
export declare class EventgridEventSubscriptionDeadLetterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridEventSubscriptionDeadLetterIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridEventSubscriptionDeadLetterIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userAssignedIdentity?;
    /**
     * @stability stable
     */
    get userAssignedIdentity(): string;
    /**
     * @stability stable
     */
    set userAssignedIdentity(value: string);
    /**
     * @stability stable
     */
    resetUserAssignedIdentity(): void;
    /**
     * @stability stable
     */
    get userAssignedIdentityInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionDeliveryIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#type EventgridEventSubscription#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#user_assigned_identity EventgridEventSubscription#user_assigned_identity}.
     *
     * @stability stable
     */
    readonly userAssignedIdentity?: string;
}
export declare function eventgridEventSubscriptionDeliveryIdentityToTerraform(struct?: EventgridEventSubscriptionDeliveryIdentityOutputReference | EventgridEventSubscriptionDeliveryIdentity): any;
/**
 * @stability stable
 */
export declare class EventgridEventSubscriptionDeliveryIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridEventSubscriptionDeliveryIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridEventSubscriptionDeliveryIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userAssignedIdentity?;
    /**
     * @stability stable
     */
    get userAssignedIdentity(): string;
    /**
     * @stability stable
     */
    set userAssignedIdentity(value: string);
    /**
     * @stability stable
     */
    resetUserAssignedIdentity(): void;
    /**
     * @stability stable
     */
    get userAssignedIdentityInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionDeliveryProperty {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#header_name EventgridEventSubscription#header_name}.
     *
     * @stability stable
     */
    readonly headerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#secret EventgridEventSubscription#secret}.
     *
     * @stability stable
     */
    readonly secret?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#source_field EventgridEventSubscription#source_field}.
     *
     * @stability stable
     */
    readonly sourceField?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#type EventgridEventSubscription#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#value EventgridEventSubscription#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function eventgridEventSubscriptionDeliveryPropertyToTerraform(struct?: EventgridEventSubscriptionDeliveryProperty): any;
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionEventhubEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#eventhub_id EventgridEventSubscription#eventhub_id}.
     *
     * @stability stable
     */
    readonly eventhubId?: string;
}
export declare function eventgridEventSubscriptionEventhubEndpointToTerraform(struct?: EventgridEventSubscriptionEventhubEndpointOutputReference | EventgridEventSubscriptionEventhubEndpoint): any;
/**
 * @stability stable
 */
export declare class EventgridEventSubscriptionEventhubEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridEventSubscriptionEventhubEndpoint | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridEventSubscriptionEventhubEndpoint | undefined);
    private _eventhubId?;
    /**
     * @stability stable
     */
    get eventhubId(): string;
    /**
     * @stability stable
     */
    set eventhubId(value: string);
    /**
     * @stability stable
     */
    resetEventhubId(): void;
    /**
     * @stability stable
     */
    get eventhubIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionHybridConnectionEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#hybrid_connection_id EventgridEventSubscription#hybrid_connection_id}.
     *
     * @stability stable
     */
    readonly hybridConnectionId?: string;
}
export declare function eventgridEventSubscriptionHybridConnectionEndpointToTerraform(struct?: EventgridEventSubscriptionHybridConnectionEndpointOutputReference | EventgridEventSubscriptionHybridConnectionEndpoint): any;
/**
 * @stability stable
 */
export declare class EventgridEventSubscriptionHybridConnectionEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridEventSubscriptionHybridConnectionEndpoint | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridEventSubscriptionHybridConnectionEndpoint | undefined);
    private _hybridConnectionId?;
    /**
     * @stability stable
     */
    get hybridConnectionId(): string;
    /**
     * @stability stable
     */
    set hybridConnectionId(value: string);
    /**
     * @stability stable
     */
    resetHybridConnectionId(): void;
    /**
     * @stability stable
     */
    get hybridConnectionIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionRetryPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#event_time_to_live EventgridEventSubscription#event_time_to_live}.
     *
     * @stability stable
     */
    readonly eventTimeToLive: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#max_delivery_attempts EventgridEventSubscription#max_delivery_attempts}.
     *
     * @stability stable
     */
    readonly maxDeliveryAttempts: number;
}
export declare function eventgridEventSubscriptionRetryPolicyToTerraform(struct?: EventgridEventSubscriptionRetryPolicyOutputReference | EventgridEventSubscriptionRetryPolicy): any;
/**
 * @stability stable
 */
export declare class EventgridEventSubscriptionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridEventSubscriptionRetryPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridEventSubscriptionRetryPolicy | undefined);
    private _eventTimeToLive?;
    /**
     * @stability stable
     */
    get eventTimeToLive(): number;
    /**
     * @stability stable
     */
    set eventTimeToLive(value: number);
    /**
     * @stability stable
     */
    get eventTimeToLiveInput(): number | undefined;
    private _maxDeliveryAttempts?;
    /**
     * @stability stable
     */
    get maxDeliveryAttempts(): number;
    /**
     * @stability stable
     */
    set maxDeliveryAttempts(value: number);
    /**
     * @stability stable
     */
    get maxDeliveryAttemptsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionStorageBlobDeadLetterDestination {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#storage_account_id EventgridEventSubscription#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#storage_blob_container_name EventgridEventSubscription#storage_blob_container_name}.
     *
     * @stability stable
     */
    readonly storageBlobContainerName: string;
}
export declare function eventgridEventSubscriptionStorageBlobDeadLetterDestinationToTerraform(struct?: EventgridEventSubscriptionStorageBlobDeadLetterDestinationOutputReference | EventgridEventSubscriptionStorageBlobDeadLetterDestination): any;
/**
 * @stability stable
 */
export declare class EventgridEventSubscriptionStorageBlobDeadLetterDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridEventSubscriptionStorageBlobDeadLetterDestination | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridEventSubscriptionStorageBlobDeadLetterDestination | undefined);
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _storageBlobContainerName?;
    /**
     * @stability stable
     */
    get storageBlobContainerName(): string;
    /**
     * @stability stable
     */
    set storageBlobContainerName(value: string);
    /**
     * @stability stable
     */
    get storageBlobContainerNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionStorageQueueEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#queue_message_time_to_live_in_seconds EventgridEventSubscription#queue_message_time_to_live_in_seconds}.
     *
     * @stability stable
     */
    readonly queueMessageTimeToLiveInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#queue_name EventgridEventSubscription#queue_name}.
     *
     * @stability stable
     */
    readonly queueName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#storage_account_id EventgridEventSubscription#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
}
export declare function eventgridEventSubscriptionStorageQueueEndpointToTerraform(struct?: EventgridEventSubscriptionStorageQueueEndpointOutputReference | EventgridEventSubscriptionStorageQueueEndpoint): any;
/**
 * @stability stable
 */
export declare class EventgridEventSubscriptionStorageQueueEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridEventSubscriptionStorageQueueEndpoint | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridEventSubscriptionStorageQueueEndpoint | undefined);
    private _queueMessageTimeToLiveInSeconds?;
    /**
     * @stability stable
     */
    get queueMessageTimeToLiveInSeconds(): number;
    /**
     * @stability stable
     */
    set queueMessageTimeToLiveInSeconds(value: number);
    /**
     * @stability stable
     */
    resetQueueMessageTimeToLiveInSeconds(): void;
    /**
     * @stability stable
     */
    get queueMessageTimeToLiveInSecondsInput(): number | undefined;
    private _queueName?;
    /**
     * @stability stable
     */
    get queueName(): string;
    /**
     * @stability stable
     */
    set queueName(value: string);
    /**
     * @stability stable
     */
    get queueNameInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionSubjectFilter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#case_sensitive EventgridEventSubscription#case_sensitive}.
     *
     * @stability stable
     */
    readonly caseSensitive?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#subject_begins_with EventgridEventSubscription#subject_begins_with}.
     *
     * @stability stable
     */
    readonly subjectBeginsWith?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#subject_ends_with EventgridEventSubscription#subject_ends_with}.
     *
     * @stability stable
     */
    readonly subjectEndsWith?: string;
}
export declare function eventgridEventSubscriptionSubjectFilterToTerraform(struct?: EventgridEventSubscriptionSubjectFilterOutputReference | EventgridEventSubscriptionSubjectFilter): any;
/**
 * @stability stable
 */
export declare class EventgridEventSubscriptionSubjectFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridEventSubscriptionSubjectFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridEventSubscriptionSubjectFilter | undefined);
    private _caseSensitive?;
    /**
     * @stability stable
     */
    get caseSensitive(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set caseSensitive(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCaseSensitive(): void;
    /**
     * @stability stable
     */
    get caseSensitiveInput(): boolean | cdktf.IResolvable | undefined;
    private _subjectBeginsWith?;
    /**
     * @stability stable
     */
    get subjectBeginsWith(): string;
    /**
     * @stability stable
     */
    set subjectBeginsWith(value: string);
    /**
     * @stability stable
     */
    resetSubjectBeginsWith(): void;
    /**
     * @stability stable
     */
    get subjectBeginsWithInput(): string | undefined;
    private _subjectEndsWith?;
    /**
     * @stability stable
     */
    get subjectEndsWith(): string;
    /**
     * @stability stable
     */
    set subjectEndsWith(value: string);
    /**
     * @stability stable
     */
    resetSubjectEndsWith(): void;
    /**
     * @stability stable
     */
    get subjectEndsWithInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#create EventgridEventSubscription#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#delete EventgridEventSubscription#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#read EventgridEventSubscription#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#update EventgridEventSubscription#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function eventgridEventSubscriptionTimeoutsToTerraform(struct?: EventgridEventSubscriptionTimeoutsOutputReference | EventgridEventSubscriptionTimeouts): any;
/**
 * @stability stable
 */
export declare class EventgridEventSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridEventSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridEventSubscriptionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridEventSubscriptionWebhookEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#active_directory_app_id_or_uri EventgridEventSubscription#active_directory_app_id_or_uri}.
     *
     * @stability stable
     */
    readonly activeDirectoryAppIdOrUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#active_directory_tenant_id EventgridEventSubscription#active_directory_tenant_id}.
     *
     * @stability stable
     */
    readonly activeDirectoryTenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#max_events_per_batch EventgridEventSubscription#max_events_per_batch}.
     *
     * @stability stable
     */
    readonly maxEventsPerBatch?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#preferred_batch_size_in_kilobytes EventgridEventSubscription#preferred_batch_size_in_kilobytes}.
     *
     * @stability stable
     */
    readonly preferredBatchSizeInKilobytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription#url EventgridEventSubscription#url}.
     *
     * @stability stable
     */
    readonly url: string;
}
export declare function eventgridEventSubscriptionWebhookEndpointToTerraform(struct?: EventgridEventSubscriptionWebhookEndpointOutputReference | EventgridEventSubscriptionWebhookEndpoint): any;
/**
 * @stability stable
 */
export declare class EventgridEventSubscriptionWebhookEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridEventSubscriptionWebhookEndpoint | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridEventSubscriptionWebhookEndpoint | undefined);
    private _activeDirectoryAppIdOrUri?;
    /**
     * @stability stable
     */
    get activeDirectoryAppIdOrUri(): string;
    /**
     * @stability stable
     */
    set activeDirectoryAppIdOrUri(value: string);
    /**
     * @stability stable
     */
    resetActiveDirectoryAppIdOrUri(): void;
    /**
     * @stability stable
     */
    get activeDirectoryAppIdOrUriInput(): string | undefined;
    private _activeDirectoryTenantId?;
    /**
     * @stability stable
     */
    get activeDirectoryTenantId(): string;
    /**
     * @stability stable
     */
    set activeDirectoryTenantId(value: string);
    /**
     * @stability stable
     */
    resetActiveDirectoryTenantId(): void;
    /**
     * @stability stable
     */
    get activeDirectoryTenantIdInput(): string | undefined;
    private _maxEventsPerBatch?;
    /**
     * @stability stable
     */
    get maxEventsPerBatch(): number;
    /**
     * @stability stable
     */
    set maxEventsPerBatch(value: number);
    /**
     * @stability stable
     */
    resetMaxEventsPerBatch(): void;
    /**
     * @stability stable
     */
    get maxEventsPerBatchInput(): number | undefined;
    private _preferredBatchSizeInKilobytes?;
    /**
     * @stability stable
     */
    get preferredBatchSizeInKilobytes(): number;
    /**
     * @stability stable
     */
    set preferredBatchSizeInKilobytes(value: number);
    /**
     * @stability stable
     */
    resetPreferredBatchSizeInKilobytes(): void;
    /**
     * @stability stable
     */
    get preferredBatchSizeInKilobytesInput(): number | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription azurerm_eventgrid_event_subscription}.
 *
 * @stability stable
 */
export declare class EventgridEventSubscription extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_event_subscription azurerm_eventgrid_event_subscription} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EventgridEventSubscriptionConfig);
    private _advancedFilteringOnArraysEnabled?;
    /**
     * @stability stable
     */
    get advancedFilteringOnArraysEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set advancedFilteringOnArraysEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdvancedFilteringOnArraysEnabled(): void;
    /**
     * @stability stable
     */
    get advancedFilteringOnArraysEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _eventDeliverySchema?;
    /**
     * @stability stable
     */
    get eventDeliverySchema(): string;
    /**
     * @stability stable
     */
    set eventDeliverySchema(value: string);
    /**
     * @stability stable
     */
    resetEventDeliverySchema(): void;
    /**
     * @stability stable
     */
    get eventDeliverySchemaInput(): string | undefined;
    private _eventhubEndpointId?;
    /**
     * @stability stable
     */
    get eventhubEndpointId(): string;
    /**
     * @stability stable
     */
    set eventhubEndpointId(value: string);
    /**
     * @stability stable
     */
    resetEventhubEndpointId(): void;
    /**
     * @stability stable
     */
    get eventhubEndpointIdInput(): string | undefined;
    private _expirationTimeUtc?;
    /**
     * @stability stable
     */
    get expirationTimeUtc(): string;
    /**
     * @stability stable
     */
    set expirationTimeUtc(value: string);
    /**
     * @stability stable
     */
    resetExpirationTimeUtc(): void;
    /**
     * @stability stable
     */
    get expirationTimeUtcInput(): string | undefined;
    private _hybridConnectionEndpointId?;
    /**
     * @stability stable
     */
    get hybridConnectionEndpointId(): string;
    /**
     * @stability stable
     */
    set hybridConnectionEndpointId(value: string);
    /**
     * @stability stable
     */
    resetHybridConnectionEndpointId(): void;
    /**
     * @stability stable
     */
    get hybridConnectionEndpointIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _includedEventTypes?;
    /**
     * @stability stable
     */
    get includedEventTypes(): string[];
    /**
     * @stability stable
     */
    set includedEventTypes(value: string[]);
    /**
     * @stability stable
     */
    resetIncludedEventTypes(): void;
    /**
     * @stability stable
     */
    get includedEventTypesInput(): string[] | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): string[];
    /**
     * @stability stable
     */
    set labels(value: string[]);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
    private _serviceBusQueueEndpointId?;
    /**
     * @stability stable
     */
    get serviceBusQueueEndpointId(): string;
    /**
     * @stability stable
     */
    set serviceBusQueueEndpointId(value: string);
    /**
     * @stability stable
     */
    resetServiceBusQueueEndpointId(): void;
    /**
     * @stability stable
     */
    get serviceBusQueueEndpointIdInput(): string | undefined;
    private _serviceBusTopicEndpointId?;
    /**
     * @stability stable
     */
    get serviceBusTopicEndpointId(): string;
    /**
     * @stability stable
     */
    set serviceBusTopicEndpointId(value: string);
    /**
     * @stability stable
     */
    resetServiceBusTopicEndpointId(): void;
    /**
     * @stability stable
     */
    get serviceBusTopicEndpointIdInput(): string | undefined;
    private _topicName?;
    /**
     * @stability stable
     */
    get topicName(): string;
    /**
     * @stability stable
     */
    set topicName(value: string);
    /**
     * @stability stable
     */
    resetTopicName(): void;
    /**
     * @stability stable
     */
    get topicNameInput(): string | undefined;
    private _advancedFilter;
    /**
     * @stability stable
     */
    get advancedFilter(): EventgridEventSubscriptionAdvancedFilterOutputReference;
    /**
     * @stability stable
     */
    putAdvancedFilter(value: EventgridEventSubscriptionAdvancedFilter): void;
    /**
     * @stability stable
     */
    resetAdvancedFilter(): void;
    /**
     * @stability stable
     */
    get advancedFilterInput(): EventgridEventSubscriptionAdvancedFilter | undefined;
    private _azureFunctionEndpoint;
    /**
     * @stability stable
     */
    get azureFunctionEndpoint(): EventgridEventSubscriptionAzureFunctionEndpointOutputReference;
    /**
     * @stability stable
     */
    putAzureFunctionEndpoint(value: EventgridEventSubscriptionAzureFunctionEndpoint): void;
    /**
     * @stability stable
     */
    resetAzureFunctionEndpoint(): void;
    /**
     * @stability stable
     */
    get azureFunctionEndpointInput(): EventgridEventSubscriptionAzureFunctionEndpoint | undefined;
    private _deadLetterIdentity;
    /**
     * @stability stable
     */
    get deadLetterIdentity(): EventgridEventSubscriptionDeadLetterIdentityOutputReference;
    /**
     * @stability stable
     */
    putDeadLetterIdentity(value: EventgridEventSubscriptionDeadLetterIdentity): void;
    /**
     * @stability stable
     */
    resetDeadLetterIdentity(): void;
    /**
     * @stability stable
     */
    get deadLetterIdentityInput(): EventgridEventSubscriptionDeadLetterIdentity | undefined;
    private _deliveryIdentity;
    /**
     * @stability stable
     */
    get deliveryIdentity(): EventgridEventSubscriptionDeliveryIdentityOutputReference;
    /**
     * @stability stable
     */
    putDeliveryIdentity(value: EventgridEventSubscriptionDeliveryIdentity): void;
    /**
     * @stability stable
     */
    resetDeliveryIdentity(): void;
    /**
     * @stability stable
     */
    get deliveryIdentityInput(): EventgridEventSubscriptionDeliveryIdentity | undefined;
    private _deliveryProperty?;
    /**
     * @stability stable
     */
    get deliveryProperty(): EventgridEventSubscriptionDeliveryProperty[];
    /**
     * @stability stable
     */
    set deliveryProperty(value: EventgridEventSubscriptionDeliveryProperty[]);
    /**
     * @stability stable
     */
    resetDeliveryProperty(): void;
    /**
     * @stability stable
     */
    get deliveryPropertyInput(): EventgridEventSubscriptionDeliveryProperty[] | undefined;
    private _eventhubEndpoint;
    /**
     * @stability stable
     */
    get eventhubEndpoint(): EventgridEventSubscriptionEventhubEndpointOutputReference;
    /**
     * @stability stable
     */
    putEventhubEndpoint(value: EventgridEventSubscriptionEventhubEndpoint): void;
    /**
     * @stability stable
     */
    resetEventhubEndpoint(): void;
    /**
     * @stability stable
     */
    get eventhubEndpointInput(): EventgridEventSubscriptionEventhubEndpoint | undefined;
    private _hybridConnectionEndpoint;
    /**
     * @stability stable
     */
    get hybridConnectionEndpoint(): EventgridEventSubscriptionHybridConnectionEndpointOutputReference;
    /**
     * @stability stable
     */
    putHybridConnectionEndpoint(value: EventgridEventSubscriptionHybridConnectionEndpoint): void;
    /**
     * @stability stable
     */
    resetHybridConnectionEndpoint(): void;
    /**
     * @stability stable
     */
    get hybridConnectionEndpointInput(): EventgridEventSubscriptionHybridConnectionEndpoint | undefined;
    private _retryPolicy;
    /**
     * @stability stable
     */
    get retryPolicy(): EventgridEventSubscriptionRetryPolicyOutputReference;
    /**
     * @stability stable
     */
    putRetryPolicy(value: EventgridEventSubscriptionRetryPolicy): void;
    /**
     * @stability stable
     */
    resetRetryPolicy(): void;
    /**
     * @stability stable
     */
    get retryPolicyInput(): EventgridEventSubscriptionRetryPolicy | undefined;
    private _storageBlobDeadLetterDestination;
    /**
     * @stability stable
     */
    get storageBlobDeadLetterDestination(): EventgridEventSubscriptionStorageBlobDeadLetterDestinationOutputReference;
    /**
     * @stability stable
     */
    putStorageBlobDeadLetterDestination(value: EventgridEventSubscriptionStorageBlobDeadLetterDestination): void;
    /**
     * @stability stable
     */
    resetStorageBlobDeadLetterDestination(): void;
    /**
     * @stability stable
     */
    get storageBlobDeadLetterDestinationInput(): EventgridEventSubscriptionStorageBlobDeadLetterDestination | undefined;
    private _storageQueueEndpoint;
    /**
     * @stability stable
     */
    get storageQueueEndpoint(): EventgridEventSubscriptionStorageQueueEndpointOutputReference;
    /**
     * @stability stable
     */
    putStorageQueueEndpoint(value: EventgridEventSubscriptionStorageQueueEndpoint): void;
    /**
     * @stability stable
     */
    resetStorageQueueEndpoint(): void;
    /**
     * @stability stable
     */
    get storageQueueEndpointInput(): EventgridEventSubscriptionStorageQueueEndpoint | undefined;
    private _subjectFilter;
    /**
     * @stability stable
     */
    get subjectFilter(): EventgridEventSubscriptionSubjectFilterOutputReference;
    /**
     * @stability stable
     */
    putSubjectFilter(value: EventgridEventSubscriptionSubjectFilter): void;
    /**
     * @stability stable
     */
    resetSubjectFilter(): void;
    /**
     * @stability stable
     */
    get subjectFilterInput(): EventgridEventSubscriptionSubjectFilter | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): EventgridEventSubscriptionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: EventgridEventSubscriptionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EventgridEventSubscriptionTimeouts | undefined;
    private _webhookEndpoint;
    /**
     * @stability stable
     */
    get webhookEndpoint(): EventgridEventSubscriptionWebhookEndpointOutputReference;
    /**
     * @stability stable
     */
    putWebhookEndpoint(value: EventgridEventSubscriptionWebhookEndpoint): void;
    /**
     * @stability stable
     */
    resetWebhookEndpoint(): void;
    /**
     * @stability stable
     */
    get webhookEndpointInput(): EventgridEventSubscriptionWebhookEndpoint | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
