import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EventgridTopicConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#inbound_ip_rule EventgridTopic#inbound_ip_rule}.
     *
     * @stability stable
     */
    readonly inboundIpRule?: EventgridTopicInboundIpRule[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#input_schema EventgridTopic#input_schema}.
     *
     * @stability stable
     */
    readonly inputSchema?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#local_auth_enabled EventgridTopic#local_auth_enabled}.
     *
     * @stability stable
     */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#location EventgridTopic#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#name EventgridTopic#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#public_network_access_enabled EventgridTopic#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#resource_group_name EventgridTopic#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#tags EventgridTopic#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#identity EventgridTopic#identity}
     *
     * @stability stable
     */
    readonly identity?: EventgridTopicIdentity;
    /**
     * input_mapping_default_values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#input_mapping_default_values EventgridTopic#input_mapping_default_values}
     *
     * @stability stable
     */
    readonly inputMappingDefaultValues?: EventgridTopicInputMappingDefaultValues;
    /**
     * input_mapping_fields block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#input_mapping_fields EventgridTopic#input_mapping_fields}
     *
     * @stability stable
     */
    readonly inputMappingFields?: EventgridTopicInputMappingFields;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#timeouts EventgridTopic#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EventgridTopicTimeouts;
}
/**
 * @stability stable
 */
export interface EventgridTopicInboundIpRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#action EventgridTopic#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#ip_mask EventgridTopic#ip_mask}.
     *
     * @stability stable
     */
    readonly ipMask?: string;
}
export declare function eventgridTopicInboundIpRuleToTerraform(struct?: EventgridTopicInboundIpRule): any;
/**
 * @stability stable
 */
export interface EventgridTopicIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#identity_ids EventgridTopic#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#type EventgridTopic#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function eventgridTopicIdentityToTerraform(struct?: EventgridTopicIdentityOutputReference | EventgridTopicIdentity): any;
/**
 * @stability stable
 */
export declare class EventgridTopicIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridTopicIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridTopicIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridTopicInputMappingDefaultValues {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#data_version EventgridTopic#data_version}.
     *
     * @stability stable
     */
    readonly dataVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#event_type EventgridTopic#event_type}.
     *
     * @stability stable
     */
    readonly eventType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#subject EventgridTopic#subject}.
     *
     * @stability stable
     */
    readonly subject?: string;
}
export declare function eventgridTopicInputMappingDefaultValuesToTerraform(struct?: EventgridTopicInputMappingDefaultValuesOutputReference | EventgridTopicInputMappingDefaultValues): any;
/**
 * @stability stable
 */
export declare class EventgridTopicInputMappingDefaultValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridTopicInputMappingDefaultValues | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridTopicInputMappingDefaultValues | undefined);
    private _dataVersion?;
    /**
     * @stability stable
     */
    get dataVersion(): string;
    /**
     * @stability stable
     */
    set dataVersion(value: string);
    /**
     * @stability stable
     */
    resetDataVersion(): void;
    /**
     * @stability stable
     */
    get dataVersionInput(): string | undefined;
    private _eventType?;
    /**
     * @stability stable
     */
    get eventType(): string;
    /**
     * @stability stable
     */
    set eventType(value: string);
    /**
     * @stability stable
     */
    resetEventType(): void;
    /**
     * @stability stable
     */
    get eventTypeInput(): string | undefined;
    private _subject?;
    /**
     * @stability stable
     */
    get subject(): string;
    /**
     * @stability stable
     */
    set subject(value: string);
    /**
     * @stability stable
     */
    resetSubject(): void;
    /**
     * @stability stable
     */
    get subjectInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridTopicInputMappingFields {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#data_version EventgridTopic#data_version}.
     *
     * @stability stable
     */
    readonly dataVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#event_time EventgridTopic#event_time}.
     *
     * @stability stable
     */
    readonly eventTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#event_type EventgridTopic#event_type}.
     *
     * @stability stable
     */
    readonly eventType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#id EventgridTopic#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#subject EventgridTopic#subject}.
     *
     * @stability stable
     */
    readonly subject?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#topic EventgridTopic#topic}.
     *
     * @stability stable
     */
    readonly topic?: string;
}
export declare function eventgridTopicInputMappingFieldsToTerraform(struct?: EventgridTopicInputMappingFieldsOutputReference | EventgridTopicInputMappingFields): any;
/**
 * @stability stable
 */
export declare class EventgridTopicInputMappingFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridTopicInputMappingFields | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridTopicInputMappingFields | undefined);
    private _dataVersion?;
    /**
     * @stability stable
     */
    get dataVersion(): string;
    /**
     * @stability stable
     */
    set dataVersion(value: string);
    /**
     * @stability stable
     */
    resetDataVersion(): void;
    /**
     * @stability stable
     */
    get dataVersionInput(): string | undefined;
    private _eventTime?;
    /**
     * @stability stable
     */
    get eventTime(): string;
    /**
     * @stability stable
     */
    set eventTime(value: string);
    /**
     * @stability stable
     */
    resetEventTime(): void;
    /**
     * @stability stable
     */
    get eventTimeInput(): string | undefined;
    private _eventType?;
    /**
     * @stability stable
     */
    get eventType(): string;
    /**
     * @stability stable
     */
    set eventType(value: string);
    /**
     * @stability stable
     */
    resetEventType(): void;
    /**
     * @stability stable
     */
    get eventTypeInput(): string | undefined;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _subject?;
    /**
     * @stability stable
     */
    get subject(): string;
    /**
     * @stability stable
     */
    set subject(value: string);
    /**
     * @stability stable
     */
    resetSubject(): void;
    /**
     * @stability stable
     */
    get subjectInput(): string | undefined;
    private _topic?;
    /**
     * @stability stable
     */
    get topic(): string;
    /**
     * @stability stable
     */
    set topic(value: string);
    /**
     * @stability stable
     */
    resetTopic(): void;
    /**
     * @stability stable
     */
    get topicInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridTopicTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#create EventgridTopic#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#delete EventgridTopic#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#read EventgridTopic#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic#update EventgridTopic#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function eventgridTopicTimeoutsToTerraform(struct?: EventgridTopicTimeoutsOutputReference | EventgridTopicTimeouts): any;
/**
 * @stability stable
 */
export declare class EventgridTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridTopicTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic azurerm_eventgrid_topic}.
 *
 * @stability stable
 */
export declare class EventgridTopic extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_topic azurerm_eventgrid_topic} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EventgridTopicConfig);
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _inboundIpRule?;
    /**
     * @stability stable
     */
    get inboundIpRule(): EventgridTopicInboundIpRule[];
    /**
     * @stability stable
     */
    set inboundIpRule(value: EventgridTopicInboundIpRule[]);
    /**
     * @stability stable
     */
    resetInboundIpRule(): void;
    /**
     * @stability stable
     */
    get inboundIpRuleInput(): EventgridTopicInboundIpRule[] | undefined;
    private _inputSchema?;
    /**
     * @stability stable
     */
    get inputSchema(): string;
    /**
     * @stability stable
     */
    set inputSchema(value: string);
    /**
     * @stability stable
     */
    resetInputSchema(): void;
    /**
     * @stability stable
     */
    get inputSchemaInput(): string | undefined;
    private _localAuthEnabled?;
    /**
     * @stability stable
     */
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocalAuthEnabled(): void;
    /**
     * @stability stable
     */
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryAccessKey(): string;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAccessKey(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): EventgridTopicIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: EventgridTopicIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): EventgridTopicIdentity | undefined;
    private _inputMappingDefaultValues;
    /**
     * @stability stable
     */
    get inputMappingDefaultValues(): EventgridTopicInputMappingDefaultValuesOutputReference;
    /**
     * @stability stable
     */
    putInputMappingDefaultValues(value: EventgridTopicInputMappingDefaultValues): void;
    /**
     * @stability stable
     */
    resetInputMappingDefaultValues(): void;
    /**
     * @stability stable
     */
    get inputMappingDefaultValuesInput(): EventgridTopicInputMappingDefaultValues | undefined;
    private _inputMappingFields;
    /**
     * @stability stable
     */
    get inputMappingFields(): EventgridTopicInputMappingFieldsOutputReference;
    /**
     * @stability stable
     */
    putInputMappingFields(value: EventgridTopicInputMappingFields): void;
    /**
     * @stability stable
     */
    resetInputMappingFields(): void;
    /**
     * @stability stable
     */
    get inputMappingFieldsInput(): EventgridTopicInputMappingFields | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): EventgridTopicTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: EventgridTopicTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EventgridTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
