import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ExpressRouteCircuitConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#allow_classic_operations ExpressRouteCircuit#allow_classic_operations}.
     *
     * @stability stable
     */
    readonly allowClassicOperations?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#bandwidth_in_gbps ExpressRouteCircuit#bandwidth_in_gbps}.
     *
     * @stability stable
     */
    readonly bandwidthInGbps?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#bandwidth_in_mbps ExpressRouteCircuit#bandwidth_in_mbps}.
     *
     * @stability stable
     */
    readonly bandwidthInMbps?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#express_route_port_id ExpressRouteCircuit#express_route_port_id}.
     *
     * @stability stable
     */
    readonly expressRoutePortId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#location ExpressRouteCircuit#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#name ExpressRouteCircuit#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#peering_location ExpressRouteCircuit#peering_location}.
     *
     * @stability stable
     */
    readonly peeringLocation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#resource_group_name ExpressRouteCircuit#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#service_provider_name ExpressRouteCircuit#service_provider_name}.
     *
     * @stability stable
     */
    readonly serviceProviderName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#tags ExpressRouteCircuit#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * sku block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#sku ExpressRouteCircuit#sku}
     *
     * @stability stable
     */
    readonly sku: ExpressRouteCircuitSku;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#timeouts ExpressRouteCircuit#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ExpressRouteCircuitTimeouts;
}
/**
 * @stability stable
 */
export interface ExpressRouteCircuitSku {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#family ExpressRouteCircuit#family}.
     *
     * @stability stable
     */
    readonly family: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#tier ExpressRouteCircuit#tier}.
     *
     * @stability stable
     */
    readonly tier: string;
}
export declare function expressRouteCircuitSkuToTerraform(struct?: ExpressRouteCircuitSkuOutputReference | ExpressRouteCircuitSku): any;
/**
 * @stability stable
 */
export declare class ExpressRouteCircuitSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRouteCircuitSku | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRouteCircuitSku | undefined);
    private _family?;
    /**
     * @stability stable
     */
    get family(): string;
    /**
     * @stability stable
     */
    set family(value: string);
    /**
     * @stability stable
     */
    get familyInput(): string | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ExpressRouteCircuitTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#create ExpressRouteCircuit#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#delete ExpressRouteCircuit#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#read ExpressRouteCircuit#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit#update ExpressRouteCircuit#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function expressRouteCircuitTimeoutsToTerraform(struct?: ExpressRouteCircuitTimeoutsOutputReference | ExpressRouteCircuitTimeouts): any;
/**
 * @stability stable
 */
export declare class ExpressRouteCircuitTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRouteCircuitTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRouteCircuitTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit azurerm_express_route_circuit}.
 *
 * @stability stable
 */
export declare class ExpressRouteCircuit extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit azurerm_express_route_circuit} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ExpressRouteCircuitConfig);
    private _allowClassicOperations?;
    /**
     * @stability stable
     */
    get allowClassicOperations(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowClassicOperations(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowClassicOperations(): void;
    /**
     * @stability stable
     */
    get allowClassicOperationsInput(): boolean | cdktf.IResolvable | undefined;
    private _bandwidthInGbps?;
    /**
     * @stability stable
     */
    get bandwidthInGbps(): number;
    /**
     * @stability stable
     */
    set bandwidthInGbps(value: number);
    /**
     * @stability stable
     */
    resetBandwidthInGbps(): void;
    /**
     * @stability stable
     */
    get bandwidthInGbpsInput(): number | undefined;
    private _bandwidthInMbps?;
    /**
     * @stability stable
     */
    get bandwidthInMbps(): number;
    /**
     * @stability stable
     */
    set bandwidthInMbps(value: number);
    /**
     * @stability stable
     */
    resetBandwidthInMbps(): void;
    /**
     * @stability stable
     */
    get bandwidthInMbpsInput(): number | undefined;
    private _expressRoutePortId?;
    /**
     * @stability stable
     */
    get expressRoutePortId(): string;
    /**
     * @stability stable
     */
    set expressRoutePortId(value: string);
    /**
     * @stability stable
     */
    resetExpressRoutePortId(): void;
    /**
     * @stability stable
     */
    get expressRoutePortIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _peeringLocation?;
    /**
     * @stability stable
     */
    get peeringLocation(): string;
    /**
     * @stability stable
     */
    set peeringLocation(value: string);
    /**
     * @stability stable
     */
    resetPeeringLocation(): void;
    /**
     * @stability stable
     */
    get peeringLocationInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceKey(): string;
    private _serviceProviderName?;
    /**
     * @stability stable
     */
    get serviceProviderName(): string;
    /**
     * @stability stable
     */
    set serviceProviderName(value: string);
    /**
     * @stability stable
     */
    resetServiceProviderName(): void;
    /**
     * @stability stable
     */
    get serviceProviderNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceProviderProvisioningState(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _sku;
    /**
     * @stability stable
     */
    get sku(): ExpressRouteCircuitSkuOutputReference;
    /**
     * @stability stable
     */
    putSku(value: ExpressRouteCircuitSku): void;
    /**
     * @stability stable
     */
    get skuInput(): ExpressRouteCircuitSku | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ExpressRouteCircuitTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ExpressRouteCircuitTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ExpressRouteCircuitTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
