import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ExpressRoutePortConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#bandwidth_in_gbps ExpressRoutePort#bandwidth_in_gbps}.
     *
     * @stability stable
     */
    readonly bandwidthInGbps: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#encapsulation ExpressRoutePort#encapsulation}.
     *
     * @stability stable
     */
    readonly encapsulation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#location ExpressRoutePort#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#name ExpressRoutePort#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#peering_location ExpressRoutePort#peering_location}.
     *
     * @stability stable
     */
    readonly peeringLocation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#resource_group_name ExpressRoutePort#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#tags ExpressRoutePort#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#identity ExpressRoutePort#identity}
     *
     * @stability stable
     */
    readonly identity?: ExpressRoutePortIdentity;
    /**
     * link1 block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#link1 ExpressRoutePort#link1}
     *
     * @stability stable
     */
    readonly link1?: ExpressRoutePortLink1;
    /**
     * link2 block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#link2 ExpressRoutePort#link2}
     *
     * @stability stable
     */
    readonly link2?: ExpressRoutePortLink2;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#timeouts ExpressRoutePort#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ExpressRoutePortTimeouts;
}
/**
 * @stability stable
 */
export interface ExpressRoutePortIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#identity_ids ExpressRoutePort#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#type ExpressRoutePort#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function expressRoutePortIdentityToTerraform(struct?: ExpressRoutePortIdentityOutputReference | ExpressRoutePortIdentity): any;
/**
 * @stability stable
 */
export declare class ExpressRoutePortIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRoutePortIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRoutePortIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ExpressRoutePortLink1 {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#admin_enabled ExpressRoutePort#admin_enabled}.
     *
     * @stability stable
     */
    readonly adminEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#macsec_cak_keyvault_secret_id ExpressRoutePort#macsec_cak_keyvault_secret_id}.
     *
     * @stability stable
     */
    readonly macsecCakKeyvaultSecretId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#macsec_cipher ExpressRoutePort#macsec_cipher}.
     *
     * @stability stable
     */
    readonly macsecCipher?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#macsec_ckn_keyvault_secret_id ExpressRoutePort#macsec_ckn_keyvault_secret_id}.
     *
     * @stability stable
     */
    readonly macsecCknKeyvaultSecretId?: string;
}
export declare function expressRoutePortLink1ToTerraform(struct?: ExpressRoutePortLink1OutputReference | ExpressRoutePortLink1): any;
/**
 * @stability stable
 */
export declare class ExpressRoutePortLink1OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRoutePortLink1 | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRoutePortLink1 | undefined);
    private _adminEnabled?;
    /**
     * @stability stable
     */
    get adminEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set adminEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdminEnabled(): void;
    /**
     * @stability stable
     */
    get adminEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _macsecCakKeyvaultSecretId?;
    /**
     * @stability stable
     */
    get macsecCakKeyvaultSecretId(): string;
    /**
     * @stability stable
     */
    set macsecCakKeyvaultSecretId(value: string);
    /**
     * @stability stable
     */
    resetMacsecCakKeyvaultSecretId(): void;
    /**
     * @stability stable
     */
    get macsecCakKeyvaultSecretIdInput(): string | undefined;
    private _macsecCipher?;
    /**
     * @stability stable
     */
    get macsecCipher(): string;
    /**
     * @stability stable
     */
    set macsecCipher(value: string);
    /**
     * @stability stable
     */
    resetMacsecCipher(): void;
    /**
     * @stability stable
     */
    get macsecCipherInput(): string | undefined;
    private _macsecCknKeyvaultSecretId?;
    /**
     * @stability stable
     */
    get macsecCknKeyvaultSecretId(): string;
    /**
     * @stability stable
     */
    set macsecCknKeyvaultSecretId(value: string);
    /**
     * @stability stable
     */
    resetMacsecCknKeyvaultSecretId(): void;
    /**
     * @stability stable
     */
    get macsecCknKeyvaultSecretIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ExpressRoutePortLink2 {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#admin_enabled ExpressRoutePort#admin_enabled}.
     *
     * @stability stable
     */
    readonly adminEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#macsec_cak_keyvault_secret_id ExpressRoutePort#macsec_cak_keyvault_secret_id}.
     *
     * @stability stable
     */
    readonly macsecCakKeyvaultSecretId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#macsec_cipher ExpressRoutePort#macsec_cipher}.
     *
     * @stability stable
     */
    readonly macsecCipher?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#macsec_ckn_keyvault_secret_id ExpressRoutePort#macsec_ckn_keyvault_secret_id}.
     *
     * @stability stable
     */
    readonly macsecCknKeyvaultSecretId?: string;
}
export declare function expressRoutePortLink2ToTerraform(struct?: ExpressRoutePortLink2OutputReference | ExpressRoutePortLink2): any;
/**
 * @stability stable
 */
export declare class ExpressRoutePortLink2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRoutePortLink2 | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRoutePortLink2 | undefined);
    private _adminEnabled?;
    /**
     * @stability stable
     */
    get adminEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set adminEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdminEnabled(): void;
    /**
     * @stability stable
     */
    get adminEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _macsecCakKeyvaultSecretId?;
    /**
     * @stability stable
     */
    get macsecCakKeyvaultSecretId(): string;
    /**
     * @stability stable
     */
    set macsecCakKeyvaultSecretId(value: string);
    /**
     * @stability stable
     */
    resetMacsecCakKeyvaultSecretId(): void;
    /**
     * @stability stable
     */
    get macsecCakKeyvaultSecretIdInput(): string | undefined;
    private _macsecCipher?;
    /**
     * @stability stable
     */
    get macsecCipher(): string;
    /**
     * @stability stable
     */
    set macsecCipher(value: string);
    /**
     * @stability stable
     */
    resetMacsecCipher(): void;
    /**
     * @stability stable
     */
    get macsecCipherInput(): string | undefined;
    private _macsecCknKeyvaultSecretId?;
    /**
     * @stability stable
     */
    get macsecCknKeyvaultSecretId(): string;
    /**
     * @stability stable
     */
    set macsecCknKeyvaultSecretId(value: string);
    /**
     * @stability stable
     */
    resetMacsecCknKeyvaultSecretId(): void;
    /**
     * @stability stable
     */
    get macsecCknKeyvaultSecretIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ExpressRoutePortTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#create ExpressRoutePort#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#delete ExpressRoutePort#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#read ExpressRoutePort#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port#update ExpressRoutePort#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function expressRoutePortTimeoutsToTerraform(struct?: ExpressRoutePortTimeoutsOutputReference | ExpressRoutePortTimeouts): any;
/**
 * @stability stable
 */
export declare class ExpressRoutePortTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRoutePortTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRoutePortTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port azurerm_express_route_port}.
 *
 * @stability stable
 */
export declare class ExpressRoutePort extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_port azurerm_express_route_port} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ExpressRoutePortConfig);
    private _bandwidthInGbps?;
    /**
     * @stability stable
     */
    get bandwidthInGbps(): number;
    /**
     * @stability stable
     */
    set bandwidthInGbps(value: number);
    /**
     * @stability stable
     */
    get bandwidthInGbpsInput(): number | undefined;
    private _encapsulation?;
    /**
     * @stability stable
     */
    get encapsulation(): string;
    /**
     * @stability stable
     */
    set encapsulation(value: string);
    /**
     * @stability stable
     */
    get encapsulationInput(): string | undefined;
    /**
     * @stability stable
     */
    get ethertype(): string;
    /**
     * @stability stable
     */
    get guid(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get mtu(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _peeringLocation?;
    /**
     * @stability stable
     */
    get peeringLocation(): string;
    /**
     * @stability stable
     */
    set peeringLocation(value: string);
    /**
     * @stability stable
     */
    get peeringLocationInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): ExpressRoutePortIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: ExpressRoutePortIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): ExpressRoutePortIdentity | undefined;
    private _link1;
    /**
     * @stability stable
     */
    get link1(): ExpressRoutePortLink1OutputReference;
    /**
     * @stability stable
     */
    putLink1(value: ExpressRoutePortLink1): void;
    /**
     * @stability stable
     */
    resetLink1(): void;
    /**
     * @stability stable
     */
    get link1Input(): ExpressRoutePortLink1 | undefined;
    private _link2;
    /**
     * @stability stable
     */
    get link2(): ExpressRoutePortLink2OutputReference;
    /**
     * @stability stable
     */
    putLink2(value: ExpressRoutePortLink2): void;
    /**
     * @stability stable
     */
    resetLink2(): void;
    /**
     * @stability stable
     */
    get link2Input(): ExpressRoutePortLink2 | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ExpressRoutePortTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ExpressRoutePortTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ExpressRoutePortTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
