import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FunctionAppConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#app_service_plan_id FunctionApp#app_service_plan_id}.
     *
     * @stability stable
     */
    readonly appServicePlanId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#app_settings FunctionApp#app_settings}.
     *
     * @stability stable
     */
    readonly appSettings?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#client_affinity_enabled FunctionApp#client_affinity_enabled}.
     *
     * @stability stable
     */
    readonly clientAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#client_cert_mode FunctionApp#client_cert_mode}.
     *
     * @stability stable
     */
    readonly clientCertMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#daily_memory_time_quota FunctionApp#daily_memory_time_quota}.
     *
     * @stability stable
     */
    readonly dailyMemoryTimeQuota?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#enable_builtin_logging FunctionApp#enable_builtin_logging}.
     *
     * @stability stable
     */
    readonly enableBuiltinLogging?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#enabled FunctionApp#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#https_only FunctionApp#https_only}.
     *
     * @stability stable
     */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#key_vault_reference_identity_id FunctionApp#key_vault_reference_identity_id}.
     *
     * @stability stable
     */
    readonly keyVaultReferenceIdentityId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#location FunctionApp#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#name FunctionApp#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#os_type FunctionApp#os_type}.
     *
     * @stability stable
     */
    readonly osType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#resource_group_name FunctionApp#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#storage_account_access_key FunctionApp#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#storage_account_name FunctionApp#storage_account_name}.
     *
     * @stability stable
     */
    readonly storageAccountName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#storage_connection_string FunctionApp#storage_connection_string}.
     *
     * @stability stable
     */
    readonly storageConnectionString?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#tags FunctionApp#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#version FunctionApp#version}.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * auth_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#auth_settings FunctionApp#auth_settings}
     *
     * @stability stable
     */
    readonly authSettings?: FunctionAppAuthSettings;
    /**
     * connection_string block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#connection_string FunctionApp#connection_string}
     *
     * @stability stable
     */
    readonly connectionString?: FunctionAppConnectionString[];
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#identity FunctionApp#identity}
     *
     * @stability stable
     */
    readonly identity?: FunctionAppIdentity;
    /**
     * site_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#site_config FunctionApp#site_config}
     *
     * @stability stable
     */
    readonly siteConfig?: FunctionAppSiteConfig;
    /**
     * source_control block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#source_control FunctionApp#source_control}
     *
     * @stability stable
     */
    readonly sourceControl?: FunctionAppSourceControl;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#timeouts FunctionApp#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FunctionAppTimeouts;
}
/**
 * @stability stable
 */
export declare class FunctionAppSiteCredential extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export interface FunctionAppAuthSettingsActiveDirectory {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#allowed_audiences FunctionApp#allowed_audiences}.
     *
     * @stability stable
     */
    readonly allowedAudiences?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#client_id FunctionApp#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#client_secret FunctionApp#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret?: string;
}
export declare function functionAppAuthSettingsActiveDirectoryToTerraform(struct?: FunctionAppAuthSettingsActiveDirectoryOutputReference | FunctionAppAuthSettingsActiveDirectory): any;
/**
 * @stability stable
 */
export declare class FunctionAppAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppAuthSettingsActiveDirectory | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppAuthSettingsActiveDirectory | undefined);
    private _allowedAudiences?;
    /**
     * @stability stable
     */
    get allowedAudiences(): string[];
    /**
     * @stability stable
     */
    set allowedAudiences(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedAudiences(): void;
    /**
     * @stability stable
     */
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    resetClientSecret(): void;
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppAuthSettingsFacebook {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#app_id FunctionApp#app_id}.
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#app_secret FunctionApp#app_secret}.
     *
     * @stability stable
     */
    readonly appSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#oauth_scopes FunctionApp#oauth_scopes}.
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
}
export declare function functionAppAuthSettingsFacebookToTerraform(struct?: FunctionAppAuthSettingsFacebookOutputReference | FunctionAppAuthSettingsFacebook): any;
/**
 * @stability stable
 */
export declare class FunctionAppAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppAuthSettingsFacebook | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppAuthSettingsFacebook | undefined);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    private _appSecret?;
    /**
     * @stability stable
     */
    get appSecret(): string;
    /**
     * @stability stable
     */
    set appSecret(value: string);
    /**
     * @stability stable
     */
    get appSecretInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppAuthSettingsGoogle {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#client_id FunctionApp#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#client_secret FunctionApp#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#oauth_scopes FunctionApp#oauth_scopes}.
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
}
export declare function functionAppAuthSettingsGoogleToTerraform(struct?: FunctionAppAuthSettingsGoogleOutputReference | FunctionAppAuthSettingsGoogle): any;
/**
 * @stability stable
 */
export declare class FunctionAppAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppAuthSettingsGoogle | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppAuthSettingsGoogle | undefined);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppAuthSettingsMicrosoft {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#client_id FunctionApp#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#client_secret FunctionApp#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#oauth_scopes FunctionApp#oauth_scopes}.
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
}
export declare function functionAppAuthSettingsMicrosoftToTerraform(struct?: FunctionAppAuthSettingsMicrosoftOutputReference | FunctionAppAuthSettingsMicrosoft): any;
/**
 * @stability stable
 */
export declare class FunctionAppAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppAuthSettingsMicrosoft | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppAuthSettingsMicrosoft | undefined);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppAuthSettingsTwitter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#consumer_key FunctionApp#consumer_key}.
     *
     * @stability stable
     */
    readonly consumerKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#consumer_secret FunctionApp#consumer_secret}.
     *
     * @stability stable
     */
    readonly consumerSecret: string;
}
export declare function functionAppAuthSettingsTwitterToTerraform(struct?: FunctionAppAuthSettingsTwitterOutputReference | FunctionAppAuthSettingsTwitter): any;
/**
 * @stability stable
 */
export declare class FunctionAppAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppAuthSettingsTwitter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppAuthSettingsTwitter | undefined);
    private _consumerKey?;
    /**
     * @stability stable
     */
    get consumerKey(): string;
    /**
     * @stability stable
     */
    set consumerKey(value: string);
    /**
     * @stability stable
     */
    get consumerKeyInput(): string | undefined;
    private _consumerSecret?;
    /**
     * @stability stable
     */
    get consumerSecret(): string;
    /**
     * @stability stable
     */
    set consumerSecret(value: string);
    /**
     * @stability stable
     */
    get consumerSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppAuthSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#additional_login_params FunctionApp#additional_login_params}.
     *
     * @stability stable
     */
    readonly additionalLoginParams?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#allowed_external_redirect_urls FunctionApp#allowed_external_redirect_urls}.
     *
     * @stability stable
     */
    readonly allowedExternalRedirectUrls?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#default_provider FunctionApp#default_provider}.
     *
     * @stability stable
     */
    readonly defaultProvider?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#enabled FunctionApp#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#issuer FunctionApp#issuer}.
     *
     * @stability stable
     */
    readonly issuer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#runtime_version FunctionApp#runtime_version}.
     *
     * @stability stable
     */
    readonly runtimeVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#token_refresh_extension_hours FunctionApp#token_refresh_extension_hours}.
     *
     * @stability stable
     */
    readonly tokenRefreshExtensionHours?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#token_store_enabled FunctionApp#token_store_enabled}.
     *
     * @stability stable
     */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#unauthenticated_client_action FunctionApp#unauthenticated_client_action}.
     *
     * @stability stable
     */
    readonly unauthenticatedClientAction?: string;
    /**
     * active_directory block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#active_directory FunctionApp#active_directory}
     *
     * @stability stable
     */
    readonly activeDirectory?: FunctionAppAuthSettingsActiveDirectory;
    /**
     * facebook block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#facebook FunctionApp#facebook}
     *
     * @stability stable
     */
    readonly facebook?: FunctionAppAuthSettingsFacebook;
    /**
     * google block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#google FunctionApp#google}
     *
     * @stability stable
     */
    readonly google?: FunctionAppAuthSettingsGoogle;
    /**
     * microsoft block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#microsoft FunctionApp#microsoft}
     *
     * @stability stable
     */
    readonly microsoft?: FunctionAppAuthSettingsMicrosoft;
    /**
     * twitter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#twitter FunctionApp#twitter}
     *
     * @stability stable
     */
    readonly twitter?: FunctionAppAuthSettingsTwitter;
}
export declare function functionAppAuthSettingsToTerraform(struct?: FunctionAppAuthSettingsOutputReference | FunctionAppAuthSettings): any;
/**
 * @stability stable
 */
export declare class FunctionAppAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppAuthSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppAuthSettings | undefined);
    private _additionalLoginParams?;
    /**
     * @stability stable
     */
    get additionalLoginParams(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalLoginParams(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalLoginParams(): void;
    /**
     * @stability stable
     */
    get additionalLoginParamsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _allowedExternalRedirectUrls?;
    /**
     * @stability stable
     */
    get allowedExternalRedirectUrls(): string[];
    /**
     * @stability stable
     */
    set allowedExternalRedirectUrls(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedExternalRedirectUrls(): void;
    /**
     * @stability stable
     */
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _defaultProvider?;
    /**
     * @stability stable
     */
    get defaultProvider(): string;
    /**
     * @stability stable
     */
    set defaultProvider(value: string);
    /**
     * @stability stable
     */
    resetDefaultProvider(): void;
    /**
     * @stability stable
     */
    get defaultProviderInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    set issuer(value: string);
    /**
     * @stability stable
     */
    resetIssuer(): void;
    /**
     * @stability stable
     */
    get issuerInput(): string | undefined;
    private _runtimeVersion?;
    /**
     * @stability stable
     */
    get runtimeVersion(): string;
    /**
     * @stability stable
     */
    set runtimeVersion(value: string);
    /**
     * @stability stable
     */
    resetRuntimeVersion(): void;
    /**
     * @stability stable
     */
    get runtimeVersionInput(): string | undefined;
    private _tokenRefreshExtensionHours?;
    /**
     * @stability stable
     */
    get tokenRefreshExtensionHours(): number;
    /**
     * @stability stable
     */
    set tokenRefreshExtensionHours(value: number);
    /**
     * @stability stable
     */
    resetTokenRefreshExtensionHours(): void;
    /**
     * @stability stable
     */
    get tokenRefreshExtensionHoursInput(): number | undefined;
    private _tokenStoreEnabled?;
    /**
     * @stability stable
     */
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTokenStoreEnabled(): void;
    /**
     * @stability stable
     */
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _unauthenticatedClientAction?;
    /**
     * @stability stable
     */
    get unauthenticatedClientAction(): string;
    /**
     * @stability stable
     */
    set unauthenticatedClientAction(value: string);
    /**
     * @stability stable
     */
    resetUnauthenticatedClientAction(): void;
    /**
     * @stability stable
     */
    get unauthenticatedClientActionInput(): string | undefined;
    private _activeDirectory;
    /**
     * @stability stable
     */
    get activeDirectory(): FunctionAppAuthSettingsActiveDirectoryOutputReference;
    /**
     * @stability stable
     */
    putActiveDirectory(value: FunctionAppAuthSettingsActiveDirectory): void;
    /**
     * @stability stable
     */
    resetActiveDirectory(): void;
    /**
     * @stability stable
     */
    get activeDirectoryInput(): FunctionAppAuthSettingsActiveDirectory | undefined;
    private _facebook;
    /**
     * @stability stable
     */
    get facebook(): FunctionAppAuthSettingsFacebookOutputReference;
    /**
     * @stability stable
     */
    putFacebook(value: FunctionAppAuthSettingsFacebook): void;
    /**
     * @stability stable
     */
    resetFacebook(): void;
    /**
     * @stability stable
     */
    get facebookInput(): FunctionAppAuthSettingsFacebook | undefined;
    private _google;
    /**
     * @stability stable
     */
    get google(): FunctionAppAuthSettingsGoogleOutputReference;
    /**
     * @stability stable
     */
    putGoogle(value: FunctionAppAuthSettingsGoogle): void;
    /**
     * @stability stable
     */
    resetGoogle(): void;
    /**
     * @stability stable
     */
    get googleInput(): FunctionAppAuthSettingsGoogle | undefined;
    private _microsoft;
    /**
     * @stability stable
     */
    get microsoft(): FunctionAppAuthSettingsMicrosoftOutputReference;
    /**
     * @stability stable
     */
    putMicrosoft(value: FunctionAppAuthSettingsMicrosoft): void;
    /**
     * @stability stable
     */
    resetMicrosoft(): void;
    /**
     * @stability stable
     */
    get microsoftInput(): FunctionAppAuthSettingsMicrosoft | undefined;
    private _twitter;
    /**
     * @stability stable
     */
    get twitter(): FunctionAppAuthSettingsTwitterOutputReference;
    /**
     * @stability stable
     */
    putTwitter(value: FunctionAppAuthSettingsTwitter): void;
    /**
     * @stability stable
     */
    resetTwitter(): void;
    /**
     * @stability stable
     */
    get twitterInput(): FunctionAppAuthSettingsTwitter | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppConnectionString {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#name FunctionApp#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#type FunctionApp#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#value FunctionApp#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function functionAppConnectionStringToTerraform(struct?: FunctionAppConnectionString): any;
/**
 * @stability stable
 */
export interface FunctionAppIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#identity_ids FunctionApp#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#type FunctionApp#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function functionAppIdentityToTerraform(struct?: FunctionAppIdentityOutputReference | FunctionAppIdentity): any;
/**
 * @stability stable
 */
export declare class FunctionAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppSiteConfigIpRestrictionHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#x_azure_fdid FunctionApp#x_azure_fdid}.
     *
     * @stability stable
     */
    readonly xAzureFdid?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#x_fd_health_probe FunctionApp#x_fd_health_probe}.
     *
     * @stability stable
     */
    readonly xFdHealthProbe?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#x_forwarded_for FunctionApp#x_forwarded_for}.
     *
     * @stability stable
     */
    readonly xForwardedFor?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#x_forwarded_host FunctionApp#x_forwarded_host}.
     *
     * @stability stable
     */
    readonly xForwardedHost?: string[];
}
export declare function functionAppSiteConfigIpRestrictionHeadersToTerraform(struct?: FunctionAppSiteConfigIpRestrictionHeaders): any;
/**
 * @stability stable
 */
export interface FunctionAppSiteConfigIpRestriction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#action FunctionApp#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#headers FunctionApp#headers}.
     *
     * @stability stable
     */
    readonly headers?: FunctionAppSiteConfigIpRestrictionHeaders[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#ip_address FunctionApp#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#name FunctionApp#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#priority FunctionApp#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#service_tag FunctionApp#service_tag}.
     *
     * @stability stable
     */
    readonly serviceTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#virtual_network_subnet_id FunctionApp#virtual_network_subnet_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetId?: string;
}
export declare function functionAppSiteConfigIpRestrictionToTerraform(struct?: FunctionAppSiteConfigIpRestriction): any;
/**
 * @stability stable
 */
export interface FunctionAppSiteConfigScmIpRestrictionHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#x_azure_fdid FunctionApp#x_azure_fdid}.
     *
     * @stability stable
     */
    readonly xAzureFdid?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#x_fd_health_probe FunctionApp#x_fd_health_probe}.
     *
     * @stability stable
     */
    readonly xFdHealthProbe?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#x_forwarded_for FunctionApp#x_forwarded_for}.
     *
     * @stability stable
     */
    readonly xForwardedFor?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#x_forwarded_host FunctionApp#x_forwarded_host}.
     *
     * @stability stable
     */
    readonly xForwardedHost?: string[];
}
export declare function functionAppSiteConfigScmIpRestrictionHeadersToTerraform(struct?: FunctionAppSiteConfigScmIpRestrictionHeaders): any;
/**
 * @stability stable
 */
export interface FunctionAppSiteConfigScmIpRestriction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#action FunctionApp#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#headers FunctionApp#headers}.
     *
     * @stability stable
     */
    readonly headers?: FunctionAppSiteConfigScmIpRestrictionHeaders[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#ip_address FunctionApp#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#name FunctionApp#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#priority FunctionApp#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#service_tag FunctionApp#service_tag}.
     *
     * @stability stable
     */
    readonly serviceTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#virtual_network_subnet_id FunctionApp#virtual_network_subnet_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetId?: string;
}
export declare function functionAppSiteConfigScmIpRestrictionToTerraform(struct?: FunctionAppSiteConfigScmIpRestriction): any;
/**
 * @stability stable
 */
export interface FunctionAppSiteConfigCors {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#allowed_origins FunctionApp#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#support_credentials FunctionApp#support_credentials}.
     *
     * @stability stable
     */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function functionAppSiteConfigCorsToTerraform(struct?: FunctionAppSiteConfigCorsOutputReference | FunctionAppSiteConfigCors): any;
/**
 * @stability stable
 */
export declare class FunctionAppSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSiteConfigCors | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSiteConfigCors | undefined);
    private _allowedOrigins?;
    /**
     * @stability stable
     */
    get allowedOrigins(): string[];
    /**
     * @stability stable
     */
    set allowedOrigins(value: string[]);
    /**
     * @stability stable
     */
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    /**
     * @stability stable
     */
    get supportCredentials(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set supportCredentials(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSupportCredentials(): void;
    /**
     * @stability stable
     */
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppSiteConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#always_on FunctionApp#always_on}.
     *
     * @stability stable
     */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#app_scale_limit FunctionApp#app_scale_limit}.
     *
     * @stability stable
     */
    readonly appScaleLimit?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#auto_swap_slot_name FunctionApp#auto_swap_slot_name}.
     *
     * @stability stable
     */
    readonly autoSwapSlotName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#dotnet_framework_version FunctionApp#dotnet_framework_version}.
     *
     * @stability stable
     */
    readonly dotnetFrameworkVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#elastic_instance_minimum FunctionApp#elastic_instance_minimum}.
     *
     * @stability stable
     */
    readonly elasticInstanceMinimum?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#ftps_state FunctionApp#ftps_state}.
     *
     * @stability stable
     */
    readonly ftpsState?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#health_check_path FunctionApp#health_check_path}.
     *
     * @stability stable
     */
    readonly healthCheckPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#http2_enabled FunctionApp#http2_enabled}.
     *
     * @stability stable
     */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#ip_restriction FunctionApp#ip_restriction}.
     *
     * @stability stable
     */
    readonly ipRestriction?: FunctionAppSiteConfigIpRestriction[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#java_version FunctionApp#java_version}.
     *
     * @stability stable
     */
    readonly javaVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#linux_fx_version FunctionApp#linux_fx_version}.
     *
     * @stability stable
     */
    readonly linuxFxVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#min_tls_version FunctionApp#min_tls_version}.
     *
     * @stability stable
     */
    readonly minTlsVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#pre_warmed_instance_count FunctionApp#pre_warmed_instance_count}.
     *
     * @stability stable
     */
    readonly preWarmedInstanceCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#runtime_scale_monitoring_enabled FunctionApp#runtime_scale_monitoring_enabled}.
     *
     * @stability stable
     */
    readonly runtimeScaleMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#scm_ip_restriction FunctionApp#scm_ip_restriction}.
     *
     * @stability stable
     */
    readonly scmIpRestriction?: FunctionAppSiteConfigScmIpRestriction[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#scm_type FunctionApp#scm_type}.
     *
     * @stability stable
     */
    readonly scmType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#scm_use_main_ip_restriction FunctionApp#scm_use_main_ip_restriction}.
     *
     * @stability stable
     */
    readonly scmUseMainIpRestriction?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#use_32_bit_worker_process FunctionApp#use_32_bit_worker_process}.
     *
     * @stability stable
     */
    readonly use32BitWorkerProcess?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#vnet_route_all_enabled FunctionApp#vnet_route_all_enabled}.
     *
     * @stability stable
     */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#websockets_enabled FunctionApp#websockets_enabled}.
     *
     * @stability stable
     */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
     * cors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#cors FunctionApp#cors}
     *
     * @stability stable
     */
    readonly cors?: FunctionAppSiteConfigCors;
}
export declare function functionAppSiteConfigToTerraform(struct?: FunctionAppSiteConfigOutputReference | FunctionAppSiteConfig): any;
/**
 * @stability stable
 */
export declare class FunctionAppSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSiteConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSiteConfig | undefined);
    private _alwaysOn?;
    /**
     * @stability stable
     */
    get alwaysOn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alwaysOn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAlwaysOn(): void;
    /**
     * @stability stable
     */
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _appScaleLimit?;
    /**
     * @stability stable
     */
    get appScaleLimit(): number;
    /**
     * @stability stable
     */
    set appScaleLimit(value: number);
    /**
     * @stability stable
     */
    resetAppScaleLimit(): void;
    /**
     * @stability stable
     */
    get appScaleLimitInput(): number | undefined;
    private _autoSwapSlotName?;
    /**
     * @stability stable
     */
    get autoSwapSlotName(): string;
    /**
     * @stability stable
     */
    set autoSwapSlotName(value: string);
    /**
     * @stability stable
     */
    resetAutoSwapSlotName(): void;
    /**
     * @stability stable
     */
    get autoSwapSlotNameInput(): string | undefined;
    private _dotnetFrameworkVersion?;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersion(): string;
    /**
     * @stability stable
     */
    set dotnetFrameworkVersion(value: string);
    /**
     * @stability stable
     */
    resetDotnetFrameworkVersion(): void;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersionInput(): string | undefined;
    private _elasticInstanceMinimum?;
    /**
     * @stability stable
     */
    get elasticInstanceMinimum(): number;
    /**
     * @stability stable
     */
    set elasticInstanceMinimum(value: number);
    /**
     * @stability stable
     */
    resetElasticInstanceMinimum(): void;
    /**
     * @stability stable
     */
    get elasticInstanceMinimumInput(): number | undefined;
    private _ftpsState?;
    /**
     * @stability stable
     */
    get ftpsState(): string;
    /**
     * @stability stable
     */
    set ftpsState(value: string);
    /**
     * @stability stable
     */
    resetFtpsState(): void;
    /**
     * @stability stable
     */
    get ftpsStateInput(): string | undefined;
    private _healthCheckPath?;
    /**
     * @stability stable
     */
    get healthCheckPath(): string;
    /**
     * @stability stable
     */
    set healthCheckPath(value: string);
    /**
     * @stability stable
     */
    resetHealthCheckPath(): void;
    /**
     * @stability stable
     */
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    /**
     * @stability stable
     */
    get http2Enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set http2Enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttp2Enabled(): void;
    /**
     * @stability stable
     */
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestriction?;
    /**
     * @stability stable
     */
    get ipRestriction(): FunctionAppSiteConfigIpRestriction[];
    /**
     * @stability stable
     */
    set ipRestriction(value: FunctionAppSiteConfigIpRestriction[]);
    /**
     * @stability stable
     */
    resetIpRestriction(): void;
    /**
     * @stability stable
     */
    get ipRestrictionInput(): FunctionAppSiteConfigIpRestriction[] | undefined;
    private _javaVersion?;
    /**
     * @stability stable
     */
    get javaVersion(): string;
    /**
     * @stability stable
     */
    set javaVersion(value: string);
    /**
     * @stability stable
     */
    resetJavaVersion(): void;
    /**
     * @stability stable
     */
    get javaVersionInput(): string | undefined;
    private _linuxFxVersion?;
    /**
     * @stability stable
     */
    get linuxFxVersion(): string;
    /**
     * @stability stable
     */
    set linuxFxVersion(value: string);
    /**
     * @stability stable
     */
    resetLinuxFxVersion(): void;
    /**
     * @stability stable
     */
    get linuxFxVersionInput(): string | undefined;
    private _minTlsVersion?;
    /**
     * @stability stable
     */
    get minTlsVersion(): string;
    /**
     * @stability stable
     */
    set minTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinTlsVersion(): void;
    /**
     * @stability stable
     */
    get minTlsVersionInput(): string | undefined;
    private _preWarmedInstanceCount?;
    /**
     * @stability stable
     */
    get preWarmedInstanceCount(): number;
    /**
     * @stability stable
     */
    set preWarmedInstanceCount(value: number);
    /**
     * @stability stable
     */
    resetPreWarmedInstanceCount(): void;
    /**
     * @stability stable
     */
    get preWarmedInstanceCountInput(): number | undefined;
    private _runtimeScaleMonitoringEnabled?;
    /**
     * @stability stable
     */
    get runtimeScaleMonitoringEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set runtimeScaleMonitoringEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRuntimeScaleMonitoringEnabled(): void;
    /**
     * @stability stable
     */
    get runtimeScaleMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _scmIpRestriction?;
    /**
     * @stability stable
     */
    get scmIpRestriction(): FunctionAppSiteConfigScmIpRestriction[];
    /**
     * @stability stable
     */
    set scmIpRestriction(value: FunctionAppSiteConfigScmIpRestriction[]);
    /**
     * @stability stable
     */
    resetScmIpRestriction(): void;
    /**
     * @stability stable
     */
    get scmIpRestrictionInput(): FunctionAppSiteConfigScmIpRestriction[] | undefined;
    private _scmType?;
    /**
     * @stability stable
     */
    get scmType(): string;
    /**
     * @stability stable
     */
    set scmType(value: string);
    /**
     * @stability stable
     */
    resetScmType(): void;
    /**
     * @stability stable
     */
    get scmTypeInput(): string | undefined;
    private _scmUseMainIpRestriction?;
    /**
     * @stability stable
     */
    get scmUseMainIpRestriction(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set scmUseMainIpRestriction(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetScmUseMainIpRestriction(): void;
    /**
     * @stability stable
     */
    get scmUseMainIpRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorkerProcess?;
    /**
     * @stability stable
     */
    get use32BitWorkerProcess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set use32BitWorkerProcess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUse32BitWorkerProcess(): void;
    /**
     * @stability stable
     */
    get use32BitWorkerProcessInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVnetRouteAllEnabled(): void;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    /**
     * @stability stable
     */
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWebsocketsEnabled(): void;
    /**
     * @stability stable
     */
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cors;
    /**
     * @stability stable
     */
    get cors(): FunctionAppSiteConfigCorsOutputReference;
    /**
     * @stability stable
     */
    putCors(value: FunctionAppSiteConfigCors): void;
    /**
     * @stability stable
     */
    resetCors(): void;
    /**
     * @stability stable
     */
    get corsInput(): FunctionAppSiteConfigCors | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppSourceControl {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#branch FunctionApp#branch}.
     *
     * @stability stable
     */
    readonly branch?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#manual_integration FunctionApp#manual_integration}.
     *
     * @stability stable
     */
    readonly manualIntegration?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#repo_url FunctionApp#repo_url}.
     *
     * @stability stable
     */
    readonly repoUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#rollback_enabled FunctionApp#rollback_enabled}.
     *
     * @stability stable
     */
    readonly rollbackEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#use_mercurial FunctionApp#use_mercurial}.
     *
     * @stability stable
     */
    readonly useMercurial?: boolean | cdktf.IResolvable;
}
export declare function functionAppSourceControlToTerraform(struct?: FunctionAppSourceControlOutputReference | FunctionAppSourceControl): any;
/**
 * @stability stable
 */
export declare class FunctionAppSourceControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppSourceControl | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppSourceControl | undefined);
    private _branch?;
    /**
     * @stability stable
     */
    get branch(): string;
    /**
     * @stability stable
     */
    set branch(value: string);
    /**
     * @stability stable
     */
    resetBranch(): void;
    /**
     * @stability stable
     */
    get branchInput(): string | undefined;
    private _manualIntegration?;
    /**
     * @stability stable
     */
    get manualIntegration(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set manualIntegration(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetManualIntegration(): void;
    /**
     * @stability stable
     */
    get manualIntegrationInput(): boolean | cdktf.IResolvable | undefined;
    private _repoUrl?;
    /**
     * @stability stable
     */
    get repoUrl(): string;
    /**
     * @stability stable
     */
    set repoUrl(value: string);
    /**
     * @stability stable
     */
    resetRepoUrl(): void;
    /**
     * @stability stable
     */
    get repoUrlInput(): string | undefined;
    private _rollbackEnabled?;
    /**
     * @stability stable
     */
    get rollbackEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set rollbackEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRollbackEnabled(): void;
    /**
     * @stability stable
     */
    get rollbackEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _useMercurial?;
    /**
     * @stability stable
     */
    get useMercurial(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useMercurial(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseMercurial(): void;
    /**
     * @stability stable
     */
    get useMercurialInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface FunctionAppTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#create FunctionApp#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#delete FunctionApp#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#read FunctionApp#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/function_app#update FunctionApp#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function functionAppTimeoutsToTerraform(struct?: FunctionAppTimeoutsOutputReference | FunctionAppTimeouts): any;
/**
 * @stability stable
 */
export declare class FunctionAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FunctionAppTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FunctionAppTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/function_app azurerm_function_app}.
 *
 * @stability stable
 */
export declare class FunctionApp extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/function_app azurerm_function_app} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FunctionAppConfig);
    private _appServicePlanId?;
    /**
     * @stability stable
     */
    get appServicePlanId(): string;
    /**
     * @stability stable
     */
    set appServicePlanId(value: string);
    /**
     * @stability stable
     */
    get appServicePlanIdInput(): string | undefined;
    private _appSettings?;
    /**
     * @stability stable
     */
    get appSettings(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set appSettings(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAppSettings(): void;
    /**
     * @stability stable
     */
    get appSettingsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _clientAffinityEnabled?;
    /**
     * @stability stable
     */
    get clientAffinityEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientAffinityEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientAffinityEnabled(): void;
    /**
     * @stability stable
     */
    get clientAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertMode?;
    /**
     * @stability stable
     */
    get clientCertMode(): string;
    /**
     * @stability stable
     */
    set clientCertMode(value: string);
    /**
     * @stability stable
     */
    resetClientCertMode(): void;
    /**
     * @stability stable
     */
    get clientCertModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get customDomainVerificationId(): string;
    private _dailyMemoryTimeQuota?;
    /**
     * @stability stable
     */
    get dailyMemoryTimeQuota(): number;
    /**
     * @stability stable
     */
    set dailyMemoryTimeQuota(value: number);
    /**
     * @stability stable
     */
    resetDailyMemoryTimeQuota(): void;
    /**
     * @stability stable
     */
    get dailyMemoryTimeQuotaInput(): number | undefined;
    /**
     * @stability stable
     */
    get defaultHostname(): string;
    private _enableBuiltinLogging?;
    /**
     * @stability stable
     */
    get enableBuiltinLogging(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableBuiltinLogging(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableBuiltinLogging(): void;
    /**
     * @stability stable
     */
    get enableBuiltinLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpsOnly?;
    /**
     * @stability stable
     */
    get httpsOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set httpsOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttpsOnly(): void;
    /**
     * @stability stable
     */
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultReferenceIdentityId?;
    /**
     * @stability stable
     */
    get keyVaultReferenceIdentityId(): string;
    /**
     * @stability stable
     */
    set keyVaultReferenceIdentityId(value: string);
    /**
     * @stability stable
     */
    resetKeyVaultReferenceIdentityId(): void;
    /**
     * @stability stable
     */
    get keyVaultReferenceIdentityIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get kind(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _osType?;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    set osType(value: string);
    /**
     * @stability stable
     */
    resetOsType(): void;
    /**
     * @stability stable
     */
    get osTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get outboundIpAddresses(): string;
    /**
     * @stability stable
     */
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    siteCredential(index: string): FunctionAppSiteCredential;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountAccessKey(): void;
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageAccountName?;
    /**
     * @stability stable
     */
    get storageAccountName(): string;
    /**
     * @stability stable
     */
    set storageAccountName(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountName(): void;
    /**
     * @stability stable
     */
    get storageAccountNameInput(): string | undefined;
    private _storageConnectionString?;
    /**
     * @stability stable
     */
    get storageConnectionString(): string;
    /**
     * @stability stable
     */
    set storageConnectionString(value: string);
    /**
     * @stability stable
     */
    resetStorageConnectionString(): void;
    /**
     * @stability stable
     */
    get storageConnectionStringInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _authSettings;
    /**
     * @stability stable
     */
    get authSettings(): FunctionAppAuthSettingsOutputReference;
    /**
     * @stability stable
     */
    putAuthSettings(value: FunctionAppAuthSettings): void;
    /**
     * @stability stable
     */
    resetAuthSettings(): void;
    /**
     * @stability stable
     */
    get authSettingsInput(): FunctionAppAuthSettings | undefined;
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): FunctionAppConnectionString[];
    /**
     * @stability stable
     */
    set connectionString(value: FunctionAppConnectionString[]);
    /**
     * @stability stable
     */
    resetConnectionString(): void;
    /**
     * @stability stable
     */
    get connectionStringInput(): FunctionAppConnectionString[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): FunctionAppIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: FunctionAppIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): FunctionAppIdentity | undefined;
    private _siteConfig;
    /**
     * @stability stable
     */
    get siteConfig(): FunctionAppSiteConfigOutputReference;
    /**
     * @stability stable
     */
    putSiteConfig(value: FunctionAppSiteConfig): void;
    /**
     * @stability stable
     */
    resetSiteConfig(): void;
    /**
     * @stability stable
     */
    get siteConfigInput(): FunctionAppSiteConfig | undefined;
    private _sourceControl;
    /**
     * @stability stable
     */
    get sourceControl(): FunctionAppSourceControlOutputReference;
    /**
     * @stability stable
     */
    putSourceControl(value: FunctionAppSourceControl): void;
    /**
     * @stability stable
     */
    resetSourceControl(): void;
    /**
     * @stability stable
     */
    get sourceControlInput(): FunctionAppSourceControl | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FunctionAppTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FunctionAppTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FunctionAppTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
