import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HdinsightSparkClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#cluster_version HdinsightSparkCluster#cluster_version}.
     *
     * @stability stable
     */
    readonly clusterVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#encryption_in_transit_enabled HdinsightSparkCluster#encryption_in_transit_enabled}.
     *
     * @stability stable
     */
    readonly encryptionInTransitEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#location HdinsightSparkCluster#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#name HdinsightSparkCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#resource_group_name HdinsightSparkCluster#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#tags HdinsightSparkCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#tier HdinsightSparkCluster#tier}.
     *
     * @stability stable
     */
    readonly tier: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#tls_min_version HdinsightSparkCluster#tls_min_version}.
     *
     * @stability stable
     */
    readonly tlsMinVersion?: string;
    /**
     * component_version block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#component_version HdinsightSparkCluster#component_version}
     *
     * @stability stable
     */
    readonly componentVersion: HdinsightSparkClusterComponentVersion;
    /**
     * gateway block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#gateway HdinsightSparkCluster#gateway}
     *
     * @stability stable
     */
    readonly gateway: HdinsightSparkClusterGateway;
    /**
     * metastores block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#metastores HdinsightSparkCluster#metastores}
     *
     * @stability stable
     */
    readonly metastores?: HdinsightSparkClusterMetastores;
    /**
     * monitor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#monitor HdinsightSparkCluster#monitor}
     *
     * @stability stable
     */
    readonly monitor?: HdinsightSparkClusterMonitor;
    /**
     * network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#network HdinsightSparkCluster#network}
     *
     * @stability stable
     */
    readonly network?: HdinsightSparkClusterNetwork;
    /**
     * roles block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#roles HdinsightSparkCluster#roles}
     *
     * @stability stable
     */
    readonly roles: HdinsightSparkClusterRoles;
    /**
     * security_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#security_profile HdinsightSparkCluster#security_profile}
     *
     * @stability stable
     */
    readonly securityProfile?: HdinsightSparkClusterSecurityProfile;
    /**
     * storage_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#storage_account HdinsightSparkCluster#storage_account}
     *
     * @stability stable
     */
    readonly storageAccount?: HdinsightSparkClusterStorageAccount[];
    /**
     * storage_account_gen2 block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#storage_account_gen2 HdinsightSparkCluster#storage_account_gen2}
     *
     * @stability stable
     */
    readonly storageAccountGen2?: HdinsightSparkClusterStorageAccountGen2;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#timeouts HdinsightSparkCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HdinsightSparkClusterTimeouts;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterComponentVersion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#spark HdinsightSparkCluster#spark}.
     *
     * @stability stable
     */
    readonly spark: string;
}
export declare function hdinsightSparkClusterComponentVersionToTerraform(struct?: HdinsightSparkClusterComponentVersionOutputReference | HdinsightSparkClusterComponentVersion): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterComponentVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterComponentVersion | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterComponentVersion | undefined);
    private _spark?;
    /**
     * @stability stable
     */
    get spark(): string;
    /**
     * @stability stable
     */
    set spark(value: string);
    /**
     * @stability stable
     */
    get sparkInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterGateway {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#enabled HdinsightSparkCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#password HdinsightSparkCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#username HdinsightSparkCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightSparkClusterGatewayToTerraform(struct?: HdinsightSparkClusterGatewayOutputReference | HdinsightSparkClusterGateway): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterGateway | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterGateway | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterMetastoresAmbari {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#database_name HdinsightSparkCluster#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#password HdinsightSparkCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#server HdinsightSparkCluster#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#username HdinsightSparkCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightSparkClusterMetastoresAmbariToTerraform(struct?: HdinsightSparkClusterMetastoresAmbariOutputReference | HdinsightSparkClusterMetastoresAmbari): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterMetastoresAmbariOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterMetastoresAmbari | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterMetastoresAmbari | undefined);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterMetastoresHive {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#database_name HdinsightSparkCluster#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#password HdinsightSparkCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#server HdinsightSparkCluster#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#username HdinsightSparkCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightSparkClusterMetastoresHiveToTerraform(struct?: HdinsightSparkClusterMetastoresHiveOutputReference | HdinsightSparkClusterMetastoresHive): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterMetastoresHiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterMetastoresHive | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterMetastoresHive | undefined);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterMetastoresOozie {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#database_name HdinsightSparkCluster#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#password HdinsightSparkCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#server HdinsightSparkCluster#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#username HdinsightSparkCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightSparkClusterMetastoresOozieToTerraform(struct?: HdinsightSparkClusterMetastoresOozieOutputReference | HdinsightSparkClusterMetastoresOozie): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterMetastoresOozieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterMetastoresOozie | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterMetastoresOozie | undefined);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterMetastores {
    /**
     * ambari block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#ambari HdinsightSparkCluster#ambari}
     *
     * @stability stable
     */
    readonly ambari?: HdinsightSparkClusterMetastoresAmbari;
    /**
     * hive block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#hive HdinsightSparkCluster#hive}
     *
     * @stability stable
     */
    readonly hive?: HdinsightSparkClusterMetastoresHive;
    /**
     * oozie block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#oozie HdinsightSparkCluster#oozie}
     *
     * @stability stable
     */
    readonly oozie?: HdinsightSparkClusterMetastoresOozie;
}
export declare function hdinsightSparkClusterMetastoresToTerraform(struct?: HdinsightSparkClusterMetastoresOutputReference | HdinsightSparkClusterMetastores): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterMetastoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterMetastores | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterMetastores | undefined);
    private _ambari;
    /**
     * @stability stable
     */
    get ambari(): HdinsightSparkClusterMetastoresAmbariOutputReference;
    /**
     * @stability stable
     */
    putAmbari(value: HdinsightSparkClusterMetastoresAmbari): void;
    /**
     * @stability stable
     */
    resetAmbari(): void;
    /**
     * @stability stable
     */
    get ambariInput(): HdinsightSparkClusterMetastoresAmbari | undefined;
    private _hive;
    /**
     * @stability stable
     */
    get hive(): HdinsightSparkClusterMetastoresHiveOutputReference;
    /**
     * @stability stable
     */
    putHive(value: HdinsightSparkClusterMetastoresHive): void;
    /**
     * @stability stable
     */
    resetHive(): void;
    /**
     * @stability stable
     */
    get hiveInput(): HdinsightSparkClusterMetastoresHive | undefined;
    private _oozie;
    /**
     * @stability stable
     */
    get oozie(): HdinsightSparkClusterMetastoresOozieOutputReference;
    /**
     * @stability stable
     */
    putOozie(value: HdinsightSparkClusterMetastoresOozie): void;
    /**
     * @stability stable
     */
    resetOozie(): void;
    /**
     * @stability stable
     */
    get oozieInput(): HdinsightSparkClusterMetastoresOozie | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterMonitor {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#log_analytics_workspace_id HdinsightSparkCluster#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#primary_key HdinsightSparkCluster#primary_key}.
     *
     * @stability stable
     */
    readonly primaryKey: string;
}
export declare function hdinsightSparkClusterMonitorToTerraform(struct?: HdinsightSparkClusterMonitorOutputReference | HdinsightSparkClusterMonitor): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterMonitor | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterMonitor | undefined);
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    /**
     * @stability stable
     */
    set primaryKey(value: string);
    /**
     * @stability stable
     */
    get primaryKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterNetwork {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#connection_direction HdinsightSparkCluster#connection_direction}.
     *
     * @stability stable
     */
    readonly connectionDirection?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#private_link_enabled HdinsightSparkCluster#private_link_enabled}.
     *
     * @stability stable
     */
    readonly privateLinkEnabled?: boolean | cdktf.IResolvable;
}
export declare function hdinsightSparkClusterNetworkToTerraform(struct?: HdinsightSparkClusterNetworkOutputReference | HdinsightSparkClusterNetwork): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterNetwork | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterNetwork | undefined);
    private _connectionDirection?;
    /**
     * @stability stable
     */
    get connectionDirection(): string;
    /**
     * @stability stable
     */
    set connectionDirection(value: string);
    /**
     * @stability stable
     */
    resetConnectionDirection(): void;
    /**
     * @stability stable
     */
    get connectionDirectionInput(): string | undefined;
    private _privateLinkEnabled?;
    /**
     * @stability stable
     */
    get privateLinkEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set privateLinkEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPrivateLinkEnabled(): void;
    /**
     * @stability stable
     */
    get privateLinkEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterRolesHeadNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#password HdinsightSparkCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#ssh_keys HdinsightSparkCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#subnet_id HdinsightSparkCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#username HdinsightSparkCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#virtual_network_id HdinsightSparkCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#vm_size HdinsightSparkCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightSparkClusterRolesHeadNodeToTerraform(struct?: HdinsightSparkClusterRolesHeadNodeOutputReference | HdinsightSparkClusterRolesHeadNode): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterRolesHeadNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterRolesHeadNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterRolesHeadNode | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#max_instance_count HdinsightSparkCluster#max_instance_count}.
     *
     * @stability stable
     */
    readonly maxInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#min_instance_count HdinsightSparkCluster#min_instance_count}.
     *
     * @stability stable
     */
    readonly minInstanceCount: number;
}
export declare function hdinsightSparkClusterRolesWorkerNodeAutoscaleCapacityToTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacityOutputReference | HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity | undefined);
    private _maxInstanceCount?;
    /**
     * @stability stable
     */
    get maxInstanceCount(): number;
    /**
     * @stability stable
     */
    set maxInstanceCount(value: number);
    /**
     * @stability stable
     */
    get maxInstanceCountInput(): number | undefined;
    private _minInstanceCount?;
    /**
     * @stability stable
     */
    get minInstanceCount(): number;
    /**
     * @stability stable
     */
    set minInstanceCount(value: number);
    /**
     * @stability stable
     */
    get minInstanceCountInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#days HdinsightSparkCluster#days}.
     *
     * @stability stable
     */
    readonly days: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#target_instance_count HdinsightSparkCluster#target_instance_count}.
     *
     * @stability stable
     */
    readonly targetInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#time HdinsightSparkCluster#time}.
     *
     * @stability stable
     */
    readonly time: string;
}
export declare function hdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceScheduleToTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule): any;
/**
 * @stability stable
 */
export interface HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#timezone HdinsightSparkCluster#timezone}.
     *
     * @stability stable
     */
    readonly timezone: string;
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#schedule HdinsightSparkCluster#schedule}
     *
     * @stability stable
     */
    readonly schedule: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[];
}
export declare function hdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceToTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference | HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence | undefined);
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _schedule?;
    /**
     * @stability stable
     */
    get schedule(): HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[];
    /**
     * @stability stable
     */
    set schedule(value: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[]);
    /**
     * @stability stable
     */
    get scheduleInput(): HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterRolesWorkerNodeAutoscale {
    /**
     * capacity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#capacity HdinsightSparkCluster#capacity}
     *
     * @stability stable
     */
    readonly capacity?: HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity;
    /**
     * recurrence block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#recurrence HdinsightSparkCluster#recurrence}
     *
     * @stability stable
     */
    readonly recurrence?: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence;
}
export declare function hdinsightSparkClusterRolesWorkerNodeAutoscaleToTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeAutoscaleOutputReference | HdinsightSparkClusterRolesWorkerNodeAutoscale): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterRolesWorkerNodeAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterRolesWorkerNodeAutoscale | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterRolesWorkerNodeAutoscale | undefined);
    private _capacity;
    /**
     * @stability stable
     */
    get capacity(): HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacityOutputReference;
    /**
     * @stability stable
     */
    putCapacity(value: HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity): void;
    /**
     * @stability stable
     */
    resetCapacity(): void;
    /**
     * @stability stable
     */
    get capacityInput(): HdinsightSparkClusterRolesWorkerNodeAutoscaleCapacity | undefined;
    private _recurrence;
    /**
     * @stability stable
     */
    get recurrence(): HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference;
    /**
     * @stability stable
     */
    putRecurrence(value: HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence): void;
    /**
     * @stability stable
     */
    resetRecurrence(): void;
    /**
     * @stability stable
     */
    get recurrenceInput(): HdinsightSparkClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterRolesWorkerNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#min_instance_count HdinsightSparkCluster#min_instance_count}.
     *
     * @stability stable
     */
    readonly minInstanceCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#password HdinsightSparkCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#ssh_keys HdinsightSparkCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#subnet_id HdinsightSparkCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#target_instance_count HdinsightSparkCluster#target_instance_count}.
     *
     * @stability stable
     */
    readonly targetInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#username HdinsightSparkCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#virtual_network_id HdinsightSparkCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#vm_size HdinsightSparkCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
    /**
     * autoscale block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#autoscale HdinsightSparkCluster#autoscale}
     *
     * @stability stable
     */
    readonly autoscale?: HdinsightSparkClusterRolesWorkerNodeAutoscale;
}
export declare function hdinsightSparkClusterRolesWorkerNodeToTerraform(struct?: HdinsightSparkClusterRolesWorkerNodeOutputReference | HdinsightSparkClusterRolesWorkerNode): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterRolesWorkerNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterRolesWorkerNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterRolesWorkerNode | undefined);
    private _minInstanceCount?;
    /**
     * @stability stable
     */
    get minInstanceCount(): number;
    /**
     * @stability stable
     */
    set minInstanceCount(value: number);
    /**
     * @stability stable
     */
    resetMinInstanceCount(): void;
    /**
     * @stability stable
     */
    get minInstanceCountInput(): number | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _targetInstanceCount?;
    /**
     * @stability stable
     */
    get targetInstanceCount(): number;
    /**
     * @stability stable
     */
    set targetInstanceCount(value: number);
    /**
     * @stability stable
     */
    get targetInstanceCountInput(): number | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
    private _autoscale;
    /**
     * @stability stable
     */
    get autoscale(): HdinsightSparkClusterRolesWorkerNodeAutoscaleOutputReference;
    /**
     * @stability stable
     */
    putAutoscale(value: HdinsightSparkClusterRolesWorkerNodeAutoscale): void;
    /**
     * @stability stable
     */
    resetAutoscale(): void;
    /**
     * @stability stable
     */
    get autoscaleInput(): HdinsightSparkClusterRolesWorkerNodeAutoscale | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterRolesZookeeperNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#password HdinsightSparkCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#ssh_keys HdinsightSparkCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#subnet_id HdinsightSparkCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#username HdinsightSparkCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#virtual_network_id HdinsightSparkCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#vm_size HdinsightSparkCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightSparkClusterRolesZookeeperNodeToTerraform(struct?: HdinsightSparkClusterRolesZookeeperNodeOutputReference | HdinsightSparkClusterRolesZookeeperNode): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterRolesZookeeperNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterRolesZookeeperNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterRolesZookeeperNode | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterRoles {
    /**
     * head_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#head_node HdinsightSparkCluster#head_node}
     *
     * @stability stable
     */
    readonly headNode: HdinsightSparkClusterRolesHeadNode;
    /**
     * worker_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#worker_node HdinsightSparkCluster#worker_node}
     *
     * @stability stable
     */
    readonly workerNode: HdinsightSparkClusterRolesWorkerNode;
    /**
     * zookeeper_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#zookeeper_node HdinsightSparkCluster#zookeeper_node}
     *
     * @stability stable
     */
    readonly zookeeperNode: HdinsightSparkClusterRolesZookeeperNode;
}
export declare function hdinsightSparkClusterRolesToTerraform(struct?: HdinsightSparkClusterRolesOutputReference | HdinsightSparkClusterRoles): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterRoles | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterRoles | undefined);
    private _headNode;
    /**
     * @stability stable
     */
    get headNode(): HdinsightSparkClusterRolesHeadNodeOutputReference;
    /**
     * @stability stable
     */
    putHeadNode(value: HdinsightSparkClusterRolesHeadNode): void;
    /**
     * @stability stable
     */
    get headNodeInput(): HdinsightSparkClusterRolesHeadNode | undefined;
    private _workerNode;
    /**
     * @stability stable
     */
    get workerNode(): HdinsightSparkClusterRolesWorkerNodeOutputReference;
    /**
     * @stability stable
     */
    putWorkerNode(value: HdinsightSparkClusterRolesWorkerNode): void;
    /**
     * @stability stable
     */
    get workerNodeInput(): HdinsightSparkClusterRolesWorkerNode | undefined;
    private _zookeeperNode;
    /**
     * @stability stable
     */
    get zookeeperNode(): HdinsightSparkClusterRolesZookeeperNodeOutputReference;
    /**
     * @stability stable
     */
    putZookeeperNode(value: HdinsightSparkClusterRolesZookeeperNode): void;
    /**
     * @stability stable
     */
    get zookeeperNodeInput(): HdinsightSparkClusterRolesZookeeperNode | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterSecurityProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#aadds_resource_id HdinsightSparkCluster#aadds_resource_id}.
     *
     * @stability stable
     */
    readonly aaddsResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#cluster_users_group_dns HdinsightSparkCluster#cluster_users_group_dns}.
     *
     * @stability stable
     */
    readonly clusterUsersGroupDns?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#domain_name HdinsightSparkCluster#domain_name}.
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#domain_user_password HdinsightSparkCluster#domain_user_password}.
     *
     * @stability stable
     */
    readonly domainUserPassword: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#domain_username HdinsightSparkCluster#domain_username}.
     *
     * @stability stable
     */
    readonly domainUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#ldaps_urls HdinsightSparkCluster#ldaps_urls}.
     *
     * @stability stable
     */
    readonly ldapsUrls: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#msi_resource_id HdinsightSparkCluster#msi_resource_id}.
     *
     * @stability stable
     */
    readonly msiResourceId: string;
}
export declare function hdinsightSparkClusterSecurityProfileToTerraform(struct?: HdinsightSparkClusterSecurityProfileOutputReference | HdinsightSparkClusterSecurityProfile): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterSecurityProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterSecurityProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterSecurityProfile | undefined);
    private _aaddsResourceId?;
    /**
     * @stability stable
     */
    get aaddsResourceId(): string;
    /**
     * @stability stable
     */
    set aaddsResourceId(value: string);
    /**
     * @stability stable
     */
    get aaddsResourceIdInput(): string | undefined;
    private _clusterUsersGroupDns?;
    /**
     * @stability stable
     */
    get clusterUsersGroupDns(): string[];
    /**
     * @stability stable
     */
    set clusterUsersGroupDns(value: string[]);
    /**
     * @stability stable
     */
    resetClusterUsersGroupDns(): void;
    /**
     * @stability stable
     */
    get clusterUsersGroupDnsInput(): string[] | undefined;
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    set domainName(value: string);
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    private _domainUserPassword?;
    /**
     * @stability stable
     */
    get domainUserPassword(): string;
    /**
     * @stability stable
     */
    set domainUserPassword(value: string);
    /**
     * @stability stable
     */
    get domainUserPasswordInput(): string | undefined;
    private _domainUsername?;
    /**
     * @stability stable
     */
    get domainUsername(): string;
    /**
     * @stability stable
     */
    set domainUsername(value: string);
    /**
     * @stability stable
     */
    get domainUsernameInput(): string | undefined;
    private _ldapsUrls?;
    /**
     * @stability stable
     */
    get ldapsUrls(): string[];
    /**
     * @stability stable
     */
    set ldapsUrls(value: string[]);
    /**
     * @stability stable
     */
    get ldapsUrlsInput(): string[] | undefined;
    private _msiResourceId?;
    /**
     * @stability stable
     */
    get msiResourceId(): string;
    /**
     * @stability stable
     */
    set msiResourceId(value: string);
    /**
     * @stability stable
     */
    get msiResourceIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterStorageAccount {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#is_default HdinsightSparkCluster#is_default}.
     *
     * @stability stable
     */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#storage_account_key HdinsightSparkCluster#storage_account_key}.
     *
     * @stability stable
     */
    readonly storageAccountKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#storage_container_id HdinsightSparkCluster#storage_container_id}.
     *
     * @stability stable
     */
    readonly storageContainerId: string;
}
export declare function hdinsightSparkClusterStorageAccountToTerraform(struct?: HdinsightSparkClusterStorageAccount): any;
/**
 * @stability stable
 */
export interface HdinsightSparkClusterStorageAccountGen2 {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#filesystem_id HdinsightSparkCluster#filesystem_id}.
     *
     * @stability stable
     */
    readonly filesystemId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#is_default HdinsightSparkCluster#is_default}.
     *
     * @stability stable
     */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#managed_identity_resource_id HdinsightSparkCluster#managed_identity_resource_id}.
     *
     * @stability stable
     */
    readonly managedIdentityResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#storage_resource_id HdinsightSparkCluster#storage_resource_id}.
     *
     * @stability stable
     */
    readonly storageResourceId: string;
}
export declare function hdinsightSparkClusterStorageAccountGen2ToTerraform(struct?: HdinsightSparkClusterStorageAccountGen2OutputReference | HdinsightSparkClusterStorageAccountGen2): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterStorageAccountGen2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterStorageAccountGen2 | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterStorageAccountGen2 | undefined);
    private _filesystemId?;
    /**
     * @stability stable
     */
    get filesystemId(): string;
    /**
     * @stability stable
     */
    set filesystemId(value: string);
    /**
     * @stability stable
     */
    get filesystemIdInput(): string | undefined;
    private _isDefault?;
    /**
     * @stability stable
     */
    get isDefault(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isDefault(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _managedIdentityResourceId?;
    /**
     * @stability stable
     */
    get managedIdentityResourceId(): string;
    /**
     * @stability stable
     */
    set managedIdentityResourceId(value: string);
    /**
     * @stability stable
     */
    get managedIdentityResourceIdInput(): string | undefined;
    private _storageResourceId?;
    /**
     * @stability stable
     */
    get storageResourceId(): string;
    /**
     * @stability stable
     */
    set storageResourceId(value: string);
    /**
     * @stability stable
     */
    get storageResourceIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightSparkClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#create HdinsightSparkCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#delete HdinsightSparkCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#read HdinsightSparkCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster#update HdinsightSparkCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function hdinsightSparkClusterTimeoutsToTerraform(struct?: HdinsightSparkClusterTimeoutsOutputReference | HdinsightSparkClusterTimeouts): any;
/**
 * @stability stable
 */
export declare class HdinsightSparkClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightSparkClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightSparkClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster azurerm_hdinsight_spark_cluster}.
 *
 * @stability stable
 */
export declare class HdinsightSparkCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_spark_cluster azurerm_hdinsight_spark_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HdinsightSparkClusterConfig);
    private _clusterVersion?;
    /**
     * @stability stable
     */
    get clusterVersion(): string;
    /**
     * @stability stable
     */
    set clusterVersion(value: string);
    /**
     * @stability stable
     */
    get clusterVersionInput(): string | undefined;
    private _encryptionInTransitEnabled?;
    /**
     * @stability stable
     */
    get encryptionInTransitEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encryptionInTransitEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncryptionInTransitEnabled(): void;
    /**
     * @stability stable
     */
    get encryptionInTransitEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get httpsEndpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get sshEndpoint(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _tlsMinVersion?;
    /**
     * @stability stable
     */
    get tlsMinVersion(): string;
    /**
     * @stability stable
     */
    set tlsMinVersion(value: string);
    /**
     * @stability stable
     */
    resetTlsMinVersion(): void;
    /**
     * @stability stable
     */
    get tlsMinVersionInput(): string | undefined;
    private _componentVersion;
    /**
     * @stability stable
     */
    get componentVersion(): HdinsightSparkClusterComponentVersionOutputReference;
    /**
     * @stability stable
     */
    putComponentVersion(value: HdinsightSparkClusterComponentVersion): void;
    /**
     * @stability stable
     */
    get componentVersionInput(): HdinsightSparkClusterComponentVersion | undefined;
    private _gateway;
    /**
     * @stability stable
     */
    get gateway(): HdinsightSparkClusterGatewayOutputReference;
    /**
     * @stability stable
     */
    putGateway(value: HdinsightSparkClusterGateway): void;
    /**
     * @stability stable
     */
    get gatewayInput(): HdinsightSparkClusterGateway | undefined;
    private _metastores;
    /**
     * @stability stable
     */
    get metastores(): HdinsightSparkClusterMetastoresOutputReference;
    /**
     * @stability stable
     */
    putMetastores(value: HdinsightSparkClusterMetastores): void;
    /**
     * @stability stable
     */
    resetMetastores(): void;
    /**
     * @stability stable
     */
    get metastoresInput(): HdinsightSparkClusterMetastores | undefined;
    private _monitor;
    /**
     * @stability stable
     */
    get monitor(): HdinsightSparkClusterMonitorOutputReference;
    /**
     * @stability stable
     */
    putMonitor(value: HdinsightSparkClusterMonitor): void;
    /**
     * @stability stable
     */
    resetMonitor(): void;
    /**
     * @stability stable
     */
    get monitorInput(): HdinsightSparkClusterMonitor | undefined;
    private _network;
    /**
     * @stability stable
     */
    get network(): HdinsightSparkClusterNetworkOutputReference;
    /**
     * @stability stable
     */
    putNetwork(value: HdinsightSparkClusterNetwork): void;
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): HdinsightSparkClusterNetwork | undefined;
    private _roles;
    /**
     * @stability stable
     */
    get roles(): HdinsightSparkClusterRolesOutputReference;
    /**
     * @stability stable
     */
    putRoles(value: HdinsightSparkClusterRoles): void;
    /**
     * @stability stable
     */
    get rolesInput(): HdinsightSparkClusterRoles | undefined;
    private _securityProfile;
    /**
     * @stability stable
     */
    get securityProfile(): HdinsightSparkClusterSecurityProfileOutputReference;
    /**
     * @stability stable
     */
    putSecurityProfile(value: HdinsightSparkClusterSecurityProfile): void;
    /**
     * @stability stable
     */
    resetSecurityProfile(): void;
    /**
     * @stability stable
     */
    get securityProfileInput(): HdinsightSparkClusterSecurityProfile | undefined;
    private _storageAccount?;
    /**
     * @stability stable
     */
    get storageAccount(): HdinsightSparkClusterStorageAccount[];
    /**
     * @stability stable
     */
    set storageAccount(value: HdinsightSparkClusterStorageAccount[]);
    /**
     * @stability stable
     */
    resetStorageAccount(): void;
    /**
     * @stability stable
     */
    get storageAccountInput(): HdinsightSparkClusterStorageAccount[] | undefined;
    private _storageAccountGen2;
    /**
     * @stability stable
     */
    get storageAccountGen2(): HdinsightSparkClusterStorageAccountGen2OutputReference;
    /**
     * @stability stable
     */
    putStorageAccountGen2(value: HdinsightSparkClusterStorageAccountGen2): void;
    /**
     * @stability stable
     */
    resetStorageAccountGen2(): void;
    /**
     * @stability stable
     */
    get storageAccountGen2Input(): HdinsightSparkClusterStorageAccountGen2 | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HdinsightSparkClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HdinsightSparkClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HdinsightSparkClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
