import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HealthcareServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#access_policy_object_ids HealthcareService#access_policy_object_ids}.
     *
     * @stability stable
     */
    readonly accessPolicyObjectIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#cosmosdb_key_vault_key_versionless_id HealthcareService#cosmosdb_key_vault_key_versionless_id}.
     *
     * @stability stable
     */
    readonly cosmosdbKeyVaultKeyVersionlessId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#cosmosdb_throughput HealthcareService#cosmosdb_throughput}.
     *
     * @stability stable
     */
    readonly cosmosdbThroughput?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#kind HealthcareService#kind}.
     *
     * @stability stable
     */
    readonly kind?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#location HealthcareService#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#name HealthcareService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#public_network_access_enabled HealthcareService#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#resource_group_name HealthcareService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#tags HealthcareService#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * authentication_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#authentication_configuration HealthcareService#authentication_configuration}
     *
     * @stability stable
     */
    readonly authenticationConfiguration?: HealthcareServiceAuthenticationConfiguration;
    /**
     * cors_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#cors_configuration HealthcareService#cors_configuration}
     *
     * @stability stable
     */
    readonly corsConfiguration?: HealthcareServiceCorsConfiguration;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#timeouts HealthcareService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HealthcareServiceTimeouts;
}
/**
 * @stability stable
 */
export interface HealthcareServiceAuthenticationConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#audience HealthcareService#audience}.
     *
     * @stability stable
     */
    readonly audience?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#authority HealthcareService#authority}.
     *
     * @stability stable
     */
    readonly authority?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#smart_proxy_enabled HealthcareService#smart_proxy_enabled}.
     *
     * @stability stable
     */
    readonly smartProxyEnabled?: boolean | cdktf.IResolvable;
}
export declare function healthcareServiceAuthenticationConfigurationToTerraform(struct?: HealthcareServiceAuthenticationConfigurationOutputReference | HealthcareServiceAuthenticationConfiguration): any;
/**
 * @stability stable
 */
export declare class HealthcareServiceAuthenticationConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HealthcareServiceAuthenticationConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HealthcareServiceAuthenticationConfiguration | undefined);
    private _audience?;
    /**
     * @stability stable
     */
    get audience(): string;
    /**
     * @stability stable
     */
    set audience(value: string);
    /**
     * @stability stable
     */
    resetAudience(): void;
    /**
     * @stability stable
     */
    get audienceInput(): string | undefined;
    private _authority?;
    /**
     * @stability stable
     */
    get authority(): string;
    /**
     * @stability stable
     */
    set authority(value: string);
    /**
     * @stability stable
     */
    resetAuthority(): void;
    /**
     * @stability stable
     */
    get authorityInput(): string | undefined;
    private _smartProxyEnabled?;
    /**
     * @stability stable
     */
    get smartProxyEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set smartProxyEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSmartProxyEnabled(): void;
    /**
     * @stability stable
     */
    get smartProxyEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface HealthcareServiceCorsConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#allow_credentials HealthcareService#allow_credentials}.
     *
     * @stability stable
     */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#allowed_headers HealthcareService#allowed_headers}.
     *
     * @stability stable
     */
    readonly allowedHeaders?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#allowed_methods HealthcareService#allowed_methods}.
     *
     * @stability stable
     */
    readonly allowedMethods?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#allowed_origins HealthcareService#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#max_age_in_seconds HealthcareService#max_age_in_seconds}.
     *
     * @stability stable
     */
    readonly maxAgeInSeconds?: number;
}
export declare function healthcareServiceCorsConfigurationToTerraform(struct?: HealthcareServiceCorsConfigurationOutputReference | HealthcareServiceCorsConfiguration): any;
/**
 * @stability stable
 */
export declare class HealthcareServiceCorsConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HealthcareServiceCorsConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HealthcareServiceCorsConfiguration | undefined);
    private _allowCredentials?;
    /**
     * @stability stable
     */
    get allowCredentials(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowCredentials(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowCredentials(): void;
    /**
     * @stability stable
     */
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedHeaders?;
    /**
     * @stability stable
     */
    get allowedHeaders(): string[];
    /**
     * @stability stable
     */
    set allowedHeaders(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedHeaders(): void;
    /**
     * @stability stable
     */
    get allowedHeadersInput(): string[] | undefined;
    private _allowedMethods?;
    /**
     * @stability stable
     */
    get allowedMethods(): string[];
    /**
     * @stability stable
     */
    set allowedMethods(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedMethods(): void;
    /**
     * @stability stable
     */
    get allowedMethodsInput(): string[] | undefined;
    private _allowedOrigins?;
    /**
     * @stability stable
     */
    get allowedOrigins(): string[];
    /**
     * @stability stable
     */
    set allowedOrigins(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedOrigins(): void;
    /**
     * @stability stable
     */
    get allowedOriginsInput(): string[] | undefined;
    private _maxAgeInSeconds?;
    /**
     * @stability stable
     */
    get maxAgeInSeconds(): number;
    /**
     * @stability stable
     */
    set maxAgeInSeconds(value: number);
    /**
     * @stability stable
     */
    resetMaxAgeInSeconds(): void;
    /**
     * @stability stable
     */
    get maxAgeInSecondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface HealthcareServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#create HealthcareService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#delete HealthcareService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#read HealthcareService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service#update HealthcareService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function healthcareServiceTimeoutsToTerraform(struct?: HealthcareServiceTimeoutsOutputReference | HealthcareServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class HealthcareServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HealthcareServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HealthcareServiceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service azurerm_healthcare_service}.
 *
 * @stability stable
 */
export declare class HealthcareService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/healthcare_service azurerm_healthcare_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HealthcareServiceConfig);
    private _accessPolicyObjectIds?;
    /**
     * @stability stable
     */
    get accessPolicyObjectIds(): string[];
    /**
     * @stability stable
     */
    set accessPolicyObjectIds(value: string[]);
    /**
     * @stability stable
     */
    resetAccessPolicyObjectIds(): void;
    /**
     * @stability stable
     */
    get accessPolicyObjectIdsInput(): string[] | undefined;
    private _cosmosdbKeyVaultKeyVersionlessId?;
    /**
     * @stability stable
     */
    get cosmosdbKeyVaultKeyVersionlessId(): string;
    /**
     * @stability stable
     */
    set cosmosdbKeyVaultKeyVersionlessId(value: string);
    /**
     * @stability stable
     */
    resetCosmosdbKeyVaultKeyVersionlessId(): void;
    /**
     * @stability stable
     */
    get cosmosdbKeyVaultKeyVersionlessIdInput(): string | undefined;
    private _cosmosdbThroughput?;
    /**
     * @stability stable
     */
    get cosmosdbThroughput(): number;
    /**
     * @stability stable
     */
    set cosmosdbThroughput(value: number);
    /**
     * @stability stable
     */
    resetCosmosdbThroughput(): void;
    /**
     * @stability stable
     */
    get cosmosdbThroughputInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _kind?;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    set kind(value: string);
    /**
     * @stability stable
     */
    resetKind(): void;
    /**
     * @stability stable
     */
    get kindInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _authenticationConfiguration;
    /**
     * @stability stable
     */
    get authenticationConfiguration(): HealthcareServiceAuthenticationConfigurationOutputReference;
    /**
     * @stability stable
     */
    putAuthenticationConfiguration(value: HealthcareServiceAuthenticationConfiguration): void;
    /**
     * @stability stable
     */
    resetAuthenticationConfiguration(): void;
    /**
     * @stability stable
     */
    get authenticationConfigurationInput(): HealthcareServiceAuthenticationConfiguration | undefined;
    private _corsConfiguration;
    /**
     * @stability stable
     */
    get corsConfiguration(): HealthcareServiceCorsConfigurationOutputReference;
    /**
     * @stability stable
     */
    putCorsConfiguration(value: HealthcareServiceCorsConfiguration): void;
    /**
     * @stability stable
     */
    resetCorsConfiguration(): void;
    /**
     * @stability stable
     */
    get corsConfigurationInput(): HealthcareServiceCorsConfiguration | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HealthcareServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HealthcareServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HealthcareServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
