import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IothubEndpointStorageContainerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#authentication_type IothubEndpointStorageContainer#authentication_type}.
     *
     * @stability stable
     */
    readonly authenticationType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#batch_frequency_in_seconds IothubEndpointStorageContainer#batch_frequency_in_seconds}.
     *
     * @stability stable
     */
    readonly batchFrequencyInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#connection_string IothubEndpointStorageContainer#connection_string}.
     *
     * @stability stable
     */
    readonly connectionString?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#container_name IothubEndpointStorageContainer#container_name}.
     *
     * @stability stable
     */
    readonly containerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#encoding IothubEndpointStorageContainer#encoding}.
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#endpoint_uri IothubEndpointStorageContainer#endpoint_uri}.
     *
     * @stability stable
     */
    readonly endpointUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#file_name_format IothubEndpointStorageContainer#file_name_format}.
     *
     * @stability stable
     */
    readonly fileNameFormat?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#identity_id IothubEndpointStorageContainer#identity_id}.
     *
     * @stability stable
     */
    readonly identityId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#iothub_id IothubEndpointStorageContainer#iothub_id}.
     *
     * @stability stable
     */
    readonly iothubId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#iothub_name IothubEndpointStorageContainer#iothub_name}.
     *
     * @stability stable
     */
    readonly iothubName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#max_chunk_size_in_bytes IothubEndpointStorageContainer#max_chunk_size_in_bytes}.
     *
     * @stability stable
     */
    readonly maxChunkSizeInBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#name IothubEndpointStorageContainer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#resource_group_name IothubEndpointStorageContainer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#timeouts IothubEndpointStorageContainer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IothubEndpointStorageContainerTimeouts;
}
/**
 * @stability stable
 */
export interface IothubEndpointStorageContainerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#create IothubEndpointStorageContainer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#delete IothubEndpointStorageContainer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#read IothubEndpointStorageContainer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container#update IothubEndpointStorageContainer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function iothubEndpointStorageContainerTimeoutsToTerraform(struct?: IothubEndpointStorageContainerTimeoutsOutputReference | IothubEndpointStorageContainerTimeouts): any;
/**
 * @stability stable
 */
export declare class IothubEndpointStorageContainerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IothubEndpointStorageContainerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IothubEndpointStorageContainerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container azurerm_iothub_endpoint_storage_container}.
 *
 * @stability stable
 */
export declare class IothubEndpointStorageContainer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_endpoint_storage_container azurerm_iothub_endpoint_storage_container} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IothubEndpointStorageContainerConfig);
    private _authenticationType?;
    /**
     * @stability stable
     */
    get authenticationType(): string;
    /**
     * @stability stable
     */
    set authenticationType(value: string);
    /**
     * @stability stable
     */
    resetAuthenticationType(): void;
    /**
     * @stability stable
     */
    get authenticationTypeInput(): string | undefined;
    private _batchFrequencyInSeconds?;
    /**
     * @stability stable
     */
    get batchFrequencyInSeconds(): number;
    /**
     * @stability stable
     */
    set batchFrequencyInSeconds(value: number);
    /**
     * @stability stable
     */
    resetBatchFrequencyInSeconds(): void;
    /**
     * @stability stable
     */
    get batchFrequencyInSecondsInput(): number | undefined;
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    set connectionString(value: string);
    /**
     * @stability stable
     */
    resetConnectionString(): void;
    /**
     * @stability stable
     */
    get connectionStringInput(): string | undefined;
    private _containerName?;
    /**
     * @stability stable
     */
    get containerName(): string;
    /**
     * @stability stable
     */
    set containerName(value: string);
    /**
     * @stability stable
     */
    get containerNameInput(): string | undefined;
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _endpointUri?;
    /**
     * @stability stable
     */
    get endpointUri(): string;
    /**
     * @stability stable
     */
    set endpointUri(value: string);
    /**
     * @stability stable
     */
    resetEndpointUri(): void;
    /**
     * @stability stable
     */
    get endpointUriInput(): string | undefined;
    private _fileNameFormat?;
    /**
     * @stability stable
     */
    get fileNameFormat(): string;
    /**
     * @stability stable
     */
    set fileNameFormat(value: string);
    /**
     * @stability stable
     */
    resetFileNameFormat(): void;
    /**
     * @stability stable
     */
    get fileNameFormatInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _identityId?;
    /**
     * @stability stable
     */
    get identityId(): string;
    /**
     * @stability stable
     */
    set identityId(value: string);
    /**
     * @stability stable
     */
    resetIdentityId(): void;
    /**
     * @stability stable
     */
    get identityIdInput(): string | undefined;
    private _iothubId?;
    /**
     * @stability stable
     */
    get iothubId(): string;
    /**
     * @stability stable
     */
    set iothubId(value: string);
    /**
     * @stability stable
     */
    resetIothubId(): void;
    /**
     * @stability stable
     */
    get iothubIdInput(): string | undefined;
    private _iothubName?;
    /**
     * @stability stable
     */
    get iothubName(): string;
    /**
     * @stability stable
     */
    set iothubName(value: string);
    /**
     * @stability stable
     */
    resetIothubName(): void;
    /**
     * @stability stable
     */
    get iothubNameInput(): string | undefined;
    private _maxChunkSizeInBytes?;
    /**
     * @stability stable
     */
    get maxChunkSizeInBytes(): number;
    /**
     * @stability stable
     */
    set maxChunkSizeInBytes(value: number);
    /**
     * @stability stable
     */
    resetMaxChunkSizeInBytes(): void;
    /**
     * @stability stable
     */
    get maxChunkSizeInBytesInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): IothubEndpointStorageContainerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IothubEndpointStorageContainerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IothubEndpointStorageContainerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
