import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KeyVaultCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#key_vault_id KeyVaultCertificate#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#name KeyVaultCertificate#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#tags KeyVaultCertificate#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#certificate KeyVaultCertificate#certificate}
     *
     * @stability stable
     */
    readonly certificate?: KeyVaultCertificateCertificate;
    /**
     * certificate_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#certificate_policy KeyVaultCertificate#certificate_policy}
     *
     * @stability stable
     */
    readonly certificatePolicy?: KeyVaultCertificateCertificatePolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#timeouts KeyVaultCertificate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KeyVaultCertificateTimeouts;
}
/**
 * @stability stable
 */
export declare class KeyVaultCertificateCertificateAttribute extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get created(): string;
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get expires(): string;
    /**
     * @stability stable
     */
    get notBefore(): string;
    /**
     * @stability stable
     */
    get recoveryLevel(): string;
    /**
     * @stability stable
     */
    get updated(): string;
}
/**
 * @stability stable
 */
export interface KeyVaultCertificateCertificate {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#contents KeyVaultCertificate#contents}.
     *
     * @stability stable
     */
    readonly contents: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#password KeyVaultCertificate#password}.
     *
     * @stability stable
     */
    readonly password?: string;
}
export declare function keyVaultCertificateCertificateToTerraform(struct?: KeyVaultCertificateCertificateOutputReference | KeyVaultCertificateCertificate): any;
/**
 * @stability stable
 */
export declare class KeyVaultCertificateCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultCertificateCertificate | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultCertificateCertificate | undefined);
    private _contents?;
    /**
     * @stability stable
     */
    get contents(): string;
    /**
     * @stability stable
     */
    set contents(value: string);
    /**
     * @stability stable
     */
    get contentsInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KeyVaultCertificateCertificatePolicyIssuerParameters {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#name KeyVaultCertificate#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function keyVaultCertificateCertificatePolicyIssuerParametersToTerraform(struct?: KeyVaultCertificateCertificatePolicyIssuerParametersOutputReference | KeyVaultCertificateCertificatePolicyIssuerParameters): any;
/**
 * @stability stable
 */
export declare class KeyVaultCertificateCertificatePolicyIssuerParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultCertificateCertificatePolicyIssuerParameters | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultCertificateCertificatePolicyIssuerParameters | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KeyVaultCertificateCertificatePolicyKeyProperties {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#curve KeyVaultCertificate#curve}.
     *
     * @stability stable
     */
    readonly curve?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#exportable KeyVaultCertificate#exportable}.
     *
     * @stability stable
     */
    readonly exportable: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#key_size KeyVaultCertificate#key_size}.
     *
     * @stability stable
     */
    readonly keySize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#key_type KeyVaultCertificate#key_type}.
     *
     * @stability stable
     */
    readonly keyType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#reuse_key KeyVaultCertificate#reuse_key}.
     *
     * @stability stable
     */
    readonly reuseKey: boolean | cdktf.IResolvable;
}
export declare function keyVaultCertificateCertificatePolicyKeyPropertiesToTerraform(struct?: KeyVaultCertificateCertificatePolicyKeyPropertiesOutputReference | KeyVaultCertificateCertificatePolicyKeyProperties): any;
/**
 * @stability stable
 */
export declare class KeyVaultCertificateCertificatePolicyKeyPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultCertificateCertificatePolicyKeyProperties | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultCertificateCertificatePolicyKeyProperties | undefined);
    private _curve?;
    /**
     * @stability stable
     */
    get curve(): string;
    /**
     * @stability stable
     */
    set curve(value: string);
    /**
     * @stability stable
     */
    resetCurve(): void;
    /**
     * @stability stable
     */
    get curveInput(): string | undefined;
    private _exportable?;
    /**
     * @stability stable
     */
    get exportable(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set exportable(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get exportableInput(): boolean | cdktf.IResolvable | undefined;
    private _keySize?;
    /**
     * @stability stable
     */
    get keySize(): number;
    /**
     * @stability stable
     */
    set keySize(value: number);
    /**
     * @stability stable
     */
    resetKeySize(): void;
    /**
     * @stability stable
     */
    get keySizeInput(): number | undefined;
    private _keyType?;
    /**
     * @stability stable
     */
    get keyType(): string;
    /**
     * @stability stable
     */
    set keyType(value: string);
    /**
     * @stability stable
     */
    get keyTypeInput(): string | undefined;
    private _reuseKey?;
    /**
     * @stability stable
     */
    get reuseKey(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set reuseKey(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get reuseKeyInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface KeyVaultCertificateCertificatePolicyLifetimeActionAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#action_type KeyVaultCertificate#action_type}.
     *
     * @stability stable
     */
    readonly actionType: string;
}
export declare function keyVaultCertificateCertificatePolicyLifetimeActionActionToTerraform(struct?: KeyVaultCertificateCertificatePolicyLifetimeActionActionOutputReference | KeyVaultCertificateCertificatePolicyLifetimeActionAction): any;
/**
 * @stability stable
 */
export declare class KeyVaultCertificateCertificatePolicyLifetimeActionActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultCertificateCertificatePolicyLifetimeActionAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultCertificateCertificatePolicyLifetimeActionAction | undefined);
    private _actionType?;
    /**
     * @stability stable
     */
    get actionType(): string;
    /**
     * @stability stable
     */
    set actionType(value: string);
    /**
     * @stability stable
     */
    get actionTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KeyVaultCertificateCertificatePolicyLifetimeActionTrigger {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#days_before_expiry KeyVaultCertificate#days_before_expiry}.
     *
     * @stability stable
     */
    readonly daysBeforeExpiry?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#lifetime_percentage KeyVaultCertificate#lifetime_percentage}.
     *
     * @stability stable
     */
    readonly lifetimePercentage?: number;
}
export declare function keyVaultCertificateCertificatePolicyLifetimeActionTriggerToTerraform(struct?: KeyVaultCertificateCertificatePolicyLifetimeActionTriggerOutputReference | KeyVaultCertificateCertificatePolicyLifetimeActionTrigger): any;
/**
 * @stability stable
 */
export declare class KeyVaultCertificateCertificatePolicyLifetimeActionTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultCertificateCertificatePolicyLifetimeActionTrigger | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultCertificateCertificatePolicyLifetimeActionTrigger | undefined);
    private _daysBeforeExpiry?;
    /**
     * @stability stable
     */
    get daysBeforeExpiry(): number;
    /**
     * @stability stable
     */
    set daysBeforeExpiry(value: number);
    /**
     * @stability stable
     */
    resetDaysBeforeExpiry(): void;
    /**
     * @stability stable
     */
    get daysBeforeExpiryInput(): number | undefined;
    private _lifetimePercentage?;
    /**
     * @stability stable
     */
    get lifetimePercentage(): number;
    /**
     * @stability stable
     */
    set lifetimePercentage(value: number);
    /**
     * @stability stable
     */
    resetLifetimePercentage(): void;
    /**
     * @stability stable
     */
    get lifetimePercentageInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface KeyVaultCertificateCertificatePolicyLifetimeAction {
    /**
     * action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#action KeyVaultCertificate#action}
     *
     * @stability stable
     */
    readonly action: KeyVaultCertificateCertificatePolicyLifetimeActionAction;
    /**
     * trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#trigger KeyVaultCertificate#trigger}
     *
     * @stability stable
     */
    readonly trigger: KeyVaultCertificateCertificatePolicyLifetimeActionTrigger;
}
export declare function keyVaultCertificateCertificatePolicyLifetimeActionToTerraform(struct?: KeyVaultCertificateCertificatePolicyLifetimeAction): any;
/**
 * @stability stable
 */
export interface KeyVaultCertificateCertificatePolicySecretProperties {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#content_type KeyVaultCertificate#content_type}.
     *
     * @stability stable
     */
    readonly contentType: string;
}
export declare function keyVaultCertificateCertificatePolicySecretPropertiesToTerraform(struct?: KeyVaultCertificateCertificatePolicySecretPropertiesOutputReference | KeyVaultCertificateCertificatePolicySecretProperties): any;
/**
 * @stability stable
 */
export declare class KeyVaultCertificateCertificatePolicySecretPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultCertificateCertificatePolicySecretProperties | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultCertificateCertificatePolicySecretProperties | undefined);
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    set contentType(value: string);
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#dns_names KeyVaultCertificate#dns_names}.
     *
     * @stability stable
     */
    readonly dnsNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#emails KeyVaultCertificate#emails}.
     *
     * @stability stable
     */
    readonly emails?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#upns KeyVaultCertificate#upns}.
     *
     * @stability stable
     */
    readonly upns?: string[];
}
export declare function keyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesToTerraform(struct?: KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesOutputReference | KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames): any;
/**
 * @stability stable
 */
export declare class KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames | undefined);
    private _dnsNames?;
    /**
     * @stability stable
     */
    get dnsNames(): string[];
    /**
     * @stability stable
     */
    set dnsNames(value: string[]);
    /**
     * @stability stable
     */
    resetDnsNames(): void;
    /**
     * @stability stable
     */
    get dnsNamesInput(): string[] | undefined;
    private _emails?;
    /**
     * @stability stable
     */
    get emails(): string[];
    /**
     * @stability stable
     */
    set emails(value: string[]);
    /**
     * @stability stable
     */
    resetEmails(): void;
    /**
     * @stability stable
     */
    get emailsInput(): string[] | undefined;
    private _upns?;
    /**
     * @stability stable
     */
    get upns(): string[];
    /**
     * @stability stable
     */
    set upns(value: string[]);
    /**
     * @stability stable
     */
    resetUpns(): void;
    /**
     * @stability stable
     */
    get upnsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface KeyVaultCertificateCertificatePolicyX509CertificateProperties {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#extended_key_usage KeyVaultCertificate#extended_key_usage}.
     *
     * @stability stable
     */
    readonly extendedKeyUsage?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#key_usage KeyVaultCertificate#key_usage}.
     *
     * @stability stable
     */
    readonly keyUsage: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#subject KeyVaultCertificate#subject}.
     *
     * @stability stable
     */
    readonly subject: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#validity_in_months KeyVaultCertificate#validity_in_months}.
     *
     * @stability stable
     */
    readonly validityInMonths: number;
    /**
     * subject_alternative_names block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#subject_alternative_names KeyVaultCertificate#subject_alternative_names}
     *
     * @stability stable
     */
    readonly subjectAlternativeNames?: KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames;
}
export declare function keyVaultCertificateCertificatePolicyX509CertificatePropertiesToTerraform(struct?: KeyVaultCertificateCertificatePolicyX509CertificatePropertiesOutputReference | KeyVaultCertificateCertificatePolicyX509CertificateProperties): any;
/**
 * @stability stable
 */
export declare class KeyVaultCertificateCertificatePolicyX509CertificatePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultCertificateCertificatePolicyX509CertificateProperties | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultCertificateCertificatePolicyX509CertificateProperties | undefined);
    private _extendedKeyUsage?;
    /**
     * @stability stable
     */
    get extendedKeyUsage(): string[];
    /**
     * @stability stable
     */
    set extendedKeyUsage(value: string[]);
    /**
     * @stability stable
     */
    resetExtendedKeyUsage(): void;
    /**
     * @stability stable
     */
    get extendedKeyUsageInput(): string[] | undefined;
    private _keyUsage?;
    /**
     * @stability stable
     */
    get keyUsage(): string[];
    /**
     * @stability stable
     */
    set keyUsage(value: string[]);
    /**
     * @stability stable
     */
    get keyUsageInput(): string[] | undefined;
    private _subject?;
    /**
     * @stability stable
     */
    get subject(): string;
    /**
     * @stability stable
     */
    set subject(value: string);
    /**
     * @stability stable
     */
    get subjectInput(): string | undefined;
    private _validityInMonths?;
    /**
     * @stability stable
     */
    get validityInMonths(): number;
    /**
     * @stability stable
     */
    set validityInMonths(value: number);
    /**
     * @stability stable
     */
    get validityInMonthsInput(): number | undefined;
    private _subjectAlternativeNames;
    /**
     * @stability stable
     */
    get subjectAlternativeNames(): KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesOutputReference;
    /**
     * @stability stable
     */
    putSubjectAlternativeNames(value: KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames): void;
    /**
     * @stability stable
     */
    resetSubjectAlternativeNames(): void;
    /**
     * @stability stable
     */
    get subjectAlternativeNamesInput(): KeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames | undefined;
}
/**
 * @stability stable
 */
export interface KeyVaultCertificateCertificatePolicy {
    /**
     * issuer_parameters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#issuer_parameters KeyVaultCertificate#issuer_parameters}
     *
     * @stability stable
     */
    readonly issuerParameters: KeyVaultCertificateCertificatePolicyIssuerParameters;
    /**
     * key_properties block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#key_properties KeyVaultCertificate#key_properties}
     *
     * @stability stable
     */
    readonly keyProperties: KeyVaultCertificateCertificatePolicyKeyProperties;
    /**
     * lifetime_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#lifetime_action KeyVaultCertificate#lifetime_action}
     *
     * @stability stable
     */
    readonly lifetimeAction?: KeyVaultCertificateCertificatePolicyLifetimeAction[];
    /**
     * secret_properties block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#secret_properties KeyVaultCertificate#secret_properties}
     *
     * @stability stable
     */
    readonly secretProperties: KeyVaultCertificateCertificatePolicySecretProperties;
    /**
     * x509_certificate_properties block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#x509_certificate_properties KeyVaultCertificate#x509_certificate_properties}
     *
     * @stability stable
     */
    readonly x509CertificateProperties?: KeyVaultCertificateCertificatePolicyX509CertificateProperties;
}
export declare function keyVaultCertificateCertificatePolicyToTerraform(struct?: KeyVaultCertificateCertificatePolicyOutputReference | KeyVaultCertificateCertificatePolicy): any;
/**
 * @stability stable
 */
export declare class KeyVaultCertificateCertificatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultCertificateCertificatePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultCertificateCertificatePolicy | undefined);
    private _issuerParameters;
    /**
     * @stability stable
     */
    get issuerParameters(): KeyVaultCertificateCertificatePolicyIssuerParametersOutputReference;
    /**
     * @stability stable
     */
    putIssuerParameters(value: KeyVaultCertificateCertificatePolicyIssuerParameters): void;
    /**
     * @stability stable
     */
    get issuerParametersInput(): KeyVaultCertificateCertificatePolicyIssuerParameters | undefined;
    private _keyProperties;
    /**
     * @stability stable
     */
    get keyProperties(): KeyVaultCertificateCertificatePolicyKeyPropertiesOutputReference;
    /**
     * @stability stable
     */
    putKeyProperties(value: KeyVaultCertificateCertificatePolicyKeyProperties): void;
    /**
     * @stability stable
     */
    get keyPropertiesInput(): KeyVaultCertificateCertificatePolicyKeyProperties | undefined;
    private _lifetimeAction?;
    /**
     * @stability stable
     */
    get lifetimeAction(): KeyVaultCertificateCertificatePolicyLifetimeAction[];
    /**
     * @stability stable
     */
    set lifetimeAction(value: KeyVaultCertificateCertificatePolicyLifetimeAction[]);
    /**
     * @stability stable
     */
    resetLifetimeAction(): void;
    /**
     * @stability stable
     */
    get lifetimeActionInput(): KeyVaultCertificateCertificatePolicyLifetimeAction[] | undefined;
    private _secretProperties;
    /**
     * @stability stable
     */
    get secretProperties(): KeyVaultCertificateCertificatePolicySecretPropertiesOutputReference;
    /**
     * @stability stable
     */
    putSecretProperties(value: KeyVaultCertificateCertificatePolicySecretProperties): void;
    /**
     * @stability stable
     */
    get secretPropertiesInput(): KeyVaultCertificateCertificatePolicySecretProperties | undefined;
    private _x509CertificateProperties;
    /**
     * @stability stable
     */
    get x509CertificateProperties(): KeyVaultCertificateCertificatePolicyX509CertificatePropertiesOutputReference;
    /**
     * @stability stable
     */
    putX509CertificateProperties(value: KeyVaultCertificateCertificatePolicyX509CertificateProperties): void;
    /**
     * @stability stable
     */
    resetX509CertificateProperties(): void;
    /**
     * @stability stable
     */
    get x509CertificatePropertiesInput(): KeyVaultCertificateCertificatePolicyX509CertificateProperties | undefined;
}
/**
 * @stability stable
 */
export interface KeyVaultCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#create KeyVaultCertificate#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#delete KeyVaultCertificate#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#read KeyVaultCertificate#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate#update KeyVaultCertificate#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function keyVaultCertificateTimeoutsToTerraform(struct?: KeyVaultCertificateTimeoutsOutputReference | KeyVaultCertificateTimeouts): any;
/**
 * @stability stable
 */
export declare class KeyVaultCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultCertificateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate azurerm_key_vault_certificate}.
 *
 * @stability stable
 */
export declare class KeyVaultCertificate extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_certificate azurerm_key_vault_certificate} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KeyVaultCertificateConfig);
    /**
     * @stability stable
     */
    certificateAttribute(index: string): KeyVaultCertificateCertificateAttribute;
    /**
     * @stability stable
     */
    get certificateData(): string;
    /**
     * @stability stable
     */
    get certificateDataBase64(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultId?;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    set keyVaultId(value: string);
    /**
     * @stability stable
     */
    get keyVaultIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secretId(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get thumbprint(): string;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    get versionlessId(): string;
    /**
     * @stability stable
     */
    get versionlessSecretId(): string;
    private _certificate;
    /**
     * @stability stable
     */
    get certificate(): KeyVaultCertificateCertificateOutputReference;
    /**
     * @stability stable
     */
    putCertificate(value: KeyVaultCertificateCertificate): void;
    /**
     * @stability stable
     */
    resetCertificate(): void;
    /**
     * @stability stable
     */
    get certificateInput(): KeyVaultCertificateCertificate | undefined;
    private _certificatePolicy;
    /**
     * @stability stable
     */
    get certificatePolicy(): KeyVaultCertificateCertificatePolicyOutputReference;
    /**
     * @stability stable
     */
    putCertificatePolicy(value: KeyVaultCertificateCertificatePolicy): void;
    /**
     * @stability stable
     */
    resetCertificatePolicy(): void;
    /**
     * @stability stable
     */
    get certificatePolicyInput(): KeyVaultCertificateCertificatePolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KeyVaultCertificateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KeyVaultCertificateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KeyVaultCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
