import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KustoAttachedDatabaseConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#cluster_name KustoAttachedDatabaseConfiguration#cluster_name}.
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#cluster_resource_id KustoAttachedDatabaseConfiguration#cluster_resource_id}.
     *
     * @stability stable
     */
    readonly clusterResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#database_name KustoAttachedDatabaseConfiguration#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#default_principal_modification_kind KustoAttachedDatabaseConfiguration#default_principal_modification_kind}.
     *
     * @stability stable
     */
    readonly defaultPrincipalModificationKind?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#location KustoAttachedDatabaseConfiguration#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#name KustoAttachedDatabaseConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#resource_group_name KustoAttachedDatabaseConfiguration#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * sharing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#sharing KustoAttachedDatabaseConfiguration#sharing}
     *
     * @stability stable
     */
    readonly sharing?: KustoAttachedDatabaseConfigurationSharing;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#timeouts KustoAttachedDatabaseConfiguration#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KustoAttachedDatabaseConfigurationTimeouts;
}
/**
 * @stability stable
 */
export interface KustoAttachedDatabaseConfigurationSharing {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#external_tables_to_exclude KustoAttachedDatabaseConfiguration#external_tables_to_exclude}.
     *
     * @stability stable
     */
    readonly externalTablesToExclude?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#external_tables_to_include KustoAttachedDatabaseConfiguration#external_tables_to_include}.
     *
     * @stability stable
     */
    readonly externalTablesToInclude?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#materialized_views_to_exclude KustoAttachedDatabaseConfiguration#materialized_views_to_exclude}.
     *
     * @stability stable
     */
    readonly materializedViewsToExclude?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#materialized_views_to_include KustoAttachedDatabaseConfiguration#materialized_views_to_include}.
     *
     * @stability stable
     */
    readonly materializedViewsToInclude?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#tables_to_exclude KustoAttachedDatabaseConfiguration#tables_to_exclude}.
     *
     * @stability stable
     */
    readonly tablesToExclude?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#tables_to_include KustoAttachedDatabaseConfiguration#tables_to_include}.
     *
     * @stability stable
     */
    readonly tablesToInclude?: string[];
}
export declare function kustoAttachedDatabaseConfigurationSharingToTerraform(struct?: KustoAttachedDatabaseConfigurationSharingOutputReference | KustoAttachedDatabaseConfigurationSharing): any;
/**
 * @stability stable
 */
export declare class KustoAttachedDatabaseConfigurationSharingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoAttachedDatabaseConfigurationSharing | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoAttachedDatabaseConfigurationSharing | undefined);
    private _externalTablesToExclude?;
    /**
     * @stability stable
     */
    get externalTablesToExclude(): string[];
    /**
     * @stability stable
     */
    set externalTablesToExclude(value: string[]);
    /**
     * @stability stable
     */
    resetExternalTablesToExclude(): void;
    /**
     * @stability stable
     */
    get externalTablesToExcludeInput(): string[] | undefined;
    private _externalTablesToInclude?;
    /**
     * @stability stable
     */
    get externalTablesToInclude(): string[];
    /**
     * @stability stable
     */
    set externalTablesToInclude(value: string[]);
    /**
     * @stability stable
     */
    resetExternalTablesToInclude(): void;
    /**
     * @stability stable
     */
    get externalTablesToIncludeInput(): string[] | undefined;
    private _materializedViewsToExclude?;
    /**
     * @stability stable
     */
    get materializedViewsToExclude(): string[];
    /**
     * @stability stable
     */
    set materializedViewsToExclude(value: string[]);
    /**
     * @stability stable
     */
    resetMaterializedViewsToExclude(): void;
    /**
     * @stability stable
     */
    get materializedViewsToExcludeInput(): string[] | undefined;
    private _materializedViewsToInclude?;
    /**
     * @stability stable
     */
    get materializedViewsToInclude(): string[];
    /**
     * @stability stable
     */
    set materializedViewsToInclude(value: string[]);
    /**
     * @stability stable
     */
    resetMaterializedViewsToInclude(): void;
    /**
     * @stability stable
     */
    get materializedViewsToIncludeInput(): string[] | undefined;
    private _tablesToExclude?;
    /**
     * @stability stable
     */
    get tablesToExclude(): string[];
    /**
     * @stability stable
     */
    set tablesToExclude(value: string[]);
    /**
     * @stability stable
     */
    resetTablesToExclude(): void;
    /**
     * @stability stable
     */
    get tablesToExcludeInput(): string[] | undefined;
    private _tablesToInclude?;
    /**
     * @stability stable
     */
    get tablesToInclude(): string[];
    /**
     * @stability stable
     */
    set tablesToInclude(value: string[]);
    /**
     * @stability stable
     */
    resetTablesToInclude(): void;
    /**
     * @stability stable
     */
    get tablesToIncludeInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface KustoAttachedDatabaseConfigurationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#create KustoAttachedDatabaseConfiguration#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#delete KustoAttachedDatabaseConfiguration#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#read KustoAttachedDatabaseConfiguration#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration#update KustoAttachedDatabaseConfiguration#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function kustoAttachedDatabaseConfigurationTimeoutsToTerraform(struct?: KustoAttachedDatabaseConfigurationTimeoutsOutputReference | KustoAttachedDatabaseConfigurationTimeouts): any;
/**
 * @stability stable
 */
export declare class KustoAttachedDatabaseConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoAttachedDatabaseConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoAttachedDatabaseConfigurationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration azurerm_kusto_attached_database_configuration}.
 *
 * @stability stable
 */
export declare class KustoAttachedDatabaseConfiguration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_attached_database_configuration azurerm_kusto_attached_database_configuration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KustoAttachedDatabaseConfigurationConfig);
    /**
     * @stability stable
     */
    get attachedDatabaseNames(): string[];
    private _clusterName?;
    /**
     * @stability stable
     */
    get clusterName(): string;
    /**
     * @stability stable
     */
    set clusterName(value: string);
    /**
     * @stability stable
     */
    get clusterNameInput(): string | undefined;
    private _clusterResourceId?;
    /**
     * @stability stable
     */
    get clusterResourceId(): string;
    /**
     * @stability stable
     */
    set clusterResourceId(value: string);
    /**
     * @stability stable
     */
    get clusterResourceIdInput(): string | undefined;
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _defaultPrincipalModificationKind?;
    /**
     * @stability stable
     */
    get defaultPrincipalModificationKind(): string;
    /**
     * @stability stable
     */
    set defaultPrincipalModificationKind(value: string);
    /**
     * @stability stable
     */
    resetDefaultPrincipalModificationKind(): void;
    /**
     * @stability stable
     */
    get defaultPrincipalModificationKindInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sharing;
    /**
     * @stability stable
     */
    get sharing(): KustoAttachedDatabaseConfigurationSharingOutputReference;
    /**
     * @stability stable
     */
    putSharing(value: KustoAttachedDatabaseConfigurationSharing): void;
    /**
     * @stability stable
     */
    resetSharing(): void;
    /**
     * @stability stable
     */
    get sharingInput(): KustoAttachedDatabaseConfigurationSharing | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KustoAttachedDatabaseConfigurationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KustoAttachedDatabaseConfigurationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KustoAttachedDatabaseConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
