import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KustoEventgridDataConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#blob_storage_event_type KustoEventgridDataConnection#blob_storage_event_type}.
     *
     * @stability stable
     */
    readonly blobStorageEventType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#cluster_name KustoEventgridDataConnection#cluster_name}.
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#data_format KustoEventgridDataConnection#data_format}.
     *
     * @stability stable
     */
    readonly dataFormat?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#database_name KustoEventgridDataConnection#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#eventhub_consumer_group_name KustoEventgridDataConnection#eventhub_consumer_group_name}.
     *
     * @stability stable
     */
    readonly eventhubConsumerGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#eventhub_id KustoEventgridDataConnection#eventhub_id}.
     *
     * @stability stable
     */
    readonly eventhubId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#location KustoEventgridDataConnection#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#mapping_rule_name KustoEventgridDataConnection#mapping_rule_name}.
     *
     * @stability stable
     */
    readonly mappingRuleName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#name KustoEventgridDataConnection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#resource_group_name KustoEventgridDataConnection#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#skip_first_record KustoEventgridDataConnection#skip_first_record}.
     *
     * @stability stable
     */
    readonly skipFirstRecord?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#storage_account_id KustoEventgridDataConnection#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#table_name KustoEventgridDataConnection#table_name}.
     *
     * @stability stable
     */
    readonly tableName?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#timeouts KustoEventgridDataConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KustoEventgridDataConnectionTimeouts;
}
/**
 * @stability stable
 */
export interface KustoEventgridDataConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#create KustoEventgridDataConnection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#delete KustoEventgridDataConnection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#read KustoEventgridDataConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection#update KustoEventgridDataConnection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function kustoEventgridDataConnectionTimeoutsToTerraform(struct?: KustoEventgridDataConnectionTimeoutsOutputReference | KustoEventgridDataConnectionTimeouts): any;
/**
 * @stability stable
 */
export declare class KustoEventgridDataConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoEventgridDataConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoEventgridDataConnectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection azurerm_kusto_eventgrid_data_connection}.
 *
 * @stability stable
 */
export declare class KustoEventgridDataConnection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_eventgrid_data_connection azurerm_kusto_eventgrid_data_connection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KustoEventgridDataConnectionConfig);
    private _blobStorageEventType?;
    /**
     * @stability stable
     */
    get blobStorageEventType(): string;
    /**
     * @stability stable
     */
    set blobStorageEventType(value: string);
    /**
     * @stability stable
     */
    resetBlobStorageEventType(): void;
    /**
     * @stability stable
     */
    get blobStorageEventTypeInput(): string | undefined;
    private _clusterName?;
    /**
     * @stability stable
     */
    get clusterName(): string;
    /**
     * @stability stable
     */
    set clusterName(value: string);
    /**
     * @stability stable
     */
    get clusterNameInput(): string | undefined;
    private _dataFormat?;
    /**
     * @stability stable
     */
    get dataFormat(): string;
    /**
     * @stability stable
     */
    set dataFormat(value: string);
    /**
     * @stability stable
     */
    resetDataFormat(): void;
    /**
     * @stability stable
     */
    get dataFormatInput(): string | undefined;
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _eventhubConsumerGroupName?;
    /**
     * @stability stable
     */
    get eventhubConsumerGroupName(): string;
    /**
     * @stability stable
     */
    set eventhubConsumerGroupName(value: string);
    /**
     * @stability stable
     */
    get eventhubConsumerGroupNameInput(): string | undefined;
    private _eventhubId?;
    /**
     * @stability stable
     */
    get eventhubId(): string;
    /**
     * @stability stable
     */
    set eventhubId(value: string);
    /**
     * @stability stable
     */
    get eventhubIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _mappingRuleName?;
    /**
     * @stability stable
     */
    get mappingRuleName(): string;
    /**
     * @stability stable
     */
    set mappingRuleName(value: string);
    /**
     * @stability stable
     */
    resetMappingRuleName(): void;
    /**
     * @stability stable
     */
    get mappingRuleNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _skipFirstRecord?;
    /**
     * @stability stable
     */
    get skipFirstRecord(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipFirstRecord(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipFirstRecord(): void;
    /**
     * @stability stable
     */
    get skipFirstRecordInput(): boolean | cdktf.IResolvable | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _tableName?;
    /**
     * @stability stable
     */
    get tableName(): string;
    /**
     * @stability stable
     */
    set tableName(value: string);
    /**
     * @stability stable
     */
    resetTableName(): void;
    /**
     * @stability stable
     */
    get tableNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KustoEventgridDataConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KustoEventgridDataConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KustoEventgridDataConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
