import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbNatPoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#backend_port LbNatPool#backend_port}.
     *
     * @stability stable
     */
    readonly backendPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#floating_ip_enabled LbNatPool#floating_ip_enabled}.
     *
     * @stability stable
     */
    readonly floatingIpEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#frontend_ip_configuration_name LbNatPool#frontend_ip_configuration_name}.
     *
     * @stability stable
     */
    readonly frontendIpConfigurationName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#frontend_port_end LbNatPool#frontend_port_end}.
     *
     * @stability stable
     */
    readonly frontendPortEnd: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#frontend_port_start LbNatPool#frontend_port_start}.
     *
     * @stability stable
     */
    readonly frontendPortStart: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#idle_timeout_in_minutes LbNatPool#idle_timeout_in_minutes}.
     *
     * @stability stable
     */
    readonly idleTimeoutInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#loadbalancer_id LbNatPool#loadbalancer_id}.
     *
     * @stability stable
     */
    readonly loadbalancerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#name LbNatPool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#protocol LbNatPool#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#resource_group_name LbNatPool#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#tcp_reset_enabled LbNatPool#tcp_reset_enabled}.
     *
     * @stability stable
     */
    readonly tcpResetEnabled?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#timeouts LbNatPool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LbNatPoolTimeouts;
}
/**
 * @stability stable
 */
export interface LbNatPoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#create LbNatPool#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#delete LbNatPool#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#read LbNatPool#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool#update LbNatPool#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function lbNatPoolTimeoutsToTerraform(struct?: LbNatPoolTimeoutsOutputReference | LbNatPoolTimeouts): any;
/**
 * @stability stable
 */
export declare class LbNatPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LbNatPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LbNatPoolTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool azurerm_lb_nat_pool}.
 *
 * @stability stable
 */
export declare class LbNatPool extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/lb_nat_pool azurerm_lb_nat_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbNatPoolConfig);
    private _backendPort?;
    /**
     * @stability stable
     */
    get backendPort(): number;
    /**
     * @stability stable
     */
    set backendPort(value: number);
    /**
     * @stability stable
     */
    get backendPortInput(): number | undefined;
    private _floatingIpEnabled?;
    /**
     * @stability stable
     */
    get floatingIpEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set floatingIpEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFloatingIpEnabled(): void;
    /**
     * @stability stable
     */
    get floatingIpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get frontendIpConfigurationId(): string;
    private _frontendIpConfigurationName?;
    /**
     * @stability stable
     */
    get frontendIpConfigurationName(): string;
    /**
     * @stability stable
     */
    set frontendIpConfigurationName(value: string);
    /**
     * @stability stable
     */
    get frontendIpConfigurationNameInput(): string | undefined;
    private _frontendPortEnd?;
    /**
     * @stability stable
     */
    get frontendPortEnd(): number;
    /**
     * @stability stable
     */
    set frontendPortEnd(value: number);
    /**
     * @stability stable
     */
    get frontendPortEndInput(): number | undefined;
    private _frontendPortStart?;
    /**
     * @stability stable
     */
    get frontendPortStart(): number;
    /**
     * @stability stable
     */
    set frontendPortStart(value: number);
    /**
     * @stability stable
     */
    get frontendPortStartInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _idleTimeoutInMinutes?;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutes(): number;
    /**
     * @stability stable
     */
    set idleTimeoutInMinutes(value: number);
    /**
     * @stability stable
     */
    resetIdleTimeoutInMinutes(): void;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutesInput(): number | undefined;
    private _loadbalancerId?;
    /**
     * @stability stable
     */
    get loadbalancerId(): string;
    /**
     * @stability stable
     */
    set loadbalancerId(value: string);
    /**
     * @stability stable
     */
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tcpResetEnabled?;
    /**
     * @stability stable
     */
    get tcpResetEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tcpResetEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTcpResetEnabled(): void;
    /**
     * @stability stable
     */
    get tcpResetEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LbNatPoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LbNatPoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LbNatPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
