import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogAnalyticsSolutionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#location LogAnalyticsSolution#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#resource_group_name LogAnalyticsSolution#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#solution_name LogAnalyticsSolution#solution_name}.
     *
     * @stability stable
     */
    readonly solutionName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#tags LogAnalyticsSolution#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#workspace_name LogAnalyticsSolution#workspace_name}.
     *
     * @stability stable
     */
    readonly workspaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#workspace_resource_id LogAnalyticsSolution#workspace_resource_id}.
     *
     * @stability stable
     */
    readonly workspaceResourceId: string;
    /**
     * plan block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#plan LogAnalyticsSolution#plan}
     *
     * @stability stable
     */
    readonly plan: LogAnalyticsSolutionPlan;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#timeouts LogAnalyticsSolution#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogAnalyticsSolutionTimeouts;
}
/**
 * @stability stable
 */
export interface LogAnalyticsSolutionPlan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#product LogAnalyticsSolution#product}.
     *
     * @stability stable
     */
    readonly product: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#promotion_code LogAnalyticsSolution#promotion_code}.
     *
     * @stability stable
     */
    readonly promotionCode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#publisher LogAnalyticsSolution#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
}
export declare function logAnalyticsSolutionPlanToTerraform(struct?: LogAnalyticsSolutionPlanOutputReference | LogAnalyticsSolutionPlan): any;
/**
 * @stability stable
 */
export declare class LogAnalyticsSolutionPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogAnalyticsSolutionPlan | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogAnalyticsSolutionPlan | undefined);
    private _product?;
    /**
     * @stability stable
     */
    get product(): string;
    /**
     * @stability stable
     */
    set product(value: string);
    /**
     * @stability stable
     */
    get productInput(): string | undefined;
    private _promotionCode?;
    /**
     * @stability stable
     */
    get promotionCode(): string;
    /**
     * @stability stable
     */
    set promotionCode(value: string);
    /**
     * @stability stable
     */
    resetPromotionCode(): void;
    /**
     * @stability stable
     */
    get promotionCodeInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogAnalyticsSolutionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#create LogAnalyticsSolution#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#delete LogAnalyticsSolution#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#read LogAnalyticsSolution#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution#update LogAnalyticsSolution#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logAnalyticsSolutionTimeoutsToTerraform(struct?: LogAnalyticsSolutionTimeoutsOutputReference | LogAnalyticsSolutionTimeouts): any;
/**
 * @stability stable
 */
export declare class LogAnalyticsSolutionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogAnalyticsSolutionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogAnalyticsSolutionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution azurerm_log_analytics_solution}.
 *
 * @stability stable
 */
export declare class LogAnalyticsSolution extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_solution azurerm_log_analytics_solution} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogAnalyticsSolutionConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _solutionName?;
    /**
     * @stability stable
     */
    get solutionName(): string;
    /**
     * @stability stable
     */
    set solutionName(value: string);
    /**
     * @stability stable
     */
    get solutionNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _workspaceName?;
    /**
     * @stability stable
     */
    get workspaceName(): string;
    /**
     * @stability stable
     */
    set workspaceName(value: string);
    /**
     * @stability stable
     */
    get workspaceNameInput(): string | undefined;
    private _workspaceResourceId?;
    /**
     * @stability stable
     */
    get workspaceResourceId(): string;
    /**
     * @stability stable
     */
    set workspaceResourceId(value: string);
    /**
     * @stability stable
     */
    get workspaceResourceIdInput(): string | undefined;
    private _plan;
    /**
     * @stability stable
     */
    get plan(): LogAnalyticsSolutionPlanOutputReference;
    /**
     * @stability stable
     */
    putPlan(value: LogAnalyticsSolutionPlan): void;
    /**
     * @stability stable
     */
    get planInput(): LogAnalyticsSolutionPlan | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogAnalyticsSolutionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogAnalyticsSolutionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogAnalyticsSolutionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
